/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.lang.reflect.Method;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.prefs.PrefService;
import org.scijava.script.History;
import org.scijava.script.ScriptInterpreter;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;

public class DefaultScriptInterpreter
implements ScriptInterpreter {
    private final ScriptLanguage language;
    private final ScriptEngine engine;
    private final History history;
    @Parameter(required=false)
    private PrefService prefs;
    @Parameter(required=false)
    private LogService log;
    private final StringBuilder buffer;
    private int pendingLineCount;
    private boolean expectingMoreInput;

    @Deprecated
    public DefaultScriptInterpreter(PrefService prefs, ScriptService scriptService, ScriptLanguage language) {
        this(language);
    }

    public DefaultScriptInterpreter(ScriptLanguage language) {
        this(language, null);
    }

    public DefaultScriptInterpreter(ScriptLanguage language, ScriptEngine engine) {
        language.getContext().inject(this);
        this.language = language;
        this.engine = engine == null ? language.getScriptEngine() : engine;
        this.history = this.prefs == null ? null : new History(this.prefs, this.engine.getClass().getName());
        this.readHistory();
        this.buffer = new StringBuilder();
        this.reset();
    }

    @Override
    public synchronized void readHistory() {
        if (this.history == null) {
            return;
        }
        this.history.read();
    }

    @Override
    public synchronized void writeHistory() {
        if (this.history == null) {
            return;
        }
        this.history.write();
    }

    @Override
    public synchronized String walkHistory(String currentCommand, boolean forward) {
        if (this.history == null) {
            return currentCommand;
        }
        this.history.replace(currentCommand);
        return forward ? this.history.next() : this.history.previous();
    }

    @Override
    public Object eval(String command) throws ScriptException {
        this.addToHistory(command);
        return this.engine.eval(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object interpret(String line) throws ScriptException {
        if (line.isEmpty() && !this.shouldEvaluatePendingInput(true)) {
            return MORE_INPUT_PENDING;
        }
        ++this.pendingLineCount;
        this.buffer.append(line);
        this.buffer.append("\n");
        if (!(this.engine instanceof Compilable)) {
            try {
                Object object = this.eval(this.buffer.toString());
                return object;
            }
            finally {
                this.reset();
            }
        }
        CompiledScript cs = this.tryCompiling(this.buffer.toString(), this.getPendingLineCount(), line.length());
        if (cs == null) {
            return MORE_INPUT_PENDING;
        }
        if (!this.shouldEvaluatePendingInput(line.isEmpty())) {
            return MORE_INPUT_PENDING;
        }
        try {
            this.addToHistory(this.buffer.toString());
            Object object = cs.eval();
            return object;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.buffer.setLength(0);
        this.pendingLineCount = 0;
        this.expectingMoreInput = false;
    }

    @Override
    public ScriptLanguage getLanguage() {
        return this.language;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }

    @Override
    public Bindings getBindings() {
        return this.engine.getBindings(100);
    }

    @Override
    public boolean isReady() {
        return this.buffer.length() == 0;
    }

    @Override
    public boolean isExpectingMoreInput() {
        return this.expectingMoreInput;
    }

    private void addToHistory(String command) {
        if (this.history != null) {
            this.history.add(command);
        }
    }

    private int getPendingLineCount() {
        return this.pendingLineCount;
    }

    private boolean shouldEvaluatePendingInput(boolean lineIsEmpty) {
        if (this.isExpectingMoreInput()) {
            return false;
        }
        return this.getPendingLineCount() == 1 || lineIsEmpty;
    }

    private CompiledScript tryCompiling(String string, int lineCount, int lastLineLength) throws ScriptException {
        CompiledScript result;
        block6: {
            result = null;
            try {
                Compilable c = (Compilable)((Object)this.engine);
                result = c.compile(string);
            }
            catch (ScriptException se) {
                boolean rethrow = true;
                if (se.getCause() != null) {
                    Integer line;
                    Integer col = this.columnNumber(se);
                    if (this.isLastCharacter(col, line = this.lineNumber(se), lineCount, lastLineLength)) {
                        rethrow = false;
                    } else if (this.log != null && this.log.isDebug()) {
                        String msg = se.getCause().getMessage();
                        this.log.debug("L" + line + " C" + col + "(" + lineCount + "," + lastLineLength + "): " + msg);
                        this.log.debug("in '" + string + "'");
                    }
                }
                if (!rethrow) break block6;
                this.reset();
                throw se;
            }
        }
        this.expectingMoreInput = result == null;
        return result;
    }

    private boolean isLastCharacter(Integer col, Integer line, int lineCount, int lastLineLength) {
        if (col == null || line == null) {
            return false;
        }
        int colNo = col;
        int lineNo = line;
        return lineNo == lineCount && colNo == lastLineLength || lineNo == lineCount + 1 && colNo == 0;
    }

    private Integer columnNumber(ScriptException se) {
        if (se.getColumnNumber() >= 0) {
            return se.getColumnNumber();
        }
        return DefaultScriptInterpreter.callMethod(se.getCause(), "columnNumber", Integer.class);
    }

    private Integer lineNumber(ScriptException se) {
        if (se.getLineNumber() >= 0) {
            return se.getLineNumber();
        }
        return DefaultScriptInterpreter.callMethod(se.getCause(), "lineNumber", Integer.class);
    }

    private static Method getMethod(Object object, String methodName) {
        try {
            return object.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static <T> T callMethod(Object object, String methodName, Class<T> cl) {
        try {
            Method m = DefaultScriptInterpreter.getMethod(object, methodName);
            if (m != null) {
                Object result = m.invoke(object, new Object[0]);
                return cl.cast(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

