/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.run;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.run.CodeRunner;
import org.scijava.run.RunService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultRunService
extends AbstractHandlerService<Object, CodeRunner>
implements RunService {
    @Parameter
    private LogService log;

    @Override
    public void run(Object code, Object ... args) throws InvocationTargetException {
        for (CodeRunner runner : this.getInstances()) {
            if (!runner.supports(code)) continue;
            runner.run(code, args);
            return;
        }
        throw new IllegalArgumentException("Unknown code type: " + code);
    }

    @Override
    public void run(Object code, Map<String, Object> inputMap) throws InvocationTargetException {
        for (CodeRunner runner : this.getInstances()) {
            if (!runner.supports(code)) continue;
            runner.run(code, inputMap);
            return;
        }
        throw new IllegalArgumentException("Unknown code type: " + code);
    }

    @Override
    public Class<CodeRunner> getPluginType() {
        return CodeRunner.class;
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }
}

