/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import org.scijava.convert.ConvertService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ConversionUtils;

@Plugin(type=PreprocessorPlugin.class, priority=-9999.0)
public class LoadInputsPreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private ConvertService conversionService;

    @Override
    public void process(Module module) {
        Iterable<ModuleItem<?>> inputs = module.getInfo().inputs();
        for (ModuleItem<?> item : inputs) {
            this.loadValue(module, item);
        }
    }

    private <T> void loadValue(Module module, ModuleItem<T> item) {
        if (module.isResolved(item.getName())) {
            return;
        }
        T prefValue = this.moduleService.load(item);
        Class<T> type = item.getType();
        T defaultValue = item.getValue(module);
        T value = this.getBestValue(prefValue, defaultValue, type);
        item.setValue(module, value);
    }

    private <T> T getBestValue(Object prefValue, Object defaultValue, Class<T> type) {
        if (prefValue != null) {
            return this.conversionService.convert(prefValue, type);
        }
        if (defaultValue != null) {
            return this.conversionService.convert(defaultValue, type);
        }
        return ConversionUtils.getNullValue(type);
    }
}

