/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

class ByteCodeAnalyzer {
    private byte[] buffer;
    private int[] poolOffsets;
    private int endOffset;
    private Attribute[] attributes;

    private ByteCodeAnalyzer(byte[] buffer) {
        this.buffer = buffer;
        if ((int)this.getU4(0) != -889275714) {
            throw new RuntimeException("No class");
        }
        this.getConstantPoolOffsets();
        this.endOffset += 8 + 2 * this.getU2(this.endOffset + 6);
        int fieldCount = this.getU2(this.endOffset);
        this.endOffset += 2;
        for (int i = 0; i < fieldCount; ++i) {
            this.endOffset = this.skipAttributes(this.endOffset + 6);
        }
        int methodCount = this.getU2(this.endOffset);
        this.endOffset += 2;
        for (int i = 0; i < methodCount; ++i) {
            this.endOffset = this.skipAttributes(this.endOffset + 6);
        }
        this.getAllAttributes();
    }

    private String getStringConstant(int index) {
        return this.getString(this.poolOffsets[index - 1]);
    }

    private long getIntegerConstant(int index) {
        int offset = this.poolOffsets[index - 1];
        if (this.getU1(offset) != 3) {
            throw new RuntimeException("Constant " + index + " does not refer to an integer");
        }
        return this.getU4(offset + 1);
    }

    private long getLongConstant(int index) {
        int offset = this.poolOffsets[index - 1];
        if (this.getU1(offset) != 5) {
            throw new RuntimeException("Constant " + index + " does not refer to a long");
        }
        return this.getU4(offset + 1) << 32 | this.getU4(offset + 5);
    }

    private float getFloatConstant(int index) {
        int offset = this.poolOffsets[index - 1];
        if (this.getU1(offset) != 4) {
            throw new RuntimeException("Constant " + index + " does not refer to a float");
        }
        return Float.intBitsToFloat((int)this.getU4(offset + 1));
    }

    private double getDoubleConstant(int index) {
        int offset = this.poolOffsets[index - 1];
        if (this.getU1(offset) != 6) {
            throw new RuntimeException("Constant " + index + " does not refer to a double");
        }
        return Double.longBitsToDouble(this.getU4(offset + 1) << 32 | this.getU4(offset + 5));
    }

    private void getConstantPoolOffsets() {
        int poolCount = this.getU2(8) - 1;
        this.poolOffsets = new int[poolCount];
        int offset = 10;
        for (int i = 0; i < poolCount; ++i) {
            this.poolOffsets[i] = offset;
            int tag = this.getU1(offset);
            if (tag == 7 || tag == 8 || tag == 16) {
                offset += 3;
                continue;
            }
            if (tag == 15) {
                offset += 4;
                continue;
            }
            if (tag == 3 || tag == 4 || tag == 9 || tag == 10 || tag == 11 || tag == 12 || tag == 18) {
                offset += 5;
                continue;
            }
            if (tag == 5 || tag == 6) {
                this.poolOffsets[++i] = offset;
                offset += 9;
                continue;
            }
            if (tag == 1) {
                offset += 3 + this.getU2(offset + 1);
                continue;
            }
            throw new RuntimeException("Unknown tag " + tag);
        }
        this.endOffset = offset;
    }

    private int getU1(int offset) {
        return ByteCodeAnalyzer.getU1(this.buffer, offset);
    }

    private int getU2(int offset) {
        return ByteCodeAnalyzer.getU2(this.buffer, offset);
    }

    private long getU4(int offset) {
        return ByteCodeAnalyzer.getU4(this.buffer, offset);
    }

    private static int getU1(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF;
    }

    private static int getU2(byte[] buffer, int offset) {
        return ByteCodeAnalyzer.getU1(buffer, offset) << 8 | ByteCodeAnalyzer.getU1(buffer, offset + 1);
    }

    private static long getU4(byte[] buffer, int offset) {
        return (long)ByteCodeAnalyzer.getU2(buffer, offset) << 16 | (long)ByteCodeAnalyzer.getU2(buffer, offset + 2);
    }

    private String getString(int offset) {
        try {
            return new String(this.buffer, offset + 3, this.getU2(offset + 1), "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    private int skipAttributes(int offset) {
        int count = this.getU2(offset);
        offset += 2;
        for (int i = 0; i < count; ++i) {
            offset = (int)((long)offset + (6L + this.getU4(offset + 2)));
        }
        return offset;
    }

    private void getAllAttributes() {
        this.attributes = this.getAttributes(this.endOffset);
    }

    private Attribute[] getAttributes(int offset) {
        Attribute[] result = new Attribute[this.getU2(offset)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Attribute(i == 0 ? offset + 2 : result[i - 1].attributeEndOffset);
        }
        return result;
    }

    private Map<String, Map<String, Object>> getAnnotations() {
        TreeMap<String, Map<String, Object>> annotations = new TreeMap<String, Map<String, Object>>();
        for (Attribute attr : this.attributes) {
            if (!"RuntimeVisibleAnnotations".equals(attr.getName())) continue;
            byte[] buf = attr.attribute;
            int count = ByteCodeAnalyzer.getU2(buf, 0);
            int offset = 2;
            for (int i = 0; i < count; ++i) {
                String className = ByteCodeAnalyzer.raw2className(this.getStringConstant(ByteCodeAnalyzer.getU2(buf, offset)));
                offset += 2;
                TreeMap<String, Object> values = new TreeMap<String, Object>();
                annotations.put(className, values);
                offset = this.parseAnnotationValues(buf, offset, values);
            }
        }
        return annotations;
    }

    private int parseAnnotationValues(byte[] buf, int offset, Map<String, Object> values) {
        int count = ByteCodeAnalyzer.getU2(buf, offset);
        offset += 2;
        for (int i = 0; i < count; ++i) {
            String key = this.getStringConstant(ByteCodeAnalyzer.getU2(buf, offset));
            offset += 2;
            offset = this.parseAnnotationValue(buf, offset, values, key);
        }
        return offset;
    }

    private int parseAnnotationValue(byte[] buf, int offset, Map<String, Object> map, String key) {
        Object value;
        switch (ByteCodeAnalyzer.getU1(buf, offset++)) {
            case 90: {
                value = this.getIntegerConstant(ByteCodeAnalyzer.getU2(buf, offset)) != 0L;
                offset += 2;
                break;
            }
            case 66: {
                value = (byte)this.getIntegerConstant(ByteCodeAnalyzer.getU2(buf, offset));
                offset += 2;
                break;
            }
            case 67: {
                value = Character.valueOf((char)this.getIntegerConstant(ByteCodeAnalyzer.getU2(buf, offset)));
                offset += 2;
                break;
            }
            case 83: {
                value = (short)this.getIntegerConstant(ByteCodeAnalyzer.getU2(buf, offset));
                offset += 2;
                break;
            }
            case 73: {
                value = (int)this.getIntegerConstant(ByteCodeAnalyzer.getU2(buf, offset));
                offset += 2;
                break;
            }
            case 74: {
                value = this.getLongConstant(ByteCodeAnalyzer.getU2(buf, offset));
                offset += 2;
                break;
            }
            case 70: {
                value = Float.valueOf(this.getFloatConstant(ByteCodeAnalyzer.getU2(buf, offset)));
                offset += 2;
                break;
            }
            case 68: {
                value = this.getDoubleConstant(ByteCodeAnalyzer.getU2(buf, offset));
                offset += 2;
                break;
            }
            case 115: {
                value = this.getStringConstant(ByteCodeAnalyzer.getU2(buf, offset));
                offset += 2;
                break;
            }
            case 99: {
                value = ByteCodeAnalyzer.raw2className(this.getStringConstant(ByteCodeAnalyzer.getU2(buf, offset)));
                offset += 2;
                break;
            }
            case 91: {
                Object[] array = new Object[ByteCodeAnalyzer.getU2(buf, offset)];
                offset += 2;
                for (int i = 0; i < array.length; ++i) {
                    offset = this.parseAnnotationValue(buf, offset, map, key);
                    array[i] = map.get(key);
                }
                value = array;
                break;
            }
            case 101: {
                TreeMap<String, String> enumValue = new TreeMap<String, String>();
                enumValue.put("enum", ByteCodeAnalyzer.raw2className(this.getStringConstant(ByteCodeAnalyzer.getU2(buf, offset))));
                enumValue.put("value", this.getStringConstant(ByteCodeAnalyzer.getU2(buf, offset += 2)));
                offset += 2;
                value = enumValue;
                break;
            }
            case 64: {
                offset += 2;
                Object[] values = new TreeMap();
                offset = this.parseAnnotationValues(buf, offset, (Map<String, Object>)values);
                value = values;
                break;
            }
            default: {
                throw new RuntimeException("Unhandled annotation value type: " + (char)ByteCodeAnalyzer.getU1(buf, offset - 1));
            }
        }
        if (value == null) {
            throw new NullPointerException();
        }
        map.put(key, value);
        return offset;
    }

    private static String raw2className(String rawName) {
        if (!rawName.startsWith("L") || !rawName.endsWith(";")) {
            throw new RuntimeException("Invalid raw class name: " + rawName);
        }
        return rawName.substring(1, rawName.length() - 1).replace('/', '.');
    }

    private static byte[] readFile(File file2) throws IOException {
        int count;
        FileInputStream in = new FileInputStream(file2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        while ((count = ((InputStream)in).read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        ((InputStream)in).close();
        out.close();
        return out.toByteArray();
    }

    static Map<String, Map<String, Object>> getAnnotations(File file2) throws IOException {
        return new ByteCodeAnalyzer(ByteCodeAnalyzer.readFile(file2)).getAnnotations();
    }

    private class Attribute {
        int nameIndex;
        byte[] attribute;
        int attributeEndOffset;

        private Attribute(int offset) {
            this.nameIndex = ByteCodeAnalyzer.this.getU2(offset);
            this.attribute = new byte[(int)ByteCodeAnalyzer.this.getU4(offset + 2)];
            System.arraycopy(ByteCodeAnalyzer.this.buffer, offset + 6, this.attribute, 0, this.attribute.length);
            this.attributeEndOffset = offset + 6 + this.attribute.length;
        }

        private String getName() {
            return ByteCodeAnalyzer.this.getStringConstant(this.nameIndex);
        }
    }
}

