/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.scijava.annotations.AbstractIndexWriter;
import org.scijava.annotations.Index;
import org.scijava.annotations.IndexItem;
import org.scijava.util.Combiner;
import org.scijava.util.FileUtils;

public class AnnotationCombiner
extends AbstractIndexWriter
implements Combiner {
    private static final String PREFIX = "META-INF/json/";
    private static final String LEGACY_PREFIX = "META-INF/annotations/";

    @Override
    public void combine(File outputDirectory) throws Exception {
        if (outputDirectory == null) {
            outputDirectory = new File("src/main/assembly/all");
        }
        Set<String> annotationFiles = this.getAnnotationFiles();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.log("");
        this.log("Writing annotations to " + outputDirectory.getAbsolutePath());
        new File(outputDirectory, PREFIX).mkdirs();
        for (String annotationFile : annotationFiles) {
            String annotationName = annotationFile.substring(PREFIX.length());
            Class<?> annotation = loader.loadClass(annotationName);
            for (IndexItem<?> item : Index.load(annotation, loader)) {
                this.add(this.adapt(item.annotation()), annotationName, item.className());
            }
        }
        this.write(new AnnotationStreamFactory(outputDirectory));
    }

    public Set<String> getAnnotationFiles() throws IOException {
        HashSet<String> files = new HashSet<String>();
        for (String prefix : new String[]{PREFIX, LEGACY_PREFIX}) {
            Enumeration<URL> directories = Thread.currentThread().getContextClassLoader().getResources(prefix);
            while (directories.hasMoreElements()) {
                URL url = directories.nextElement();
                for (URL annotationIndexURL : FileUtils.listContents(url)) {
                    String string = annotationIndexURL.toString();
                    if (string.endsWith("/")) continue;
                    int length = string.length();
                    this.add(files, PREFIX + string.substring(string.lastIndexOf(47, length - 1) + 1, length));
                }
            }
        }
        return files;
    }

    private void add(HashSet<String> set, String item) {
        this.log("\t" + item);
        set.add(item);
    }

    private void log(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] args) throws Exception {
        new AnnotationCombiner().combine(args.length > 0 ? new File(args[0]) : null);
    }

    private static class AnnotationStreamFactory
    implements AbstractIndexWriter.StreamFactory {
        private final File outputDirectory;

        public AnnotationStreamFactory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        @Override
        public InputStream openInput(String annotationName) throws IOException {
            return null;
        }

        @Override
        public OutputStream openOutput(String annotationName) throws IOException {
            File file2 = new File(this.outputDirectory, AnnotationCombiner.PREFIX + annotationName);
            return new FileOutputStream(file2);
        }

        @Override
        public boolean isClassObsolete(String className) {
            return false;
        }
    }
}

