/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.runnablequeue;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.logging.Logger;

public class RunnableQueue
implements Runnable {
    private static SynchronousQueue<Runnable> queue = new SynchronousQueue();

    @Override
    public void run() {
        try {
            if (Thread.currentThread().getContextClassLoader() == null) {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            }
            while (true) {
                Runnable task = queue.take();
                task.run();
            }
        }
        catch (InterruptedException e) {
            Logger.getLogger(this.getClass().getCanonicalName()).info("Exiting RunnableQueue.");
            return;
        }
    }

    public static void enqueue(Runnable runnable) throws InterruptedException {
        queue.put(new FutureTask<Object>(runnable, null));
    }

    public static boolean offer(Runnable runnable) {
        return queue.offer(runnable);
    }

    public static void execute(Runnable runnable) throws InterruptedException, ExecutionException {
        FutureTask<Object> future = new FutureTask<Object>(runnable, null);
        RunnableQueue.enqueue(future);
        future.get();
    }

    public static <V> V execute(Callable<V> callable) throws InterruptedException, ExecutionException {
        FutureTask<V> future = new FutureTask<V>(callable);
        RunnableQueue.enqueue(future);
        return future.get();
    }

    public static void stop() throws InterruptedException, ExecutionException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().interrupt();
            }
        };
        RunnableQueue.execute(r);
    }
}

