/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.preferences;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import net.imagej.options.OptionsMisc;
import net.imagej.updater.UpToDate;
import org.apache.commons.lang3.SystemUtils;
import org.cellprofiler.headlesspreferences.HeadlessPreferencesFactory;

class CellProfilerPreferences
extends Preferences {
    private static final Object lock = new Object();
    private static PreferencesFactory delegatePreferencesFactory = null;
    private static List<PreferenceOverride> overrides = new ArrayList<PreferenceOverride>();
    private static CellProfilerPreferences systemRoot;
    private static CellProfilerPreferences userRoot;
    private static final WeakHashMap<String, CellProfilerPreferences> systemMap;
    private static final WeakHashMap<String, CellProfilerPreferences> userMap;
    private final CellProfilerPreferences parent;
    private final Preferences delegate;
    private final WeakHashMap<String, CellProfilerPreferences> nodeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Preferences getSystemRoot() {
        WeakHashMap<String, CellProfilerPreferences> weakHashMap = systemMap;
        synchronized (weakHashMap) {
            if (!systemMap.containsKey("/")) {
                System.err.println("Accessing system root.");
                Thread.dumpStack();
                systemRoot = new CellProfilerPreferences(null, CellProfilerPreferences.getJREPreferencesFactory().systemRoot(), systemMap);
                systemMap.put("/", systemRoot);
            }
        }
        return systemRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Preferences getUserRoot() {
        WeakHashMap<String, CellProfilerPreferences> weakHashMap = userMap;
        synchronized (weakHashMap) {
            if (!userMap.containsKey("/")) {
                System.err.println("Accessing user root.");
                Thread.dumpStack();
                userRoot = new CellProfilerPreferences(null, CellProfilerPreferences.getJREPreferencesFactory().userRoot(), userMap);
                System.err.println("Got user root.");
                assert (userRoot.isUserNode());
                userMap.put("/", userRoot);
            }
        }
        return userRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CellProfilerPreferences retrieveNode(String path, WeakHashMap<String, CellProfilerPreferences> map) {
        WeakHashMap<String, CellProfilerPreferences> weakHashMap = map;
        synchronized (weakHashMap) {
            CellProfilerPreferences result = map.get(path);
            if (result == null) {
                CellProfilerPreferences root = map.get("/");
                Preferences delegate = root.delegate.node(path);
                int lastSlash = path.lastIndexOf("/");
                CellProfilerPreferences parent = null;
                parent = lastSlash == 0 ? root : CellProfilerPreferences.retrieveNode(path.substring(0, lastSlash), map);
                result = new CellProfilerPreferences(parent, delegate, map);
                map.put(path, result);
            }
            return result;
        }
    }

    CellProfilerPreferences(CellProfilerPreferences parent, Preferences delegate, WeakHashMap<String, CellProfilerPreferences> map) {
        CellProfilerPreferences.addOverride(UpToDate.class, "latestNag", Long.toString(Long.MAX_VALUE));
        CellProfilerPreferences.addOverride(OptionsMisc.class, "exitWhenQuitting", Boolean.toString(false));
        this.parent = parent;
        this.delegate = delegate;
        this.nodeMap = map;
    }

    @Override
    public void put(String key, String value) {
        this.delegate.put(key, value);
    }

    @Override
    public String get(String key, String def) {
        for (PreferenceOverride po : overrides) {
            if (!key.equals(po.key) || !this.absolutePath().equals(po.path)) continue;
            return po.value;
        }
        return this.delegate.get(key, def);
    }

    @Override
    public void remove(String key) {
        this.delegate.remove(key);
    }

    @Override
    public void clear() throws BackingStoreException {
        this.delegate.clear();
    }

    @Override
    public void putInt(String key, int value) {
        this.delegate.putInt(key, value);
    }

    @Override
    public int getInt(String key, int def) {
        return this.delegate.getInt(key, def);
    }

    @Override
    public void putLong(String key, long value) {
        this.delegate.putLong(key, value);
    }

    @Override
    public long getLong(String key, long def) {
        return this.delegate.getLong(key, def);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.delegate.putBoolean(key, value);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return this.delegate.getBoolean(key, def);
    }

    @Override
    public void putFloat(String key, float value) {
        this.delegate.putFloat(key, value);
    }

    @Override
    public float getFloat(String key, float def) {
        return this.delegate.getFloat(key, def);
    }

    @Override
    public void putDouble(String key, double value) {
        this.delegate.putDouble(key, value);
    }

    @Override
    public double getDouble(String key, double def) {
        return this.delegate.getDouble(key, def);
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.delegate.putByteArray(key, value);
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        return this.delegate.getByteArray(key, def);
    }

    @Override
    public String[] keys() throws BackingStoreException {
        ArrayList<String> k = new ArrayList<String>(Arrays.asList(this.delegate.keys()));
        for (PreferenceOverride po : overrides) {
            if (!po.path.equals(this.absolutePath())) continue;
            k.add(po.key);
        }
        return k.toArray(new String[0]);
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        ArrayList<String> k = new ArrayList<String>(Arrays.asList(this.delegate.childrenNames()));
        String absPath = this.absolutePath();
        block0: for (PreferenceOverride po : overrides) {
            int slashLoc;
            String path = po.path;
            if (path.indexOf(absPath) != 0) continue;
            while ((slashLoc = path.lastIndexOf(47)) > 0) {
                String child = path.substring(slashLoc + 1);
                if (!(path = path.substring(0, slashLoc)).equals(absPath)) continue;
                k.add(child);
                continue block0;
            }
        }
        return k.toArray(new String[0]);
    }

    @Override
    public Preferences parent() {
        return this.parent;
    }

    @Override
    public Preferences node(String pathName) {
        Preferences target = this.delegate.node(pathName);
        return CellProfilerPreferences.retrieveNode(target.absolutePath(), this.nodeMap);
    }

    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        return this.delegate.nodeExists(pathName);
    }

    @Override
    public void removeNode() throws BackingStoreException {
        this.delegate.removeNode();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public String absolutePath() {
        return this.delegate.absolutePath();
    }

    @Override
    public boolean isUserNode() {
        return this.nodeMap == userMap;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void flush() throws BackingStoreException {
        this.delegate.flush();
    }

    @Override
    public void sync() throws BackingStoreException {
        this.delegate.sync();
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        this.delegate.addPreferenceChangeListener(pcl);
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        this.delegate.removePreferenceChangeListener(pcl);
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener ncl) {
        this.delegate.addNodeChangeListener(ncl);
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener ncl) {
        this.delegate.removeNodeChangeListener(ncl);
    }

    @Override
    public void exportNode(OutputStream os) throws IOException, BackingStoreException {
        this.delegate.exportNode(os);
    }

    @Override
    public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
        this.delegate.exportSubtree(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PreferencesFactory getJREPreferencesFactory() {
        Object object = lock;
        synchronized (object) {
            block14: {
                if (delegatePreferencesFactory == null) {
                    ServiceLoader<PreferencesFactory> pfServiceLoader = ServiceLoader.loadInstalled(PreferencesFactory.class);
                    Iterator<PreferencesFactory> pfIter = pfServiceLoader.iterator();
                    if (pfIter.hasNext()) {
                        delegatePreferencesFactory = pfIter.next();
                    } else {
                        String pfName = SystemUtils.IS_OS_WINDOWS ? "java.util.prefs.WindowsPreferencesFactory" : "java.util.prefs.FilePreferencesFactory";
                        try {
                            Constructor<?>[] pfConstructors;
                            Class<?> pfClass = Class.forName("java.util.prefs.WindowsPreferencesFactory", false, null);
                            Class<?> pfFuckYou = Class.forName("java.util.prefs.WindowsPreferences", true, null);
                            for (Constructor<?> c : pfConstructors = pfClass.getDeclaredConstructors()) {
                                if (c.getParameterTypes().length != 0) continue;
                                c.setAccessible(true);
                                delegatePreferencesFactory = (PreferencesFactory)c.newInstance(new Object[0]);
                                break block14;
                            }
                            break block14;
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        delegatePreferencesFactory = new HeadlessPreferencesFactory();
                    }
                }
            }
        }
        return delegatePreferencesFactory;
    }

    private static void addOverride(Class<?> c, String key, String value) {
        String path = "/" + c.getPackage().getName().replace(".", "/");
        String prefKey = c.getSimpleName() + "." + key;
        PreferenceOverride override = new PreferenceOverride(path, prefKey, value);
        overrides.add(override);
    }

    static {
        systemMap = new WeakHashMap();
        userMap = new WeakHashMap();
    }

    static class PreferenceOverride {
        final String path;
        final String key;
        final String value;

        PreferenceOverride(String path, String key, String value) {
            this.path = path;
            this.key = key;
            this.value = value;
        }
    }
}

