/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset.filter;

import java.util.List;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.filter.AbstractImagePlaneDetailsPredicate;
import org.cellprofiler.imageset.filter.DoesNotPredicate;
import org.cellprofiler.imageset.filter.DoesPredicate;
import org.cellprofiler.imageset.filter.Filter;
import org.cellprofiler.imageset.filter.FilterPredicate;
import org.cellprofiler.imageset.filter.TokenParser;

public class MetadataPredicate
extends AbstractImagePlaneDetailsPredicate<ImagePlaneDetails>
implements TokenParser<ImagePlaneDetails, ImagePlaneDetails> {
    public static final String SYMBOL = "metadata";
    private List<FilterPredicate<ImagePlaneDetails, ?>> subpredicates;

    @Override
    public String getSymbol() {
        return SYMBOL;
    }

    @Override
    public void setSubpredicates(List<FilterPredicate<ImagePlaneDetails, ?>> subpredicates) throws Filter.BadFilterExpressionException {
        this.subpredicates = subpredicates;
    }

    @Override
    public void setLiteral(String literal) throws Filter.BadFilterExpressionException {
        throw new AssertionError((Object)"The metadata predicate does not accept a literal argument");
    }

    @Override
    public boolean eval(ImagePlaneDetails candidate) {
        return this.subpredicates.get(0).eval(candidate);
    }

    @Override
    public Class<ImagePlaneDetails> getOutputClass() {
        return ImagePlaneDetails.class;
    }

    @Override
    public FilterPredicate<ImagePlaneDetails, ?> parse(String token) {
        if (token.equals("does")) {
            return new MetadataDoesPredicate();
        }
        if (token.equals("doesnot")) {
            return new MetadataDoesNotPredicate();
        }
        throw new AssertionError((Object)"Do or do not, there is no try.");
    }

    static class MetadataDoesNotPredicate
    extends DoesNotPredicate<ImagePlaneDetails>
    implements TokenParser<ImagePlaneDetails, ImagePlaneDetails> {
        public MetadataDoesNotPredicate() {
            super(ImagePlaneDetails.class);
        }

        @Override
        public FilterPredicate<ImagePlaneDetails, ?> parse(String token) {
            return new MetadataKeyPredicate(token);
        }
    }

    static class MetadataDoesPredicate
    extends DoesPredicate<ImagePlaneDetails>
    implements TokenParser<ImagePlaneDetails, ImagePlaneDetails> {
        public MetadataDoesPredicate() {
            super(ImagePlaneDetails.class);
        }

        @Override
        public FilterPredicate<ImagePlaneDetails, ?> parse(String token) {
            return new MetadataKeyPredicate(token);
        }
    }

    static class MetadataKeyPredicate
    extends AbstractImagePlaneDetailsPredicate<String> {
        private final String key;
        private String value;

        public MetadataKeyPredicate(String key) {
            this.key = key;
        }

        @Override
        public String getSymbol() {
            return this.key;
        }

        @Override
        public void setSubpredicates(List<FilterPredicate<String, ?>> subpredicates) throws Filter.BadFilterExpressionException {
            throw new AssertionError((Object)"Metadata key predicates have literals, not subpredicates.");
        }

        @Override
        public void setLiteral(String literal) throws Filter.BadFilterExpressionException {
            this.value = literal;
        }

        @Override
        public boolean eval(ImagePlaneDetails candidate) {
            String value = candidate.get(this.key);
            return value != null && this.value.equals(value);
        }

        @Override
        public Class<String> getOutputClass() {
            return null;
        }
    }
}

