/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset.filter;

import java.util.List;
import org.cellprofiler.imageset.filter.Filter;
import org.cellprofiler.imageset.filter.FilterPredicate;

public abstract class LogicPredicate<TINOUT>
implements FilterPredicate<TINOUT, TINOUT> {
    final Class<TINOUT> klass;
    List<FilterPredicate<TINOUT, ?>> subpredicates;

    public LogicPredicate(Class<TINOUT> klass) {
        this.klass = klass;
    }

    @Override
    public void setLiteral(String literal) throws Filter.BadFilterExpressionException {
        throw new AssertionError((Object)"Logic predicates are not qualified by literals");
    }

    @Override
    protected abstract boolean eval(boolean[] var1);

    @Override
    public void setSubpredicates(List<FilterPredicate<TINOUT, ?>> subpredicates) throws Filter.BadFilterExpressionException {
        this.subpredicates = subpredicates;
    }

    @Override
    public boolean eval(TINOUT candidate) {
        boolean[] results = new boolean[this.subpredicates.size()];
        for (int i = 0; i < this.subpredicates.size(); ++i) {
            results[i] = this.subpredicates.get(i).eval(candidate);
        }
        return this.eval(results);
    }

    @Override
    public Class<TINOUT> getInputClass() {
        return this.klass;
    }

    @Override
    public Class<TINOUT> getOutputClass() {
        return this.klass;
    }
}

