/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cellprofiler.imageset.filter.AbstractTerminalPredicate;

public class IsJPEGPredicate
extends AbstractTerminalPredicate<String> {
    public static final String SYMBOL = "isjpeg";
    private static final Set<String> jpegExtensions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("jpg", "jpeg")));

    public IsJPEGPredicate() {
        super(String.class);
    }

    @Override
    public String getSymbol() {
        return SYMBOL;
    }

    @Override
    public boolean eval(String candidate) {
        return jpegExtensions.contains(candidate.toLowerCase());
    }
}

