/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import loci.formats.ImageReader;
import org.cellprofiler.imageset.filter.AbstractTerminalPredicate;

public class IsImagePredicate
extends AbstractTerminalPredicate<String> {
    public static final String SYMBOL = "isimage";
    static final HashSet<String> disallowedSuffixes = new HashSet<String>(Arrays.asList("cfg", "csv", "eps", "epsi", "htm", "html", "inf", "log", "ps", "txt", "wav", "xml", "zip"));
    private static Set<String> cachedImageSuffixes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getImageSuffixes() {
        HashSet<String> hashSet = disallowedSuffixes;
        synchronized (hashSet) {
            if (cachedImageSuffixes == null) {
                cachedImageSuffixes = new HashSet<String>(Arrays.asList(new ImageReader().getSuffixes()));
                cachedImageSuffixes.removeAll(disallowedSuffixes);
            }
        }
        return cachedImageSuffixes;
    }

    public IsImagePredicate() {
        super(String.class);
    }

    @Override
    public String getSymbol() {
        return SYMBOL;
    }

    @Override
    public boolean eval(String candidate) {
        return IsImagePredicate.getImageSuffixes().contains(candidate.toLowerCase());
    }
}

