/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset.filter;

import net.imglib2.meta.Axes;
import net.imglib2.meta.TypedAxis;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImagePlaneDetailsStack;
import org.cellprofiler.imageset.filter.AbstractTerminalPredicate;

public class IsColorPredicate
extends AbstractTerminalPredicate<ImagePlaneDetailsStack> {
    public static final String SYMBOL = "iscolor";

    protected IsColorPredicate() {
        super(ImagePlaneDetailsStack.class);
    }

    @Override
    public String getSymbol() {
        return SYMBOL;
    }

    @Override
    public boolean eval(ImagePlaneDetailsStack candidate) {
        for (int i = 0; i < candidate.numDimensions(); ++i) {
            if (!((TypedAxis)candidate.axis(i)).type().equals(Axes.CHANNEL)) continue;
            if (candidate.size(i) > 1) {
                return true;
            }
            for (ImagePlaneDetails ipd : candidate) {
                if (ipd.getImagePlane().getChannel() == -2) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

