/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cellprofiler.imageset.ImageFile;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImagePlaneDetailsStack;
import org.cellprofiler.imageset.filter.AndPredicate;
import org.cellprofiler.imageset.filter.ContainsPredicate;
import org.cellprofiler.imageset.filter.ContainsRegexpPredicate;
import org.cellprofiler.imageset.filter.DoesNotPredicate;
import org.cellprofiler.imageset.filter.DoesPredicate;
import org.cellprofiler.imageset.filter.EndsWithPredicate;
import org.cellprofiler.imageset.filter.EqualsPredicate;
import org.cellprofiler.imageset.filter.ExtensionPredicate;
import org.cellprofiler.imageset.filter.FileNamePredicate;
import org.cellprofiler.imageset.filter.FilterPredicate;
import org.cellprofiler.imageset.filter.ImagePlaneDetailsAdapter;
import org.cellprofiler.imageset.filter.ImagePredicate;
import org.cellprofiler.imageset.filter.IsColorPredicate;
import org.cellprofiler.imageset.filter.IsFlexPredicate;
import org.cellprofiler.imageset.filter.IsImagePredicate;
import org.cellprofiler.imageset.filter.IsJPEGPredicate;
import org.cellprofiler.imageset.filter.IsMonochromePredicate;
import org.cellprofiler.imageset.filter.IsMoviePredicate;
import org.cellprofiler.imageset.filter.IsPNGPredicate;
import org.cellprofiler.imageset.filter.IsStackFramePredicate;
import org.cellprofiler.imageset.filter.IsStackPredicate;
import org.cellprofiler.imageset.filter.IsTifPredicate;
import org.cellprofiler.imageset.filter.MetadataPredicate;
import org.cellprofiler.imageset.filter.OrPredicate;
import org.cellprofiler.imageset.filter.PathPredicate;
import org.cellprofiler.imageset.filter.StackAdapter;
import org.cellprofiler.imageset.filter.StartsWithPredicate;
import org.cellprofiler.imageset.filter.TokenParser;
import org.cellprofiler.imageset.filter.TokenParserStackAdapter;

public class Filter<C> {
    private static Pattern quoteEscapePattern = Pattern.compile("\\\\(.)");
    private static int nCachedEntries = 100;
    private static final Map<Class<?>, Map<String, Filter<?>>> filterCache = new HashMap();
    public static final Random random = new Random(0L);
    public final FilterPredicate<C, ?> rootPredicate;
    private final String expression;
    private final Class<C> klass;
    private static Pattern tokenPattern = Pattern.compile("((?:\\\\.|[^ )])+) ?");
    private static Pattern literalPattern = Pattern.compile("\"((?:[^\\\\\"]|(?:\\\\.))*)\" ?");
    private static Pattern endParenthesesPattern = Pattern.compile("\\)( |(?=\\))|$)");

    public static int getCachedEntryCount() {
        return nCachedEntries;
    }

    public static void setCachedEntryCount(int n) {
        nCachedEntries = n;
    }

    public Filter(String expression, Class<C> klass) throws BadFilterExpressionException {
        this.expression = expression;
        this.klass = klass;
        String[] rest = new String[1];
        this.rootPredicate = Filter.parse(expression, klass, rest);
    }

    public static <T> boolean filter(String expression, T candidate, Class<T> klass) throws BadFilterExpressionException {
        Filter<T> filter = Filter.getFilter(expression, klass);
        return filter.eval(candidate);
    }

    public boolean[] filterURLs(String[] urls) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, URISyntaxException {
        Constructor<C> c = this.klass.getConstructor(URI.class);
        boolean[] result = new boolean[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            C f = c.newInstance(new URI(url));
            result[i] = this.eval(f);
        }
        return result;
    }

    public static boolean filter(String expression, ImagePlaneDetails ipd) throws BadFilterExpressionException {
        return Filter.filter(expression, ipd, ImagePlaneDetails.class);
    }

    public static boolean filter(String expression, URI url) throws BadFilterExpressionException {
        return Filter.filter(expression, new ImageFile(url), ImageFile.class);
    }

    public static boolean filter(String expression, String url) throws BadFilterExpressionException, URISyntaxException {
        return Filter.filter(expression, new URI(url));
    }

    public static boolean filter(String expression, ImagePlaneDetailsStack stack) throws BadFilterExpressionException {
        return Filter.filter(expression, stack, ImagePlaneDetailsStack.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <CC> Filter<CC> getFilter(String expression, Class<CC> klass) throws BadFilterExpressionException {
        Map<Class<?>, Map<String, Filter<?>>> map = filterCache;
        synchronized (map) {
            Map<String, Filter<?>> classFilterCache;
            if (!filterCache.containsKey(klass)) {
                filterCache.put(klass, new HashMap());
            }
            if (!(classFilterCache = filterCache.get(klass)).containsKey(expression)) {
                if (classFilterCache.size() >= nCachedEntries) {
                    int halfSize = classFilterCache.size() / 2;
                    ArrayList<String> expressions = new ArrayList<String>(classFilterCache.keySet());
                    for (int i = 0; i < halfSize; ++i) {
                        int idx = random.nextInt(expressions.size());
                        classFilterCache.remove(expressions.get(idx));
                        expressions.remove(idx);
                    }
                }
                Filter<CC> filter = new Filter<CC>(expression, klass);
                classFilterCache.put(expression, filter);
                return filter;
            }
            return Filter.cast(classFilterCache.get(expression), klass);
        }
    }

    public boolean eval(C candidate) {
        return this.rootPredicate.eval(candidate);
    }

    private static <T> FilterPredicate<T, ?> cast(FilterPredicate<?, ?> p, Class<T> klass) throws BadFilterExpressionException {
        if (!p.getInputClass().isAssignableFrom(klass)) {
            throw new BadFilterExpressionException(String.format("The %s predicate expects a %s as an input, not %s", p.getSymbol(), p.getInputClass().getName(), klass.getName()));
        }
        return p;
    }

    private static <T> Filter<T> cast(Filter<?> f, Class<T> klass) throws BadFilterExpressionException {
        FilterPredicate p = f.rootPredicate;
        if (!p.getInputClass().isAssignableFrom(klass)) {
            throw new BadFilterExpressionException(String.format("The %s predicate expects a %s as an input, not %s", p.getSymbol(), p.getInputClass().getName(), klass.getName()));
        }
        return f;
    }

    private static <T> FilterPredicate<T, ?> get(String key, Class<T> klass) throws BadFilterExpressionException {
        if (key.equals("and")) {
            return new AndPredicate<T>(klass);
        }
        if (key.equals("or")) {
            return new OrPredicate<T>(klass);
        }
        if (key.equals("does")) {
            return new DoesPredicate<T>(klass);
        }
        if (key.equals("doesnot")) {
            return new DoesNotPredicate<T>(klass);
        }
        if (klass.isAssignableFrom(ImagePlaneDetailsStack.class)) {
            if (key.equals("image")) {
                return Filter.cast(new ImagePredicate(), klass);
            }
            if (key.equals("iscolor")) {
                return Filter.cast(new IsColorPredicate(), klass);
            }
            if (key.equals("ismonochrome")) {
                return Filter.cast(new IsMonochromePredicate(), klass);
            }
            if (key.equals("isstack")) {
                return Filter.cast(new IsStackPredicate(), klass);
            }
            if (key.equals("isstackframe")) {
                return Filter.cast(new IsStackFramePredicate(), klass);
            }
            FilterPredicate<ImagePlaneDetails, ?> predicate = Filter.get(key, ImagePlaneDetails.class);
            if (predicate instanceof TokenParser) {
                return Filter.cast(TokenParserStackAdapter.makeAdapter((TokenParser)predicate), klass);
            }
            return Filter.cast(StackAdapter.makeAdapter(predicate), klass);
        }
        if (klass.isAssignableFrom(ImagePlaneDetails.class)) {
            if (key.equals("metadata")) {
                return Filter.cast(new MetadataPredicate(), klass);
            }
            return Filter.cast(ImagePlaneDetailsAdapter.makeAdapter(Filter.get(key, ImageFile.class)), klass);
        }
        if (klass.isAssignableFrom(ImageFile.class)) {
            if (key.equals("file")) {
                return Filter.cast(new FileNamePredicate(), klass);
            }
            if (key.equals("directory")) {
                return Filter.cast(new PathPredicate(), klass);
            }
            if (key.equals("extension")) {
                return Filter.cast(new ExtensionPredicate(), klass);
            }
        }
        if (klass.isAssignableFrom(String.class)) {
            if (key.equals("contain")) {
                return Filter.cast(new ContainsPredicate(), klass);
            }
            if (key.equals("containregexp")) {
                return Filter.cast(new ContainsRegexpPredicate(), klass);
            }
            if (key.equals("endwith")) {
                return Filter.cast(new EndsWithPredicate(), klass);
            }
            if (key.equals("eq")) {
                return Filter.cast(new EqualsPredicate(), klass);
            }
            if (key.equals("startwith")) {
                return Filter.cast(new StartsWithPredicate(), klass);
            }
            if (key.equals("isflex")) {
                return Filter.cast(new IsFlexPredicate(), klass);
            }
            if (key.equals("isimage")) {
                return Filter.cast(new IsImagePredicate(), klass);
            }
            if (key.equals("isjpeg")) {
                return Filter.cast(new IsJPEGPredicate(), klass);
            }
            if (key.equals("ismovie")) {
                return Filter.cast(new IsMoviePredicate(), klass);
            }
            if (key.equals("ispng")) {
                return Filter.cast(new IsPNGPredicate(), klass);
            }
            if (key.equals("istif")) {
                return Filter.cast(new IsTifPredicate(), klass);
            }
        }
        throw new BadFilterExpressionException(String.format("No applicable predicate for token %s", key));
    }

    private static <T> FilterPredicate<T, ?> parse(String expression, Class<T> klass, String[] rest) throws BadFilterExpressionException {
        return Filter.parse(expression, klass, rest, null);
    }

    private static <T> FilterPredicate<T, ?> parse(String expression, Class<T> klass, String[] rest, TokenParser<?, T> tokenParser) throws BadFilterExpressionException {
        FilterPredicate<T, ?> p;
        String token = Filter.getToken(expression, rest);
        FilterPredicate<T, ?> filterPredicate = p = tokenParser == null ? Filter.get(token, klass) : tokenParser.parse(token);
        if (rest[0].length() > 0) {
            Matcher literalMatch = literalPattern.matcher(rest[0]);
            if (literalMatch.lookingAt()) {
                String literal = literalMatch.group(1);
                String decodedLiteral = Filter.escapeDecode(literal);
                p.setLiteral(decodedLiteral);
                rest[0] = rest[0].substring(literalMatch.end());
                if (rest[0].length() == 0) {
                    return p;
                }
            }
            if (rest[0].charAt(0) == ')') {
                return p;
            }
            if (rest[0].charAt(0) == '(') {
                Filter.parseSubpredicates(rest[0], rest, p);
            } else {
                Filter.parseSubpredicate(rest[0], rest, p);
            }
        }
        return p;
    }

    private static String escapeDecode(String literal) {
        Matcher quoteEscapeMatch = quoteEscapePattern.matcher(literal);
        String decodedLiteral = "";
        int start = 0;
        while (quoteEscapeMatch.find()) {
            int qeStart = quoteEscapeMatch.start();
            String qeChar = quoteEscapeMatch.group(1);
            decodedLiteral = decodedLiteral + literal.substring(start, qeStart) + qeChar;
            start = quoteEscapeMatch.end();
        }
        decodedLiteral = decodedLiteral + literal.substring(start);
        return decodedLiteral;
    }

    static String getToken(String expression, String[] rest) throws BadFilterExpressionException {
        Matcher match = tokenPattern.matcher(expression);
        if (!match.lookingAt()) {
            throw new BadFilterExpressionException("Failed to parse the next token");
        }
        String token = Filter.escapeDecode(match.group(1));
        rest[0] = expression.substring(match.end());
        return token;
    }

    private static <T> void parseSubpredicates(String expression, String[] rest, FilterPredicate<?, T> p) throws BadFilterExpressionException {
        ArrayList subpredicates = new ArrayList();
        rest[0] = expression;
        while (rest[0].length() > 0 && rest[0].charAt(0) == '(') {
            String subexpression = rest[0].substring(1);
            if (p instanceof TokenParser) {
                TokenParser tp = (TokenParser)p;
                subpredicates.add(Filter.parse(subexpression, p.getOutputClass(), rest, tp));
            } else {
                subpredicates.add(Filter.parse(subexpression, p.getOutputClass(), rest));
            }
            Matcher endParenthesesMatch = endParenthesesPattern.matcher(rest[0]);
            if (!endParenthesesMatch.lookingAt()) {
                throw new BadFilterExpressionException("Missing end parenthesis");
            }
            rest[0] = rest[0].substring(endParenthesesMatch.end());
        }
        p.setSubpredicates(subpredicates);
    }

    private static <T> void parseSubpredicate(String expression, String[] rest, FilterPredicate<?, T> p) throws BadFilterExpressionException {
        ArrayList subpredicates = new ArrayList();
        if (p instanceof TokenParser) {
            TokenParser tp = (TokenParser)p;
            subpredicates.add(Filter.parse(rest[0], p.getOutputClass(), rest, tp));
        } else {
            subpredicates.add(Filter.parse(rest[0], p.getOutputClass(), rest));
        }
        p.setSubpredicates(subpredicates);
    }

    public String toString() {
        return String.format("Filter: %s", this.expression);
    }

    public static class BadFilterExpressionException
    extends Exception {
        private static final long serialVersionUID = -3134183711783453007L;
        public int offset;
        public String expression;
        private String reason;

        public BadFilterExpressionException(String message, String expression, int offset) {
            super(String.format("%s: %s->%s", message, expression.substring(0, offset), expression.substring(offset)));
            this.offset = offset;
            this.expression = expression;
            this.reason = message;
        }

        public BadFilterExpressionException(String message) {
            super(message);
        }

        public void rethrow(String expression, int offset) throws BadFilterExpressionException {
            throw new BadFilterExpressionException(this.reason, expression, this.offset + offset);
        }
    }
}

