/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.MetadataExtractor;
import org.cellprofiler.imageset.StringCache;

public class WellMetadataExtractor
implements MetadataExtractor<ImagePlaneDetails> {
    public static final String WELL = "Well";
    private static final List<String> rowKeys = Arrays.asList("wellrow", "well_row", "row");
    private static final List<String> columnKeys = Arrays.asList("wellcol", "well_col", "wellcolumn", "well_column", "column", "col");
    private static final List<String> metadataKeys = Collections.singletonList("Well");

    @Override
    public Map<String, String> extract(ImagePlaneDetails source) {
        String wellRow = null;
        String wellColumn = null;
        for (String key : source) {
            String lcKey = key.toLowerCase();
            if (lcKey.equals("well")) {
                return emptyMap;
            }
            if (rowKeys.contains(lcKey)) {
                wellRow = source.get(key);
                continue;
            }
            if (!columnKeys.contains(lcKey)) continue;
            wellColumn = source.get(key);
        }
        if (wellRow != null && wellColumn != null) {
            int rowIndex;
            if (wellRow.matches("\\d+") && (rowIndex = Integer.parseInt(wellRow)) > 0 && rowIndex <= 24) {
                wellRow = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".substring(rowIndex - 1, rowIndex);
            }
            return Collections.singletonMap(WELL, StringCache.intern(wellRow + wellColumn));
        }
        return emptyMap;
    }

    @Override
    public List<String> getMetadataKeys() {
        return metadataKeys;
    }

    public static boolean maybeYouNeedThis(List<String> keys) {
        block0: for (List targetList : new List[]{rowKeys, columnKeys}) {
            for (String key : keys) {
                if (!targetList.contains(key.toLowerCase())) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }
}

