/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cellprofiler.imageset.ImagePlane;
import org.cellprofiler.imageset.MetadataExtractor;
import org.cellprofiler.imageset.StringCache;

public class URLSeriesIndexMetadataExtractor
implements MetadataExtractor<ImagePlane> {
    public static final String SERIES_TAG = "Series";
    public static final String INDEX_TAG = "Frame";
    public static final String URL_TAG = "FileLocation";
    private static final String ZERO = "0";
    private static final List<String> metadataKeys = Collections.unmodifiableList(Arrays.asList("FileLocation", "Series", "Frame"));

    @Override
    public Map<String, String> extract(ImagePlane source) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        int series = source.getSeries().getSeries();
        int index = source.getIndex();
        result.put(URL_TAG, StringCache.intern(source.getImageFile().getURI().toString()));
        result.put(SERIES_TAG, series == 0 ? ZERO : StringCache.intern(Integer.toString(series)));
        result.put(INDEX_TAG, index == 0 ? ZERO : StringCache.intern(Integer.toString(index)));
        return result;
    }

    @Override
    public List<String> getMetadataKeys() {
        return metadataKeys;
    }
}

