/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cellprofiler.imageset.MetadataExtractor;
import org.cellprofiler.imageset.MetadataUtils;
import org.cellprofiler.imageset.StringCache;

public class RegexpMetadataExtractor
implements MetadataExtractor<String> {
    private final Pattern pattern;
    private final String[] keys;
    private final List<String> metadataKeys;

    public RegexpMetadataExtractor(String pattern) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> metadataKeys = new ArrayList<String>();
        this.pattern = MetadataUtils.compilePythonRegexp(pattern, keys);
        this.keys = new String[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (key == null) {
                this.keys[i] = null;
                continue;
            }
            this.keys[i] = StringCache.intern(key);
            metadataKeys.add(key);
        }
        this.metadataKeys = Collections.unmodifiableList(metadataKeys);
    }

    @Override
    public Map<String, String> extract(String source) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = this.pattern.matcher(source);
        if (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String value = matcher.group(i + 1);
                if (value == null || this.keys[i] == null) continue;
                map.put(this.keys[i], StringCache.intern(value));
            }
        }
        return map;
    }

    @Override
    public List<String> getMetadataKeys() {
        return this.metadataKeys;
    }
}

