/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.imglib2.meta.AbstractTypedSpace;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.DefaultTypedAxis;
import net.imglib2.meta.TypedAxis;

public class PlaneStack<T>
extends AbstractTypedSpace<TypedAxis>
implements Iterable<T> {
    private final int[] dims;
    private final Map<List<Integer>, T> planes;
    public static final TypedAxis[] XYAxes = new TypedAxis[]{new DefaultTypedAxis(Axes.X), new DefaultTypedAxis(Axes.Y)};
    public static final TypedAxis[] XYCAxes = new TypedAxis[]{new DefaultTypedAxis(Axes.X), new DefaultTypedAxis(Axes.Y), new DefaultTypedAxis(Axes.CHANNEL)};
    public static final String OBJECT_PLANE_AXIS_NAME = "ObjectPlane";
    public static final AxisType OBJECT_PLANE_AXIS_TYPE = Axes.get("ObjectPlane", false);
    public static final TypedAxis[] XYOAxes = new TypedAxis[]{new DefaultTypedAxis(Axes.X), new DefaultTypedAxis(Axes.Y), new DefaultTypedAxis(OBJECT_PLANE_AXIS_TYPE)};

    public PlaneStack(T plane) {
        this(XYAxes);
        this.add(plane, 0, 0);
    }

    public PlaneStack(TypedAxis ... axes) {
        super(axes);
        this.dims = new int[axes.length];
        this.planes = new HashMap<List<Integer>, T>();
    }

    public void add(T plane, int ... coords) {
        List<Integer> key = PlaneStack.makeKey(coords);
        this.planes.put(key, plane);
        for (int i = 0; i < this.numDimensions(); ++i) {
            if (coords[i] < this.dims[i]) continue;
            this.dims[i] = coords[i] + 1;
        }
    }

    private static List<Integer> makeKey(int ... coords) {
        ArrayList<Integer> key = new ArrayList<Integer>(coords.length);
        for (int coord : coords) {
            key.add(coord);
        }
        return key;
    }

    public T get(int ... coords) {
        List<Integer> key = PlaneStack.makeKey(coords);
        return this.planes.get(key);
    }

    public int size(int d) {
        return this.dims[d];
    }

    public int getPlaneCount() {
        return this.planes.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.planes.values().iterator();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName());
        result.append(" Axes: ");
        for (int i = 0; i < this.numDimensions(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(((TypedAxis)this.axis(i)).type().toString());
        }
        result.append(" Planes: ");
        result.append(this.planes.toString());
        return result.toString();
    }
}

