/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.xml.model.Image;
import ome.xml.model.Pixels;
import ome.xml.model.Plate;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import org.cellprofiler.imageset.ImageSeries;
import org.cellprofiler.imageset.MetadataExtractor;
import org.cellprofiler.imageset.StringCache;

public class OMESeriesMetadataExtractor
implements MetadataExtractor<ImageSeries> {
    public static final String MD_SIZE_X = "SizeX";
    public static final String MD_SIZE_Y = "SizeY";
    public static final String MD_SIZE_C = "SizeC";
    public static final String MD_SIZE_T = "SizeT";
    public static final String MD_SIZE_Z = "SizeZ";
    public static final String MD_SITE = "Site";
    public static final String MD_WELL = "Well";
    public static final String MD_PLATE = "Plate";
    private static final List<String> metadataKeys = Collections.unmodifiableList(Arrays.asList("SizeX", "SizeY", "SizeC", "SizeT", "SizeZ", "Site", "Well", "Plate"));

    @Override
    public Map<String, String> extract(ImageSeries source) {
        HashMap<String, String> map = new HashMap<String, String>();
        Image image = source.getOMEImage();
        if (image != null) {
            Pixels pixels = image.getPixels();
            OMESeriesMetadataExtractor.putIfNotNull(map, MD_SIZE_X, pixels.getSizeX());
            OMESeriesMetadataExtractor.putIfNotNull(map, MD_SIZE_Y, pixels.getSizeY());
            OMESeriesMetadataExtractor.putIfNotNull(map, MD_SIZE_C, pixels.getSizeC());
            OMESeriesMetadataExtractor.putIfNotNull(map, MD_SIZE_T, pixels.getSizeT());
            OMESeriesMetadataExtractor.putIfNotNull(map, MD_SIZE_Z, pixels.getSizeZ());
            if (image.sizeOfLinkedWellSampleList() == 1) {
                WellSample wellSample = image.getLinkedWellSample(0);
                OMESeriesMetadataExtractor.putIfNotNull(map, MD_SITE, wellSample.getIndex());
                Well well = wellSample.getWell();
                if (well != null) {
                    map.put(MD_WELL, OMESeriesMetadataExtractor.getWellName((Integer)well.getRow().getValue(), (Integer)well.getColumn().getValue()));
                    Plate plate = well.getPlate();
                    if (plate != null) {
                        map.put(MD_PLATE, well.getPlate().getName());
                    }
                }
            }
        } else {
            map.put(MD_SIZE_C, StringCache.intern("1"));
            map.put(MD_SIZE_T, StringCache.intern("1"));
            map.put(MD_SIZE_Z, StringCache.intern("1"));
        }
        return map;
    }

    private static <T> void putIfNotNull(Map<String, String> map, String key, T value) {
        if (value != null) {
            map.put(key, StringCache.intern(value.toString()));
        }
    }

    private static String getWellName(int rowIdx, int colIdx) {
        String rowName = "";
        while (rowIdx >= 26) {
            rowName = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt((rowIdx -= 26) % 26) + rowName;
            rowIdx /= 26;
        }
        rowName = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(rowIdx % 26) + rowName;
        return String.format("%s%02d", rowName, colIdx);
    }

    @Override
    public List<String> getMetadataKeys() {
        return metadataKeys;
    }
}

