/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import org.cellprofiler.imageset.ImagePlane;
import org.cellprofiler.imageset.MetadataExtractor;
import org.cellprofiler.imageset.StringCache;

public class OMEPlaneMetadataExtractor
implements MetadataExtractor<ImagePlane> {
    public static final String CH_ALPHA = "Alpha";
    public static final String CH_GREEN = "Green";
    public static final String CH_RED = "Red";
    public static final String CH_BLUE = "Blue";
    public static final String MD_C = "C";
    public static final String MD_T = "T";
    public static final String MD_Z = "Z";
    public static final String MD_COLOR_FORMAT = "ColorFormat";
    public static final String MD_RGB = "RGB";
    public static final String MD_MONOCHROME = "monochrome";
    public static final String MD_PLANAR = "Planar";
    public static final String MD_CHANNEL_NAME = "ChannelName";
    private static final List<String> metadataKeys = Collections.unmodifiableList(Arrays.asList("C", "T", "Z", "ColorFormat", "ChannelName"));

    @Override
    public Map<String, String> extract(ImagePlane source) {
        Plane plane = source.getOMEPlane();
        Image image = source.getSeries().getOMEImage();
        if (image == null) {
            return emptyMap;
        }
        Pixels pixels = image.getPixels();
        HashMap<String, String> map = new HashMap<String, String>();
        if (plane != null) {
            OMEPlaneMetadataExtractor.putIfNotNull(map, MD_C, plane.getTheC().toString());
            OMEPlaneMetadataExtractor.putIfNotNull(map, MD_T, plane.getTheT().toString());
            OMEPlaneMetadataExtractor.putIfNotNull(map, MD_Z, plane.getTheZ().toString());
            NonNegativeInteger c = plane.getTheC();
            if (c != null) {
                Channel channel;
                int cidx = (Integer)c.getValue();
                if (pixels.sizeOfChannelList() > cidx && (channel = pixels.getChannel(cidx)) != null) {
                    OMEPlaneMetadataExtractor.putIfNotNull(map, MD_CHANNEL_NAME, channel.getName());
                    PositiveInteger samplesPerPixel = channel.getSamplesPerPixel();
                    if (samplesPerPixel != null) {
                        int nSamplesPerPixel = (Integer)samplesPerPixel.getValue();
                        map.put(MD_COLOR_FORMAT, nSamplesPerPixel == 1 ? MD_MONOCHROME : MD_RGB);
                    }
                }
            }
        } else {
            if (pixels != null) {
                if ((Integer)pixels.getSizeC().getValue() == 1) {
                    map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                    Channel channel = pixels.getChannel(0);
                    if (channel != null) {
                        OMEPlaneMetadataExtractor.putIfNotNull(map, MD_CHANNEL_NAME, channel.getName());
                    }
                } else if (pixels.sizeOfChannelList() == 1) {
                    map.put(MD_COLOR_FORMAT, MD_RGB);
                } else {
                    map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                    Channel channel = pixels.getChannel(source.theC());
                    if (channel != null) {
                        OMEPlaneMetadataExtractor.putIfNotNull(map, MD_CHANNEL_NAME, channel.getName());
                    }
                }
            } else {
                int channel = source.getChannel();
                switch (channel) {
                    case -2: {
                        map.put(MD_COLOR_FORMAT, MD_RGB);
                        break;
                    }
                    case -1: {
                        map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                        break;
                    }
                    case 2: {
                        map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                        map.put(MD_CHANNEL_NAME, CH_BLUE);
                        break;
                    }
                    case 0: {
                        map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                        map.put(MD_CHANNEL_NAME, CH_RED);
                        break;
                    }
                    case 1: {
                        map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                        map.put(MD_CHANNEL_NAME, CH_GREEN);
                        break;
                    }
                    case 3: {
                        map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                        map.put(MD_CHANNEL_NAME, CH_ALPHA);
                        break;
                    }
                    default: {
                        map.put(MD_COLOR_FORMAT, MD_MONOCHROME);
                    }
                }
            }
            if ((Integer)pixels.getSizeT().getValue() > 1) {
                map.put(MD_T, StringCache.intern(Integer.toString(source.getIndex())));
            } else if ((Integer)pixels.getSizeZ().getValue() > 1) {
                map.put(MD_Z, StringCache.intern(Integer.toString(source.getIndex())));
            }
        }
        return map;
    }

    private static void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, StringCache.intern(value));
        }
    }

    @Override
    public List<String> getMetadataKeys() {
        return metadataKeys;
    }
}

