/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.enums.DimensionOrder;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImagePlaneDetailsStack;
import org.cellprofiler.imageset.ImageSet;

public class MetadataUtils {
    private static final Pattern pythonGroupPattern = Pattern.compile("(\\\\\\\\)|(\\\\\\()|(((\\(\\?P<([^>]+)>)|(\\((?!\\?P<))))");

    static Map<String, List<String>> getImageSetMetadata(List<ImageSet> imageSets, Map<String, Integer> mustHave, Map<String, Comparator<String>> comparators) {
        int nrows = imageSets.size();
        if (nrows == 0) {
            return Collections.emptyMap();
        }
        ArrayList result = new ArrayList();
        HashSet<String> badMetadata = new HashSet<String>();
        HashSet<String> keysSeen = new HashSet<String>();
        for (ImageSet imageSet : imageSets) {
            HashMap<String, String> imageSetMetadata = new HashMap<String, String>();
            result.add(imageSetMetadata);
            for (Map.Entry<String, Integer> entry : mustHave.entrySet()) {
                ImagePlaneDetailsStack imagePlaneDetailsStack = (ImagePlaneDetailsStack)imageSet.get(entry.getValue());
                for (ImagePlaneDetails ipd : imagePlaneDetailsStack) {
                    String key;
                    if (!ipd.containsKey(key = entry.getKey())) continue;
                    imageSetMetadata.put(key, ipd.get(key));
                }
            }
            for (ImagePlaneDetailsStack stack : imageSet) {
                for (ImagePlaneDetails ipd : stack) {
                    for (String key : ipd) {
                        if (badMetadata.contains(key) || mustHave.containsKey(key)) continue;
                        String value = ipd.get(key);
                        String oldValue = (String)imageSetMetadata.get(key);
                        if (oldValue != null && comparators != null) {
                            Comparator<String> c = comparators.get(key);
                            if (c != null) {
                                if (c.compare(value, oldValue) != 0) {
                                    badMetadata.add(key);
                                    continue;
                                }
                            } else if (!value.equals(oldValue)) {
                                badMetadata.add(key);
                                continue;
                            }
                        }
                        imageSetMetadata.put(key, value);
                        keysSeen.add(key);
                    }
                }
            }
        }
        keysSeen.removeAll(badMetadata);
        keysSeen.addAll(mustHave.keySet());
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        for (String key : keysSeen) {
            ArrayList values = new ArrayList(imageSets.size());
            for (Map map : result) {
                values.add(map.get(key));
            }
            output.put(key, values);
        }
        return output;
    }

    public static Pattern compilePythonRegexp(String pattern, List<String> keys) {
        Matcher matcher = pythonGroupPattern.matcher(pattern);
        String p = "";
        int start = 0;
        while (matcher.find()) {
            if (matcher.group(1) != null || matcher.group(2) != null) {
                p = p + pattern.substring(start, matcher.end());
                start = matcher.end();
                continue;
            }
            p = p + pattern.substring(start, matcher.start() + 1);
            if (keys != null) {
                if (matcher.group(6) != null) {
                    keys.add(matcher.group(6));
                } else if (!pattern.substring(matcher.end(), matcher.end() + 1).equals("?")) {
                    keys.add(null);
                }
            }
            start = matcher.end();
        }
        p = p + pattern.substring(start);
        return Pattern.compile(p);
    }

    public static int getIndex(Pixels pixels, int c, int z, int t) {
        DimensionOrder dimensionOrder = pixels.getDimensionOrder();
        switch (dimensionOrder) {
            case XYCTZ: {
                return c + (Integer)pixels.getSizeC().getValue() * (t + (Integer)pixels.getSizeT().getValue() * z);
            }
            case XYCZT: {
                return c + (Integer)pixels.getSizeC().getValue() * (z + (Integer)pixels.getSizeZ().getValue() * t);
            }
            case XYTCZ: {
                return t + (Integer)pixels.getSizeT().getValue() * (c + (Integer)pixels.getSizeC().getValue() * z);
            }
            case XYTZC: {
                return t + (Integer)pixels.getSizeT().getValue() * (z + (Integer)pixels.getSizeZ().getValue() * c);
            }
            case XYZCT: {
                return z + (Integer)pixels.getSizeZ().getValue() * (c + (Integer)pixels.getSizeC().getValue() * t);
            }
            case XYZTC: {
                return z + (Integer)pixels.getSizeZ().getValue() * (t + (Integer)pixels.getSizeT().getValue() * c);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported dimension order: %s", dimensionOrder.toString()));
    }

    public static int getIndex(Plane plane) {
        return MetadataUtils.getIndex(plane.getPixels(), (Integer)plane.getTheC().getValue(), (Integer)plane.getTheZ().getValue(), (Integer)plane.getTheT().getValue());
    }

    public static int getZ(Pixels pixels, int index) {
        Integer sizeC = (Integer)pixels.getSizeC().getValue();
        Integer sizeT = (Integer)pixels.getSizeT().getValue();
        Integer sizeZ = (Integer)pixels.getSizeZ().getValue();
        DimensionOrder dimensionOrder = pixels.getDimensionOrder();
        switch (dimensionOrder) {
            case XYCTZ: 
            case XYTCZ: {
                return index / (sizeC * sizeT);
            }
            case XYCZT: {
                return index / sizeC % sizeZ;
            }
            case XYTZC: {
                return index / sizeT % sizeZ;
            }
            case XYZCT: 
            case XYZTC: {
                return index % sizeZ;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported dimension order: %s", dimensionOrder.toString()));
    }

    public static int getC(Pixels pixels, int index) {
        Integer sizeC = (Integer)pixels.getSizeC().getValue();
        Integer sizeT = (Integer)pixels.getSizeT().getValue();
        Integer sizeZ = (Integer)pixels.getSizeZ().getValue();
        DimensionOrder dimensionOrder = pixels.getDimensionOrder();
        switch (dimensionOrder) {
            case XYTZC: 
            case XYZTC: {
                return index / (sizeZ * sizeT);
            }
            case XYZCT: {
                return index / sizeZ % sizeC;
            }
            case XYTCZ: {
                return index / sizeT % sizeC;
            }
            case XYCTZ: 
            case XYCZT: {
                return index % sizeC;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported dimension order: %s", dimensionOrder.toString()));
    }

    public static int getT(Pixels pixels, int index) {
        Integer sizeC = (Integer)pixels.getSizeC().getValue();
        Integer sizeT = (Integer)pixels.getSizeT().getValue();
        Integer sizeZ = (Integer)pixels.getSizeZ().getValue();
        DimensionOrder dimensionOrder = pixels.getDimensionOrder();
        switch (dimensionOrder) {
            case XYCZT: 
            case XYZCT: {
                return index / (sizeZ * sizeC);
            }
            case XYZTC: {
                return index / sizeZ % sizeT;
            }
            case XYCTZ: {
                return index / sizeC % sizeT;
            }
            case XYTCZ: 
            case XYTZC: {
                return index % sizeT;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported dimension order: %s", dimensionOrder.toString()));
    }
}

