/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.text.Collator;
import java.util.Comparator;

public class MetadataKeyPair {
    public final String leftKey;
    public final String rightKey;
    public final Comparator<String> comparator;

    public MetadataKeyPair(String csvKey, String ipdKey, Comparator<String> comparator) {
        this.leftKey = csvKey;
        this.rightKey = ipdKey;
        this.comparator = comparator;
    }

    private static Comparator<String> adapt(final Comparator<Object> c) {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return c.compare(o1, o2);
            }
        };
    }

    public static Comparator<String> getCaseSensitiveComparator() {
        Collator c = Collator.getInstance();
        c.setStrength(3);
        return MetadataKeyPair.adapt(c);
    }

    public static Comparator<String> getCaseInsensitiveComparator() {
        Collator c = Collator.getInstance();
        c.setStrength(1);
        return MetadataKeyPair.adapt(c);
    }

    public static Comparator<String> getNumericComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                return Double.valueOf(o1).compareTo(Double.valueOf(o2));
            }
        };
    }

    public static MetadataKeyPair makeCaseSensitiveKeyPair(String csvKey, String ipdKey) {
        return new MetadataKeyPair(csvKey, ipdKey, MetadataKeyPair.getCaseSensitiveComparator());
    }

    public static MetadataKeyPair makeCaseInsensitiveKeyPair(String csvKey, String ipdKey) {
        return new MetadataKeyPair(csvKey, ipdKey, MetadataKeyPair.getCaseInsensitiveComparator());
    }

    public static MetadataKeyPair makeNumericKeyPair(String csvKey, String ipdKey) {
        return new MetadataKeyPair(csvKey, ipdKey, MetadataKeyPair.getNumericComparator());
    }
}

