/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.cellprofiler.imageset.ChannelFilter;
import org.cellprofiler.imageset.ImageFile;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImagePlaneDetailsStack;
import org.cellprofiler.imageset.ImageSet;
import org.cellprofiler.imageset.ImageSetDuplicateError;
import org.cellprofiler.imageset.ImageSetError;
import org.cellprofiler.imageset.ImageSetMissingError;
import org.cellprofiler.imageset.ListComparator;
import org.cellprofiler.imageset.MetadataKeyPair;

public class Joiner {
    private final Comparator<List<String>> imageSetKeyComparator;
    private static final Logger logger = Logger.getLogger(Joiner.class.getCanonicalName());
    private final ChannelFilter anchorChannel;
    private final List<String> keys;
    private final List<Join> joinedChannels = new ArrayList<Join>();

    public Joiner(ChannelFilter anchorChannel, List<String> keys, List<Comparator<String>> comparators) {
        this.anchorChannel = anchorChannel;
        this.keys = keys;
        this.imageSetKeyComparator = new ListComparator<String>(comparators);
    }

    public void addChannel(ChannelFilter channelFilter, List<MetadataKeyPair> joiningKeys) {
        this.joinedChannels.add(new Join(channelFilter, joiningKeys));
    }

    public List<ImageSet> join(List<ImagePlaneDetails> ipds, List<ImageSetError> errors) {
        TreeMap<List<String>, ImageSet> imageSets = new TreeMap<List<String>, ImageSet>(this.imageSetKeyComparator);
        TreeMap<List<String>, List<ImagePlaneDetailsStack>> duplicates = new TreeMap<List<String>, List<ImagePlaneDetailsStack>>(this.imageSetKeyComparator);
        ArrayList<ImageSetMissingError> missing = new ArrayList<ImageSetMissingError>();
        TreeSet<List<String>> bad = new TreeSet<List<String>>(this.imageSetKeyComparator);
        block0: for (ImagePlaneDetailsStack imagePlaneDetailsStack : this.anchorChannel.makeStacks(ipds)) {
            ArrayList<String> stackKey = new ArrayList<String>(this.keys.size());
            for (String key : this.keys) {
                String value = imagePlaneDetailsStack.get(key);
                if (value == null) {
                    ImageFile f = ((ImagePlaneDetails)imagePlaneDetailsStack.iterator().next()).getImagePlane().getImageFile();
                    logger.info(String.format("%s in channel %s does not have metadata for %s key", f, this.anchorChannel.getName(), key));
                    continue block0;
                }
                stackKey.add(value);
            }
            if (imageSets.containsKey(stackKey)) {
                if (!duplicates.containsKey(stackKey)) {
                    duplicates.put(stackKey, new ArrayList(1));
                }
                ((List)duplicates.get(stackKey)).add(imagePlaneDetailsStack);
                continue;
            }
            ImageSet imageSet = new ImageSet(imagePlaneDetailsStack, stackKey);
            imageSets.put(stackKey, imageSet);
        }
        errors.addAll(this.compileDuplicates(duplicates, this.anchorChannel.getName()));
        for (int i = 0; i < this.joinedChannels.size(); ++i) {
            List match;
            List<String> stackKey;
            Join join = this.joinedChannels.get(i);
            TreeMap groupedImageSets = new TreeMap(join.getComparator());
            duplicates = new TreeMap(join.getComparator());
            for (ImageSet imageSet : imageSets.values()) {
                stackKey = join.getLeftKey((ImagePlaneDetailsStack)imageSet.get(0));
                match = (ArrayList<ImageSet>)groupedImageSets.get(stackKey);
                if (match == null) {
                    match = new ArrayList<ImageSet>();
                    groupedImageSets.put(stackKey, match);
                }
                match.add(imageSet);
            }
            for (ImagePlaneDetailsStack stack : join.channelFilter.makeStacks(ipds)) {
                stackKey = join.getRightKey(stack);
                match = (List)groupedImageSets.get(stackKey);
                if (match == null) {
                    ImageFile f = ((ImagePlaneDetails)stack.iterator().next()).getImagePlane().getImageFile();
                    String message = String.format("%s in channel %s with metadata %s has no match", f, this.anchorChannel.getName(), stackKey);
                    missing.add(new ImageSetMissingError(join.channelFilter.getName(), message, stackKey));
                    continue;
                }
                for (ImageSet imageSet : match) {
                    if (imageSet.size() > i + 1) {
                        ArrayList<ImagePlaneDetailsStack> dlist = (ArrayList<ImagePlaneDetailsStack>)duplicates.get(imageSet.getKey());
                        if (dlist == null) {
                            dlist = new ArrayList<ImagePlaneDetailsStack>();
                            duplicates.put(imageSet.getKey(), dlist);
                        }
                        dlist.add(stack);
                        continue;
                    }
                    imageSet.add(stack);
                }
            }
            errors.addAll(this.compileDuplicates(duplicates, join.channelFilter.getName()));
            for (ImageSet imageSet : imageSets.values()) {
                if (imageSet.size() == i + 2) continue;
                missing.add(new ImageSetMissingError(join.channelFilter.getName(), "Missing from channel", imageSet.getKey()));
                imageSet.add(null);
                bad.add(imageSet.getKey());
            }
        }
        for (List list : bad) {
            imageSets.remove(list);
        }
        errors.addAll(missing);
        return new ArrayList<ImageSet>(imageSets.values());
    }

    private List<? extends ImageSetError> compileDuplicates(SortedMap<List<String>, List<ImagePlaneDetailsStack>> duplicates, String name) {
        ArrayList<ImageSetDuplicateError> result = new ArrayList<ImageSetDuplicateError>();
        for (Map.Entry<List<String>, List<ImagePlaneDetailsStack>> e : duplicates.entrySet()) {
            result.add(new ImageSetDuplicateError(name, "Duplicate entries", e.getKey(), e.getValue()));
        }
        return result;
    }

    protected static class Join {
        public final ChannelFilter channelFilter;
        public final List<MetadataKeyPair> joiningKeys;

        public Join(ChannelFilter channelFilter, List<MetadataKeyPair> joiningKeys) {
            this.channelFilter = channelFilter;
            this.joiningKeys = joiningKeys;
        }

        public List<String> getLeftKey(ImagePlaneDetailsStack d) {
            ArrayList<String> result = new ArrayList<String>(this.joiningKeys.size());
            for (MetadataKeyPair joiningKey : this.joiningKeys) {
                result.add(d.get(joiningKey.leftKey));
            }
            return result;
        }

        public List<String> getRightKey(ImagePlaneDetailsStack d) {
            ArrayList<String> result = new ArrayList<String>(this.joiningKeys.size());
            for (MetadataKeyPair joiningKey : this.joiningKeys) {
                result.add(d.get(joiningKey.rightKey));
            }
            return result;
        }

        public Comparator<List<String>> getComparator() {
            ArrayList comparators = new ArrayList();
            for (MetadataKeyPair kp : this.joiningKeys) {
                comparators.add(kp.comparator);
            }
            return new ListComparator<String>(comparators);
        }
    }
}

