/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.MetadataExtractor;
import org.cellprofiler.imageset.MetadataKeyPair;
import org.cellprofiler.imageset.StringCache;

public class ImportedMetadataExtractor
implements MetadataExtractor<ImagePlaneDetails> {
    private final Map<List<String>, Map<String, String>> importedMetadata = new TreeMap<List<String>, Map<String, String>>(new MetadataComparator());
    private final MetadataKeyPair[] matchingKeys;
    private final int[] matchingPositions;
    private final String[] metadataKeys;
    private final int[] metadataPositions;
    private CSVReader csvReader;

    public ImportedMetadataExtractor(Reader rdr, MetadataKeyPair[] matchingKeys) throws IOException {
        this.matchingKeys = matchingKeys;
        this.csvReader = new CSVReader(rdr);
        String[] allKeys = ImportedMetadataExtractor.readHeader(this.csvReader);
        this.matchingPositions = new int[matchingKeys.length];
        Arrays.fill(this.matchingPositions, -1);
        this.metadataKeys = new String[allKeys.length - matchingKeys.length];
        this.metadataPositions = new int[this.metadataKeys.length];
        int mpIdx = 0;
        block0: for (int kidx = 0; kidx < allKeys.length; ++kidx) {
            String key = allKeys[kidx];
            for (int i = 0; i < this.matchingKeys.length; ++i) {
                if (!key.equals(matchingKeys[i].leftKey)) continue;
                if (this.matchingPositions[i] != -1) {
                    throw new IOException("Duplicate key in CSV header: " + key);
                }
                this.matchingPositions[i] = kidx;
                continue block0;
            }
            if (mpIdx >= this.metadataPositions.length) break;
            this.metadataKeys[mpIdx] = StringCache.intern(key);
            this.metadataPositions[mpIdx++] = kidx;
        }
        for (int i = 0; i < this.matchingPositions.length; ++i) {
            if (this.matchingPositions[i] != -1) continue;
            throw new IOException(String.format("Key, \"%s\", is missing from CSV header.", matchingKeys[i].leftKey));
        }
        this.readData();
    }

    public static String[] readHeader(CSVReader csvReader) throws IOException {
        String[] allKeys = csvReader.readNext();
        if (allKeys == null) {
            throw new IOException("The CSV file has no header line");
        }
        return allKeys;
    }

    public static List<String> readHeader(String header) throws IOException {
        return Arrays.asList(ImportedMetadataExtractor.readHeader(new CSVReader(new StringReader(header))));
    }

    private void readData() throws IOException {
        int line = 0;
        int nFields = this.metadataKeys.length + this.matchingKeys.length;
        while (true) {
            String[] fields = this.csvReader.readNext();
            ++line;
            if (fields == null) break;
            if (fields.length < nFields) {
                throw new IOException(String.format("Line # %d: only %d values defined, expected %d", line, fields.length, nFields));
            }
            ArrayList<String> key = new ArrayList<String>(this.matchingKeys.length);
            for (int i = 0; i < this.matchingPositions.length; ++i) {
                key.add(StringCache.intern(fields[this.matchingPositions[i]]));
            }
            HashMap<String, String> values = new HashMap<String, String>(this.metadataPositions.length);
            for (int i = 0; i < this.metadataPositions.length; ++i) {
                values.put(this.metadataKeys[i], StringCache.intern(fields[this.metadataPositions[i]]));
            }
            this.importedMetadata.put(key, values);
        }
    }

    @Override
    public Map<String, String> extract(ImagePlaneDetails source) {
        ArrayList<String> key = new ArrayList<String>(this.matchingKeys.length);
        for (int i = 0; i < this.matchingKeys.length; ++i) {
            String value = source.get(this.matchingKeys[i].rightKey);
            if (value == null) {
                return emptyMap;
            }
            key.add(value);
        }
        if (this.importedMetadata.containsKey(key)) {
            return this.importedMetadata.get(key);
        }
        return emptyMap;
    }

    @Override
    public List<String> getMetadataKeys() {
        return Arrays.asList(this.metadataKeys);
    }

    protected class MetadataComparator
    implements Comparator<List<String>> {
        protected MetadataComparator() {
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            for (int i = 0; i < ImportedMetadataExtractor.this.matchingKeys.length; ++i) {
                int result = ((ImportedMetadataExtractor)ImportedMetadataExtractor.this).matchingKeys[i].comparator.compare(o1.get(i), o2.get(i));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

