/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.imglib2.meta.TypedAxis;
import ome.xml.model.OME;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.enums.EnumerationException;
import org.cellprofiler.imageset.ImageFile;
import org.cellprofiler.imageset.ImagePlane;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImagePlaneDetailsStack;
import org.cellprofiler.imageset.StringCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImageSet
extends ArrayList<ImagePlaneDetailsStack> {
    private static final long serialVersionUID = -6824821112413090930L;
    private static final Logger logger = Logger.getLogger(ImageSet.class.getCanonicalName());
    private final List<String> key;
    private static ThreadLocal<Transformer> transformer = new ThreadLocal<Transformer>(){

        @Override
        protected Transformer initialValue() {
            try {
                return TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                logger.severe(String.format("Failed to create the ImageSet XML transformer: %s", e.getMessage()));
            }
            catch (TransformerFactoryConfigurationError e) {
                logger.severe(String.format("Failed to create the ImageSet XML transformer: %s", e.getMessage()));
            }
            return null;
        }
    };
    private static ThreadLocal<DocumentBuilder> documentBuilder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                logger.severe(String.format("Failed to create an XML document builder: %s", e.getMessage()));
                return null;
            }
        }
    };

    public ImageSet(Collection<ImagePlaneDetailsStack> ipds, List<String> key) {
        super(ipds);
        this.key = key;
    }

    public ImageSet(ImagePlaneDetailsStack stack, List<String> key) {
        this(ImageSet.icantfindafunctionthatmakesamutablelistinitializedwithasinglemember(stack), key);
    }

    public List<String> getKey() {
        return this.key;
    }

    public void addToOME(OME ome, List<String> ids) {
        for (int i = 0; i < ids.size(); ++i) {
            ImagePlaneDetailsStack ipds = (ImagePlaneDetailsStack)this.get(i);
            String id = ids.get(i);
            ipds.addToOME(ome, id);
        }
    }

    public byte[] compress(List<String> ids, Deflater deflater) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        OME ome = new OME();
        this.addToOME(ome, ids);
        Document document = documentBuilder.get().newDocument();
        Element omeElement = ome.asXMLElement(document);
        document.appendChild(omeElement);
        DOMSource domSource = new DOMSource(document);
        ByteArrayOutputStream baOS = new ByteArrayOutputStream();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        OutputStreamWriter writer = new OutputStreamWriter(baOS);
        transformer.transform(domSource, new StreamResult(writer));
        writer.close();
        byte[] uncompressed = baOS.toByteArray();
        ByteArrayOutputStream baOSCompressed = new ByteArrayOutputStream();
        DeflaterOutputStream os = deflater == null ? new DeflaterOutputStream(baOSCompressed) : new DeflaterOutputStream((OutputStream)baOSCompressed, deflater);
        ((OutputStream)os).write(uncompressed);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        return baOSCompressed.toByteArray();
    }

    public static ImageSet decompress(byte[] data, List<String> ids, List<TypedAxis[]> axesList, byte[] dictionary) throws EnumerationException, TransformerException, URISyntaxException, IOException, DataFormatException {
        DOMResult domResult = new DOMResult();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        byte[] buffer = new byte[4096];
        while (true) {
            int amount;
            if ((amount = inflater.inflate(buffer)) == 0) {
                if (!inflater.needsDictionary()) break;
                inflater.setDictionary(dictionary);
                continue;
            }
            bos.write(buffer, 0, amount);
        }
        ByteArrayInputStream iis = new ByteArrayInputStream(bos.toByteArray());
        transformer.get().transform(new StreamSource(new InputStreamReader(iis)), domResult);
        Node documentOut = domResult.getNode();
        OMEModelImpl model = new OMEModelImpl();
        OME ome = new OME((Element)documentOut.getFirstChild(), model);
        model.resolveReferences();
        ArrayList<ImagePlaneDetailsStack> stacks = new ArrayList<ImagePlaneDetailsStack>();
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            TypedAxis[] axes = axesList.get(i);
            ImagePlaneDetailsStack stack = new ImagePlaneDetailsStack(axes);
            stack.loadFromOME(ome, id);
            stacks.add(stack);
        }
        List<String> emptyList = Collections.emptyList();
        return new ImageSet(stacks, emptyList);
    }

    public static byte[] createCompressionDictionary(List<ImageSet> imageSets, List<String> ids) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Object loc3;
        byte[][] data = new byte[imageSets.size()][];
        Deflater deflater = new Deflater(0);
        for (int i = 0; i < imageSets.size(); ++i) {
            int nBytes;
            ImageSet imageSet = imageSets.get(i);
            deflater.reset();
            byte[] compressed = imageSet.compress(ids, deflater);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InflaterInputStream is = new InflaterInputStream(new ByteArrayInputStream(compressed));
            byte[] buffer = new byte[16384];
            while ((nBytes = ((InputStream)is).read(buffer)) > 0) {
                baos.write(buffer, 0, nBytes);
            }
            baos.close();
            data[i] = baos.toByteArray();
        }
        /*
         * Exception performing whole class analysis ignored.
         */
        class CDLoc
        implements Comparable<CDLoc> {
            final int imageSetIdx;
            final int dataIdx;
            final int dataLength;
            final int maxLength;
            final /* synthetic */ byte[][] val$data;

            CDLoc(int imageSetIdx, int dataIdx) {
                this.val$data = var3_3;
                this.imageSetIdx = imageSetIdx;
                this.dataIdx = dataIdx;
                this.dataLength = this.val$data[imageSetIdx].length - dataIdx;
                this.maxLength = 0;
            }

            CDLoc(int imageSetIdx, int dataIdx, int dataLength, int maxLength) {
                this.val$data = var5_5;
                this.imageSetIdx = imageSetIdx;
                this.dataIdx = dataIdx;
                this.dataLength = dataLength;
                this.maxLength = maxLength;
            }

            @Override
            public int compareTo(CDLoc other) {
                byte[] myData = this.val$data[this.imageSetIdx];
                byte[] otherData = this.val$data[other.imageSetIdx];
                if (this.imageSetIdx != other.imageSetIdx || this.dataIdx != other.dataIdx) {
                    for (int i = 0; i < this.dataLength && i < other.dataLength; ++i) {
                        int result = myData[i + this.dataIdx] - otherData[i + other.dataIdx];
                        if (result == 0) continue;
                        return result;
                    }
                }
                return this.dataLength - other.dataLength;
            }

            public int matchLength(CDLoc other) {
                int i;
                if (this.imageSetIdx == other.imageSetIdx && this.dataIdx == other.dataIdx) {
                    return Math.min(this.dataLength, other.dataLength);
                }
                for (i = 0; i < this.dataLength && i < other.dataLength; ++i) {
                    if (this.val$data[this.imageSetIdx][i + this.dataIdx] == this.val$data[other.imageSetIdx][i + other.dataIdx]) continue;
                    return i;
                }
                return i;
            }

            public int runLength(TreeSet<CDLoc> set) {
                int result = 1;
                for (CDLoc loc : set.tailSet(this, false)) {
                    if (loc.matchLength(this) < this.dataLength) {
                        return result;
                    }
                    ++result;
                }
                return result;
            }

            public String toString() {
                try {
                    return new String(Arrays.copyOfRange(this.val$data[this.imageSetIdx], this.dataIdx, this.dataIdx + this.dataLength));
                }
                catch (Exception e) {
                    return super.toString();
                }
            }
        }
        TreeSet<CDLoc> set = new TreeSet<CDLoc>();
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length - 3; ++j) {
                set.add(new CDLoc(i, j, (byte[][])data));
            }
        }
        TreeMap<CDLoc, Integer> runs = new TreeMap<CDLoc, Integer>();
        for (CDLoc loc2 : set.headSet((CDLoc)set.last())) {
            CDLoc higher = set.higher(loc2);
            if (higher == null) continue;
            int matchLength = loc2.matchLength(higher);
            CDLoc key = new CDLoc(loc2.imageSetIdx, loc2.dataIdx, matchLength, matchLength, (byte[][])data);
            Map.Entry other = runs.lowerEntry(key);
            if (other == null) {
                runs.put(key, key.runLength(set));
                continue;
            }
            CDLoc otherKey = other.getKey();
            int oml = otherKey.matchLength(key);
            if (oml >= matchLength) continue;
            if (oml == otherKey.dataLength) {
                runs.remove(otherKey);
            }
            runs.put(key, key.runLength(set));
        }
        boolean[][] toKeep = new boolean[data.length][];
        for (int i = 0; i < data.length; ++i) {
            toKeep[i] = new boolean[data[i].length];
        }
        for (Object loc3 : runs.keySet()) {
            if (((CDLoc)loc3).dataLength != ((CDLoc)loc3).maxLength) continue;
            Arrays.fill(toKeep[((CDLoc)loc3).imageSetIdx], ((CDLoc)loc3).dataIdx, ((CDLoc)loc3).dataIdx + ((CDLoc)loc3).dataLength, true);
        }
        int nBytes = 0;
        loc3 = toKeep;
        int matchLength = ((Object)loc3).length;
        for (int key = 0; key < matchLength; ++key) {
            CDLoc a;
            for (Object b : a = loc3[key]) {
                if (b == false) continue;
                ++nBytes;
            }
        }
        byte[] result = new byte[nBytes];
        int idx = 0;
        for (int i = 0; i < data.length; ++i) {
            byte[] d = data[i];
            boolean[] b = toKeep[i];
            for (int j = 0; j < d.length; ++j) {
                if (!b[j]) continue;
                result[idx++] = d[j];
            }
        }
        return result;
    }

    public static byte[][] convertToColumns(List<ImageSet> imageSets, List<String> channelNames, String[][] urls, String[][] pathNames, String[][] fileNames, int[][] series, int[][] index, int[][] channel, byte[] dict) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        int i;
        byte[][] data = new byte[imageSets.size()][];
        for (i = 0; i < channelNames.size(); ++i) {
            urls[i] = new String[imageSets.size()];
            pathNames[i] = new String[imageSets.size()];
            fileNames[i] = new String[imageSets.size()];
            series[i] = new int[imageSets.size()];
            index[i] = new int[imageSets.size()];
            channel[i] = new int[imageSets.size()];
        }
        for (i = 0; i < imageSets.size(); ++i) {
            ImageSet imageSet = imageSets.get(i);
            Deflater deflater = new Deflater();
            if (dict != null) {
                deflater.setDictionary(dict);
            }
            data[i] = imageSet.compress(channelNames, deflater);
            for (int j = 0; j < channelNames.size(); ++j) {
                ImagePlaneDetailsStack ipds = (ImagePlaneDetailsStack)imageSet.get(j);
                ImagePlane imagePlane = ((ImagePlaneDetails)ipds.iterator().next()).getImagePlane();
                ImageFile imageFile = imagePlane.getImageFile();
                urls[j][i] = StringCache.intern(imageFile.getURI().toString());
                pathNames[j][i] = StringCache.intern(imageFile.getPathName());
                fileNames[j][i] = StringCache.intern(imageFile.getFileName());
                series[j][i] = imagePlane.getSeries().getSeries();
                index[j][i] = imagePlane.getIndex();
                channel[j][i] = imagePlane.getChannel();
            }
        }
        return data;
    }

    private static <T> List<T> icantfindafunctionthatmakesamutablelistinitializedwithasinglemember(T stack) {
        ArrayList<T> stacks = new ArrayList<T>();
        stacks.add(stack);
        return stacks;
    }
}

