/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import ome.xml.model.Image;
import ome.xml.model.OME;
import org.cellprofiler.imageset.ImageFile;

public class ImageSeries
implements Comparable<ImageSeries> {
    private final ImageFile imageFile;
    private final int series;

    public ImageSeries(ImageFile imageFile, int series) {
        this.imageFile = imageFile;
        this.series = series;
    }

    public ImageFile getImageFile() {
        return this.imageFile;
    }

    public int getSeries() {
        return this.series;
    }

    public Image getOMEImage() {
        OME metadata = this.imageFile.getMetadata();
        if (metadata == null) {
            return null;
        }
        return metadata.getImage(this.series);
    }

    @Override
    public int compareTo(ImageSeries o) {
        if (this == o) {
            return 0;
        }
        if (this.imageFile == o.imageFile) {
            return this.series - o.series;
        }
        int result = this.imageFile.compareTo(o.imageFile);
        if (result == 0) {
            return this.series - o.series;
        }
        return result;
    }
}

