/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import org.cellprofiler.imageset.Details;
import org.cellprofiler.imageset.FileNameMetadataExtractor;
import org.cellprofiler.imageset.ImageFile;
import org.cellprofiler.imageset.ImageFileDetails;
import org.cellprofiler.imageset.ImagePlane;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImageSeries;
import org.cellprofiler.imageset.ImageSeriesDetails;
import org.cellprofiler.imageset.MetadataExtractor;
import org.cellprofiler.imageset.PathNameMetadataExtractor;
import org.cellprofiler.imageset.RegexpMetadataExtractor;
import org.cellprofiler.imageset.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ImagePlaneMetadataExtractor {
    public static final Logger logger = LoggerFactory.getLogger(ImagePlaneMetadataExtractor.class);
    private final List<ExtractorFilterPair<ImageFile>> fileExtractors = new ArrayList<ExtractorFilterPair<ImageFile>>();
    private final List<ExtractorFilterPair<ImageSeries>> seriesExtractors = new ArrayList<ExtractorFilterPair<ImageSeries>>();
    private final List<ExtractorFilterPair<ImagePlane>> planeExtractors = new ArrayList<ExtractorFilterPair<ImagePlane>>();
    private final List<ExtractorFilterPair<ImagePlaneDetails>> planeDetailsExtractors = new ArrayList<ExtractorFilterPair<ImagePlaneDetails>>();
    private final Map<ImageFile, ImageFileDetails> mapImageFileToDetails = new IdentityHashMap<ImageFile, ImageFileDetails>();
    private final Map<ImageSeries, ImageSeriesDetails> mapImageSeriesToDetails = new IdentityHashMap<ImageSeries, ImageSeriesDetails>();

    public void addImagePlaneDetailsExtractor(MetadataExtractor<ImagePlaneDetails> extractor, Filter<ImageFile> filter) {
        this.planeDetailsExtractors.add(new ExtractorFilterPair<ImagePlaneDetails>(extractor, filter, ImagePlaneDetails.class));
    }

    public void addImagePlaneDetailsExtractor(MetadataExtractor<ImagePlaneDetails> extractor) {
        this.addImagePlaneDetailsExtractor(extractor, null);
    }

    public void addImagePlaneExtractor(MetadataExtractor<ImagePlane> extractor, Filter<ImageFile> filter) {
        this.planeExtractors.add(new ExtractorFilterPair<ImagePlane>(extractor, filter, ImagePlane.class));
    }

    public void addImagePlaneExtractor(MetadataExtractor<ImagePlane> extractor) {
        this.planeExtractors.add(new ExtractorFilterPair<ImagePlane>(extractor, null, ImagePlane.class));
    }

    public void addImageFileExtractor(MetadataExtractor<ImageFile> extractor, Filter<ImageFile> filter) {
        this.fileExtractors.add(new ExtractorFilterPair<ImageFile>(extractor, filter, ImageFile.class));
    }

    public void addImageFileExtractor(MetadataExtractor<ImageFile> extractor) {
        this.addImageFileExtractor(extractor, null);
    }

    public void addImageSeriesExtractor(MetadataExtractor<ImageSeries> extractor, Filter<ImageFile> filter) {
        this.seriesExtractors.add(new ExtractorFilterPair<ImageSeries>(extractor, filter, ImageSeries.class));
    }

    public void addImageSeriesExtractor(MetadataExtractor<ImageSeries> extractor) {
        this.addImageSeriesExtractor(extractor, null);
    }

    public void addFileNameRegexp(String regexp) {
        this.addFileNameRegexp(regexp, null);
    }

    public void addFileNameRegexp(String regexp, Filter<ImageFile> filter) {
        this.addImageFileExtractor(new FileNameMetadataExtractor(new RegexpMetadataExtractor(regexp)), filter);
    }

    public void addPathNameRegexp(String regexp) {
        this.addPathNameRegexp(regexp, null);
    }

    public void addPathNameRegexp(String regexp, Filter<ImageFile> filter) {
        this.addImageFileExtractor(new PathNameMetadataExtractor(new RegexpMetadataExtractor(regexp)), filter);
    }

    public void extract(ImagePlaneDetails details) {
        for (ExtractorFilterPair<ImagePlaneDetails> efp : this.planeDetailsExtractors) {
            efp.extract(details, details.getImagePlane().getImageFile(), details);
        }
    }

    public ImagePlaneDetails extract(ImagePlane plane) {
        ImageSeries series = plane.getSeries();
        ImageFile file2 = series.getImageFile();
        ImageSeriesDetails seriesDetails = this.mapImageSeriesToDetails.get(series);
        if (seriesDetails == null) {
            seriesDetails = this.extract(series);
            this.mapImageSeriesToDetails.put(series, seriesDetails);
        }
        ImagePlaneDetails ipd = new ImagePlaneDetails(plane, (Details)seriesDetails);
        for (ExtractorFilterPair<ImagePlane> extractorFilterPair : this.planeExtractors) {
            extractorFilterPair.extract(plane, file2, ipd);
        }
        for (ExtractorFilterPair<Object> extractorFilterPair : this.planeDetailsExtractors) {
            extractorFilterPair.extract(ipd, file2, ipd);
        }
        return ipd;
    }

    public ImageSeriesDetails extract(ImageSeries series) {
        ImageFile file2 = series.getImageFile();
        ImageFileDetails fileDetails = this.mapImageFileToDetails.get(file2);
        if (fileDetails == null) {
            fileDetails = this.extract(file2);
            this.mapImageFileToDetails.put(file2, fileDetails);
        }
        ImageSeriesDetails isd = new ImageSeriesDetails(series, (Details)fileDetails);
        for (ExtractorFilterPair<ImageSeries> efp : this.seriesExtractors) {
            efp.extract(series, file2, isd);
        }
        return isd;
    }

    public ImageFileDetails extract(ImageFile file2) {
        ImageFileDetails ifd = new ImageFileDetails(file2);
        for (ExtractorFilterPair<ImageFile> efp : this.fileExtractors) {
            efp.extract(file2, file2, ifd);
        }
        return ifd;
    }

    public ImagePlaneDetails[] extract(String[] urls, String[] metadata, Set<String> keysOut) throws URISyntaxException, ParserConfigurationException, SAXException, IOException, DependencyException, ServiceException {
        assert (urls.length == metadata.length);
        ArrayList<ImagePlaneDetails> result = new ArrayList<ImagePlaneDetails>();
        for (int i = 0; i < urls.length; ++i) {
            ImageFile imageFile = new ImageFile(new URI(urls[i]));
            if (metadata[i] != null) {
                imageFile.setXMLDocument(metadata[i]);
                OME fileMetadata = imageFile.getMetadata();
                for (int series = 0; series < fileMetadata.sizeOfImageList(); ++series) {
                    ImageSeries imageSeries = new ImageSeries(imageFile, series);
                    Image seriesMetadata = imageSeries.getOMEImage();
                    Pixels pixels = seriesMetadata.getPixels();
                    int nPlanes = pixels.sizeOfPlaneList();
                    if (nPlanes == 0) {
                        int nChannels = pixels.sizeOfChannelList();
                        if (nChannels == 0) {
                            nChannels = (Integer)pixels.getSizeC().getValue();
                        }
                        nPlanes = nChannels * (Integer)pixels.getSizeT().getValue() * (Integer)pixels.getSizeZ().getValue();
                        for (int plane = 0; plane < nPlanes; ++plane) {
                            ImagePlane imagePlane = new ImagePlane(imageSeries, plane, -1);
                            ImagePlaneDetails ipd = this.extract(imagePlane);
                            ipd.put("C", Integer.toString(imagePlane.theC()));
                            ipd.put("T", Integer.toString(imagePlane.theT()));
                            ipd.put("Z", Integer.toString(imagePlane.theZ()));
                            result.add(ipd);
                        }
                        continue;
                    }
                    for (int plane = 0; plane < nPlanes; ++plane) {
                        ImagePlane imagePlane = new ImagePlane(imageSeries, plane, -1);
                        ImagePlaneDetails ipd = this.extract(imagePlane);
                        result.add(ipd);
                        for (String key : ipd) {
                            keysOut.add(key);
                        }
                    }
                }
                continue;
            }
            ImagePlane imagePlane = ImagePlane.makeMonochromePlane(imageFile);
            ImagePlaneDetails ipd = this.extract(imagePlane);
            result.add(ipd);
            for (String key : ipd) {
                keysOut.add(key);
            }
        }
        return result.toArray(new ImagePlaneDetails[result.size()]);
    }

    public List<String> getMetadataKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (List efs : new List[]{this.fileExtractors, this.seriesExtractors, this.planeExtractors, this.planeDetailsExtractors}) {
            for (ExtractorFilterPair ef : efs) {
                keys.addAll(ef.extractor.getMetadataKeys());
            }
        }
        return new ArrayList<String>(keys);
    }

    protected class ExtractorFilterPair<T> {
        public final MetadataExtractor<T> extractor;
        public final Filter<ImageFile> filter;
        public final Class<T> klass;

        public ExtractorFilterPair(MetadataExtractor<T> extractor, Filter<ImageFile> filter, Class<T> klass) {
            this.extractor = extractor;
            this.filter = filter;
            this.klass = klass;
        }

        public void extract(T source, ImageFile imageFile, Details destination) {
            if (this.filter != null) {
                logger.info(String.format("Running filter %s on %s", this.filter, source));
                if (!this.filter.eval(imageFile)) {
                    return;
                }
                logger.info("  Filter passed");
            }
            Map<String, String> metadata = this.extractor.extract(source);
            logger.info(String.format("  Extracted metadata = %s", metadata));
            destination.putAll(metadata);
        }
    }
}

