/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.TypedAxis;
import ome.xml.model.Annotation;
import ome.xml.model.Image;
import ome.xml.model.LongAnnotation;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TiffData;
import ome.xml.model.UUID;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import org.cellprofiler.imageset.Details;
import org.cellprofiler.imageset.ImageFile;
import org.cellprofiler.imageset.ImageFileDetails;
import org.cellprofiler.imageset.ImagePlane;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImageSeries;
import org.cellprofiler.imageset.ImageSeriesDetails;
import org.cellprofiler.imageset.PlaneStack;

public class ImagePlaneDetailsStack
extends PlaneStack<ImagePlaneDetails> {
    public static final String SERIES_ANNOTATION_DESCRIPTION = "Series";
    public static final String CHANNEL_ANNOTATION_DESCRIPTION = "Channel";
    public static final String ANNOTATION_NAMESPACE = "info://cellprofiler.org/imageset/annotation/2014-04-17";
    private static final NonNegativeInteger NNI_ZERO = new NonNegativeInteger(0);

    public ImagePlaneDetailsStack(TypedAxis ... axes) {
        super(axes);
    }

    public static ImagePlaneDetailsStack makeMonochromeStack(ImagePlaneDetails plane) {
        ImagePlaneDetailsStack stack = new ImagePlaneDetailsStack(XYAxes);
        stack.add(plane, 0, 0);
        return stack;
    }

    public static ImagePlaneDetailsStack makeColorStack(ImagePlaneDetails plane) {
        ImagePlaneDetailsStack stack = new ImagePlaneDetailsStack(XYCAxes);
        stack.add(plane, 0, 0, 0);
        return stack;
    }

    public static ImagePlaneDetailsStack makeObjectsStack(ImagePlaneDetails plane) {
        ImagePlaneDetailsStack stack = new ImagePlaneDetailsStack(XYOAxes);
        stack.add(plane, 0, 0, 0);
        return stack;
    }

    public boolean containsKey(String key) {
        for (ImagePlaneDetails ipd : this) {
            if (!ipd.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public String get(String key) {
        for (ImagePlaneDetails ipd : this) {
            String value = ipd.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public void addToOME(OME ome, String id) {
        Image image = new Image();
        image.setID(id);
        Pixels pixels = new Pixels();
        image.setPixels(pixels);
        ome.addImage(image);
        pixels.setID(String.format("Pixels:%s", id));
        ImagePlaneDetails firstIPD = (ImagePlaneDetails)this.iterator().next();
        Image srcImage = firstIPD.getImagePlane().getSeries().getOMEImage();
        PositiveInteger xSize = new PositiveInteger(1);
        PositiveInteger ySize = new PositiveInteger(1);
        if (srcImage != null) {
            Pixels srcPixels = srcImage.getPixels();
            xSize = srcPixels.getSizeX();
            ySize = srcPixels.getSizeY();
        }
        pixels.setSizeX(xSize);
        pixels.setSizeY(ySize);
        ImagePlaneDetailsStack.setDimensionOrder(this, pixels);
        int nPlanes = 1;
        for (int axisIdx = 0; axisIdx < this.numDimensions(); ++axisIdx) {
            TypedAxis a = (TypedAxis)this.axis(axisIdx);
            PositiveInteger size = new PositiveInteger(this.size(axisIdx));
            if (a.type().equals(Axes.Z)) {
                pixels.setSizeZ(size);
            } else if (a.type().equals(Axes.CHANNEL)) {
                pixels.setSizeC(size);
            } else {
                pixels.setSizeT(size);
            }
            nPlanes *= this.size(axisIdx);
        }
        int[] coords = new int[this.numDimensions()];
        int c = 0;
        int z = 0;
        int t = 0;
        for (int planeIdx = 0; planeIdx < nPlanes; ++planeIdx) {
            ImagePlaneDetails ipd = (ImagePlaneDetails)this.get(coords);
            ImagePlaneDetailsStack.addOMEPlane(ome, pixels, xSize, ySize, c, z, t, ipd);
            boolean done = false;
            for (int j = 2; j < coords.length && !done; ++j) {
                if (coords[j] == this.size(j) - 1) {
                    coords[j] = 0;
                } else {
                    int n = j;
                    coords[n] = coords[n] + 1;
                    done = true;
                }
                AxisType axisType = ((TypedAxis)this.axis(j)).type();
                if (axisType.equals(Axes.CHANNEL)) {
                    c = coords[j];
                    continue;
                }
                if (axisType.equals(Axes.Z)) {
                    z = coords[j];
                    continue;
                }
                t = coords[j];
            }
        }
    }

    public void loadFromOME(OME ome, String id) throws URISyntaxException {
        for (int i = 0; i < ome.sizeOfImageList(); ++i) {
            Image omeImage = ome.getImage(i);
            if (!omeImage.getID().equals(id)) continue;
            this.loadFromOMEImage(omeImage);
            return;
        }
        throw new IndexOutOfBoundsException(String.format("Could not find image, \"%s\" in OME-XML", id));
    }

    private void loadFromOMEImage(Image omeImage) throws URISyntaxException {
        HashMap<URI, ImageFileDetails> imageFiles = new HashMap<URI, ImageFileDetails>();
        HashMap imageSeries = new HashMap();
        Pixels pixels = omeImage.getPixels();
        int[] coords = new int[this.numDimensions()];
        for (int planeIdx = 0; planeIdx < pixels.sizeOfPlaneList() && planeIdx < pixels.sizeOfTiffDataList(); ++planeIdx) {
            Map idx2Series;
            Plane plane = pixels.getPlane(planeIdx);
            TiffData location = pixels.getTiffData(planeIdx);
            URI uri = new URI(location.getUUID().getFileName());
            if (!imageFiles.containsKey(uri)) {
                imageFiles.put(uri, new ImageFileDetails(new ImageFile(uri)));
            }
            ImageFileDetails ifd = (ImageFileDetails)imageFiles.get(uri);
            int series = ImagePlaneDetailsStack.getLongAnnotationFromPlane(plane, SERIES_ANNOTATION_DESCRIPTION, 0);
            if (!imageSeries.containsKey(uri)) {
                imageSeries.put(uri, new HashMap());
            }
            if (!(idx2Series = (Map)imageSeries.get(uri)).containsKey(series)) {
                idx2Series.put(series, new ImageSeriesDetails(new ImageSeries(ifd.getImageFile(), series), (Details)ifd));
            }
            ImageSeriesDetails isd = (ImageSeriesDetails)idx2Series.get(series);
            int idx = (Integer)location.getIFD().getValue();
            int channel = ImagePlaneDetailsStack.getLongAnnotationFromPlane(plane, CHANNEL_ANNOTATION_DESCRIPTION, -1);
            ImagePlane imagePlane = new ImagePlane(isd.getImageSeries(), idx, channel);
            ImagePlaneDetails ipd = new ImagePlaneDetails(imagePlane, (Details)isd);
            for (int didx = 0; didx < this.numDimensions(); ++didx) {
                AxisType at = ((TypedAxis)this.axis(didx)).type();
                if (at.equals(Axes.CHANNEL)) {
                    coords[didx] = (Integer)plane.getTheC().getValue();
                    continue;
                }
                if (at.equals(Axes.Z)) {
                    coords[didx] = (Integer)plane.getTheZ().getValue();
                    continue;
                }
                if (at.equals(Axes.TIME)) {
                    coords[didx] = (Integer)plane.getTheT().getValue();
                    continue;
                }
                if (!at.equals(OBJECT_PLANE_AXIS_TYPE)) continue;
                coords[didx] = planeIdx;
            }
            this.add(ipd, coords);
        }
    }

    private static void addOMEPlane(OME ome, Pixels pixels, PositiveInteger xSize, PositiveInteger ySize, int c, int z, int t, ImagePlaneDetails ipd) {
        Plane destPlane = new Plane();
        pixels.addPlane(destPlane);
        int series = 0;
        int channel = -1;
        TiffData location = new TiffData();
        UUID uuid = new UUID();
        location.setPlaneCount(new NonNegativeInteger(1));
        if (ipd != null) {
            ImagePlane imagePlane = ipd.getImagePlane();
            series = imagePlane.getSeries().getSeries();
            channel = imagePlane.getChannel();
            location.setIFD(new NonNegativeInteger(imagePlane.getIndex()));
            uuid.setFileName(imagePlane.getImageFile().getURI().toString());
            Plane omePlane = imagePlane.getOMEPlane();
            if (omePlane != null) {
                location.setFirstC(omePlane.getTheC());
                location.setFirstT(omePlane.getTheT());
                location.setFirstZ(omePlane.getTheZ());
            } else {
                location.setFirstC(NNI_ZERO);
                location.setFirstT(NNI_ZERO);
                location.setFirstZ(NNI_ZERO);
            }
        } else {
            uuid.setFileName(new ImageFile((Integer)xSize.getValue(), (Integer)ySize.getValue()).getURI().toString());
            location.setIFD(NNI_ZERO);
            location.setFirstC(NNI_ZERO);
            location.setFirstT(NNI_ZERO);
            location.setFirstZ(NNI_ZERO);
        }
        location.setUUID(uuid);
        pixels.addTiffData(location);
        destPlane.setTheC(new NonNegativeInteger(c));
        destPlane.setTheZ(new NonNegativeInteger(z));
        destPlane.setTheT(new NonNegativeInteger(t));
        if (series > 0) {
            ImagePlaneDetailsStack.addLongAnnotationToPlane(ome, destPlane, SERIES_ANNOTATION_DESCRIPTION, series);
        }
        if (channel != -1) {
            ImagePlaneDetailsStack.addLongAnnotationToPlane(ome, destPlane, CHANNEL_ANNOTATION_DESCRIPTION, channel);
        }
    }

    private static int getLongAnnotationFromPlane(Plane plane, String description, int defaultValue) {
        int result = defaultValue;
        for (int annotationRefIdx = 0; annotationRefIdx < plane.sizeOfLinkedAnnotationList(); ++annotationRefIdx) {
            Annotation a = plane.getLinkedAnnotation(annotationRefIdx);
            if (!a.getDescription().equals(description) || !a.getNamespace().equals(ANNOTATION_NAMESPACE) || !(a instanceof LongAnnotation)) continue;
            result = ((LongAnnotation)a).getValue().intValue();
            break;
        }
        return result;
    }

    private static void addLongAnnotationToPlane(OME ome, Plane plane, String description, long value) {
        StructuredAnnotations sa = ome.getStructuredAnnotations();
        if (sa == null) {
            sa = new StructuredAnnotations();
            ome.setStructuredAnnotations(sa);
        }
        LongAnnotation seriesAnnotation = null;
        for (int saIdx = 0; saIdx < sa.sizeOfLongAnnotationList(); ++saIdx) {
            LongAnnotation candidate = sa.getLongAnnotation(saIdx);
            if (!candidate.getDescription().equals(description) || !candidate.getNamespace().equals(ANNOTATION_NAMESPACE) || !candidate.getValue().equals(value)) continue;
            seriesAnnotation = candidate;
            break;
        }
        if (seriesAnnotation == null) {
            seriesAnnotation = new LongAnnotation();
            seriesAnnotation.setDescription(description);
            seriesAnnotation.setNamespace(ANNOTATION_NAMESPACE);
            seriesAnnotation.setValue(value);
            seriesAnnotation.setID(String.format("%s/%s/%d", ANNOTATION_NAMESPACE, description, value));
            sa.addLongAnnotation(seriesAnnotation);
        }
        plane.linkAnnotation(seriesAnnotation);
    }

    private static void setDimensionOrder(ImagePlaneDetailsStack ipds, Pixels pixels) {
        if (ipds.numDimensions() == 2) {
            pixels.setDimensionOrder(DimensionOrder.XYCZT);
        } else {
            AxisType type = ((TypedAxis)ipds.axis(2)).type();
            if (type.equals(Axes.CHANNEL)) {
                if (ipds.numDimensions() == 3) {
                    pixels.setDimensionOrder(DimensionOrder.XYCZT);
                } else if (((TypedAxis)ipds.axis(3)).type().equals(Axes.Z)) {
                    pixels.setDimensionOrder(DimensionOrder.XYCZT);
                } else {
                    pixels.setDimensionOrder(DimensionOrder.XYCTZ);
                }
            } else if (type.equals(Axes.Z)) {
                if (ipds.numDimensions() == 3) {
                    pixels.setDimensionOrder(DimensionOrder.XYZCT);
                } else if (((TypedAxis)ipds.axis(3)).type().equals(Axes.CHANNEL)) {
                    pixels.setDimensionOrder(DimensionOrder.XYZCT);
                } else {
                    pixels.setDimensionOrder(DimensionOrder.XYZTC);
                }
            } else if (ipds.numDimensions() == 3 || ((TypedAxis)ipds.axis(3)).type().equals(Axes.CHANNEL)) {
                pixels.setDimensionOrder(DimensionOrder.XYTCZ);
            } else {
                pixels.setDimensionOrder(DimensionOrder.XYTZC);
            }
        }
    }
}

