/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.cellprofiler.imageset.Details;
import org.cellprofiler.imageset.ImagePlane;

public class ImagePlaneDetails
extends Details {
    private final ImagePlane imagePlane;

    public ImagePlaneDetails(ImagePlane imagePlane, Details parent) {
        super(parent);
        this.imagePlane = imagePlane;
    }

    protected ImagePlaneDetails(ImagePlane imagePlane, Details parent, Details child) {
        super(parent, child);
        this.imagePlane = imagePlane;
    }

    public ImagePlane getImagePlane() {
        return this.imagePlane;
    }

    public ImagePlaneDetails coerceToMonochrome() {
        if (this.imagePlane.getChannel() == -2) {
            ImagePlane planeCopy = new ImagePlane(this.imagePlane.getSeries(), this.imagePlane.getIndex(), -1);
            return new ImagePlaneDetails(planeCopy, this.parent, this);
        }
        return this;
    }

    public ImagePlaneDetails coerceToColor() {
        if (this.imagePlane.getChannel() != -2) {
            ImagePlane planeCopy = new ImagePlane(this.imagePlane.getSeries(), this.imagePlane.getIndex(), -2);
            return new ImagePlaneDetails(planeCopy, this.parent, this);
        }
        return this;
    }

    public String[] getIPDFields(List<String> metadataKeys) {
        String[] result = new String[metadataKeys.size() + 3];
        URI uri = this.imagePlane.getImageFile().getURI();
        result[0] = uri.getScheme().toLowerCase().equals("file") ? new File(uri).toString() : uri.toString();
        result[1] = Integer.toString(this.imagePlane.getSeries().getSeries());
        result[2] = Integer.toString(this.imagePlane.getIndex());
        for (int i = 0; i < metadataKeys.size(); ++i) {
            result[i + 3] = this.get(metadataKeys.get(i));
        }
        return result;
    }
}

