/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import ome.xml.model.Image;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import org.cellprofiler.imageset.ImageFile;
import org.cellprofiler.imageset.ImageSeries;
import org.cellprofiler.imageset.MetadataUtils;

public class ImagePlane {
    private final ImageSeries imageSeries;
    private final int index;
    private final int channel;
    public static final int OBJECT_PLANES = -3;
    public static final int INTERLEAVED = -2;
    public static final int ALWAYS_MONOCHROME = -1;
    public static final int RED_CHANNEL = 0;
    public static final int GREEN_CHANNEL = 1;
    public static final int BLUE_CHANNEL = 2;
    public static final int ALPHA_CHANNEL = 3;

    public ImagePlane(ImageSeries imageSeries, int index, int channel) {
        this.imageSeries = imageSeries;
        this.index = index;
        this.channel = channel;
    }

    public boolean hasCZT() {
        return this.imageSeries.getOMEImage() != null;
    }

    public int theC() {
        if (!this.hasCZT()) {
            return 0;
        }
        Plane plane = this.getOMEPlane();
        if (plane != null) {
            return (Integer)plane.getTheC().getValue();
        }
        return MetadataUtils.getC(this.imageSeries.getOMEImage().getPixels(), this.index);
    }

    public int theZ() {
        if (!this.hasCZT()) {
            return 0;
        }
        Plane plane = this.getOMEPlane();
        if (plane != null) {
            return (Integer)plane.getTheZ().getValue();
        }
        return MetadataUtils.getZ(this.imageSeries.getOMEImage().getPixels(), this.index);
    }

    public int theT() {
        if (!this.hasCZT()) {
            return 0;
        }
        Plane plane = this.getOMEPlane();
        if (plane != null) {
            return (Integer)plane.getTheT().getValue();
        }
        return MetadataUtils.getT(this.imageSeries.getOMEImage().getPixels(), this.index);
    }

    public static ImagePlane makeMonochromePlane(ImageFile imageFile) {
        return new ImagePlane(imageFile, -1);
    }

    public static ImagePlane makeColorPlane(ImageFile imageFile) {
        return new ImagePlane(imageFile, -2);
    }

    public static ImagePlane makeObjectsPlane(ImageFile imageFile) {
        return new ImagePlane(imageFile, -3);
    }

    public ImagePlane(ImageFile imageFile, int channel) {
        this.imageSeries = new ImageSeries(imageFile, 0);
        this.index = 0;
        this.channel = channel;
    }

    public ImageFile getImageFile() {
        return this.imageSeries.getImageFile();
    }

    public ImageSeries getSeries() {
        return this.imageSeries;
    }

    public int getIndex() {
        return this.index;
    }

    public int getChannel() {
        return this.channel;
    }

    public Plane getOMEPlane() {
        Image image = this.imageSeries.getOMEImage();
        if (image == null) {
            return null;
        }
        Pixels pixels = image.getPixels();
        if (pixels.sizeOfPlaneList() <= this.index) {
            return null;
        }
        return pixels.getPlane(this.index);
    }

    public String toString() {
        return String.format("ImagePlane: %s, series=%d, index=%d, channel=%s", this.imageSeries.getImageFile(), this.imageSeries.getSeries(), this.index, this.channel == -1 ? "Monochrome" : (this.channel == -2 ? "Color" : (this.channel == -3 ? "Objects" : Integer.toString(this.channel))));
    }
}

