/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.services.OMEXMLService;
import ome.xml.model.OME;
import ome.xml.model.OMEModelObject;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ImageFile
implements Comparable<ImageFile> {
    public static final String BLANK_URI_PATH = "/image/blank";
    public static final String BLANK_URI_AUTHORITY = "cellprofiler.org";
    public static final String BLANK_URI_SCHEME = "info";
    public static final String BLANK_URI_QUERY_PATTERN_STRING = "X=([0-9]+)&Y=([0-9]+)";
    public static final Pattern BLANK_URI_QUERY_PATTERN = Pattern.compile("X=([0-9]+)&Y=([0-9]+)");
    private final URI uri;
    private String fileName = null;
    private String pathName = null;
    private OME omexml = null;

    public ImageFile(URI uri) {
        this.uri = uri;
    }

    public ImageFile(int xSize, int ySize) {
        String query = String.format("X=%d&Y=%d", xSize, ySize);
        try {
            this.uri = new URI(BLANK_URI_SCHEME, BLANK_URI_AUTHORITY, BLANK_URI_PATH, query, null);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"Failed to construct the blank image URI");
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getFileName() {
        if (this.fileName == null) {
            if (this.uri.getScheme().equals("file")) {
                File file2 = new File(this.uri);
                this.fileName = file2.getName();
            } else {
                int lastslash;
                String path = this.uri.getPath();
                if (path == null) {
                    path = this.uri.getSchemeSpecificPart();
                }
                this.fileName = (lastslash = path.lastIndexOf("/")) == -1 ? path : path.substring(lastslash + 1);
            }
        }
        return this.fileName;
    }

    public String getPathName() {
        if (this.pathName == null) {
            try {
                if (this.uri.getScheme().equals("file")) {
                    File file2 = new File(this.uri);
                    this.pathName = file2.getParentFile().getAbsolutePath();
                } else {
                    String path = this.uri.getPath();
                    if (path == null) {
                        this.pathName = "";
                        return this.pathName;
                    }
                    int lastSepIndex = path.lastIndexOf("/");
                    if (lastSepIndex <= 0) {
                        URI uriOut = new URI(this.uri.getScheme(), this.uri.getHost(), null, null);
                        this.pathName = uriOut.toString();
                    } else {
                        URI uriOut = new URI(this.uri.getScheme(), this.uri.getHost(), path.substring(0, lastSepIndex), null);
                        this.pathName = uriOut.toString();
                    }
                }
            }
            catch (URISyntaxException e) {
                LoggerFactory.getLogger(this.getClass()).info("Failed to extract metadata from badly formed URL: " + this.uri.toString());
                return null;
            }
        }
        return this.pathName;
    }

    public void setXMLDocument(String omexml) throws ParserConfigurationException, SAXException, IOException, DependencyException, ServiceException {
        OMEXMLService svc = new ServiceFactory().getInstance(OMEXMLService.class);
        OMEModelObject root = svc.createOMEXMLRoot(omexml);
        if (!(root instanceof OME)) {
            throw new ServiceException("Root of XML document wasn't OME");
        }
        this.omexml = (OME)root;
    }

    public void setXMLDocument(InputStream isOMEXML) throws ParserConfigurationException, SAXException, IOException, DependencyException, ServiceException {
        String line;
        BufferedReader rdr = new BufferedReader(new InputStreamReader(isOMEXML));
        StringBuilder result = new StringBuilder();
        String sep = System.getProperty("line.separator");
        while ((line = rdr.readLine()) != null) {
            result.append(line);
            result.append(sep);
        }
        this.setXMLDocument(result.toString());
    }

    public void setXMLDocument(OME omexml) {
        this.omexml = omexml;
    }

    public void clearXMLDocument() {
        this.omexml = null;
    }

    public OME getMetadata() {
        return this.omexml;
    }

    public String toString() {
        return String.format("ImageFile: %s", this.uri);
    }

    @Override
    public int compareTo(ImageFile o) {
        if (this == o) {
            return 0;
        }
        return this.uri.compareTo(o.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImageFile) {
            return this.compareTo((ImageFile)obj) == 0;
        }
        return super.equals(obj);
    }

    public boolean isBlank() {
        return this.uri.getScheme().equals(BLANK_URI_SCHEME) && this.uri.getAuthority().equals(BLANK_URI_AUTHORITY) && this.uri.getPath().equals(BLANK_URI_PATH);
    }

    public int getBlankSizeX() {
        Matcher m = BLANK_URI_QUERY_PATTERN.matcher(this.uri.getQuery());
        m.find();
        return Integer.valueOf(m.group(1));
    }

    public int getBlankSizeY() {
        Matcher m = BLANK_URI_QUERY_PATTERN.matcher(this.uri.getQuery());
        m.find();
        return Integer.valueOf(m.group(2));
    }
}

