/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.imageset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.imglib2.meta.Axes;
import net.imglib2.meta.TypedAxis;
import ome.xml.model.Image;
import org.cellprofiler.imageset.ImagePlane;
import org.cellprofiler.imageset.ImagePlaneDetails;
import org.cellprofiler.imageset.ImagePlaneDetailsStack;
import org.cellprofiler.imageset.ImageSeries;
import org.cellprofiler.imageset.ImageSet;
import org.cellprofiler.imageset.ImageSetError;
import org.cellprofiler.imageset.ImageSetMissingError;
import org.cellprofiler.imageset.PlaneStack;
import org.cellprofiler.imageset.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelFilter {
    private final Filter<ImagePlaneDetailsStack> filter;
    private final String name;
    private final TypedAxis[] axes;
    private static final String SHORT_IMAGESET_MISSING_MSG = "Image missing from channel";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelFilter.class);

    public ChannelFilter(String channelName, Filter<ImagePlaneDetailsStack> filter, TypedAxis[] axes) {
        this.name = channelName;
        this.filter = filter;
        this.axes = axes;
    }

    public ChannelFilter(String channelName, TypedAxis[] axes) {
        this(channelName, null, axes);
    }

    public Filter<ImagePlaneDetailsStack> getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }

    public TypedAxis[] getAxes() {
        return this.axes;
    }

    public List<ImagePlaneDetailsStack> makeStacks(List<ImagePlaneDetails> ipds) {
        List<ImagePlaneDetailsStack> stacks = this.getStacks(ipds);
        if (this.filter == null) {
            return stacks;
        }
        ArrayList<ImagePlaneDetailsStack> filteredStacks = new ArrayList<ImagePlaneDetailsStack>();
        for (ImagePlaneDetailsStack stack : stacks) {
            if (!this.filter.eval(stack)) continue;
            filteredStacks.add(stack);
        }
        return filteredStacks;
    }

    public static List<ImageSet> makeImageSets(List<ChannelFilter> channels, List<ImagePlaneDetails> ipds, List<ImageSetError> errors, Comparator<ImagePlaneDetailsStack> ordering) {
        ArrayList<List<ImagePlaneDetailsStack>> channelStacks = new ArrayList<List<ImagePlaneDetailsStack>>(channels.size());
        int nImageSets = Integer.MAX_VALUE;
        int nMaxImageSets = 0;
        for (ChannelFilter channel : channels) {
            List<ImagePlaneDetailsStack> stacks = channel.makeStacks(ipds);
            Collections.sort(stacks, ordering);
            channelStacks.add(stacks);
            nImageSets = Math.min(nImageSets, stacks.size());
            nMaxImageSets = Math.max(nImageSets, stacks.size());
        }
        ArrayList<ImageSet> result = new ArrayList<ImageSet>(nImageSets);
        if (nMaxImageSets == 0) {
            LOGGER.warn("Empty image set list: no images passed the filtering criteria.");
            return result;
        }
        int nDigits = (int)Math.log10(nMaxImageSets) + 1;
        String keyFormat = String.format("%%0%dd", nDigits);
        if (nImageSets < nMaxImageSets) {
            int i;
            LOGGER.warn("Channels have different numbers of images:");
            ChannelFilter badChannel = null;
            for (i = 0; i < channels.size(); ++i) {
                int nImages = ((List)channelStacks.get(i)).size();
                ChannelFilter channelFilter = channels.get(i);
                if (nImages == nImageSets) {
                    badChannel = channelFilter;
                }
                String msgFormat = nImages == 1 ? "    Channel %s: %d image" : "    Channel %s: %d images";
                LOGGER.warn(String.format(msgFormat, channelFilter.getName(), nImages));
            }
            for (i = nImageSets; i < nMaxImageSets; ++i) {
                errors.add(new ImageSetMissingError(badChannel.getName(), SHORT_IMAGESET_MISSING_MSG, Collections.singletonList(String.format(keyFormat, i + 1))));
            }
        }
        for (int i = 0; i < nImageSets; ++i) {
            ArrayList<ImagePlaneDetailsStack> stacks = new ArrayList<ImagePlaneDetailsStack>(channels.size());
            for (int j = 0; j < channels.size(); ++j) {
                stacks.add((ImagePlaneDetailsStack)((List)channelStacks.get(j)).get(i));
            }
            result.add(new ImageSet(stacks, Collections.singletonList(String.format(keyFormat, i + 1))));
        }
        return result;
    }

    public static List<ImageSet> makeImageSets(List<ChannelFilter> channels, List<ImagePlaneDetails> ipds, List<ImageSetError> errors) {
        return ChannelFilter.makeImageSets(channels, ipds, errors, new DefaultOrdering());
    }

    private List<ImagePlaneDetailsStack> getStacks(List<ImagePlaneDetails> ipds) {
        for (TypedAxis axis : this.axes) {
            if (axis.type().equals(Axes.CHANNEL)) {
                return this.getColorStacks(ipds);
            }
            if (!axis.type().equals(PlaneStack.OBJECT_PLANE_AXIS_TYPE)) continue;
            return this.getObjectStacks(ipds);
        }
        return this.getMonochromeStacks(ipds);
    }

    private List<ImagePlaneDetailsStack> getMonochromeStacks(List<ImagePlaneDetails> ipds) {
        ArrayList<ImagePlaneDetailsStack> result = new ArrayList<ImagePlaneDetailsStack>();
        for (ImagePlaneDetails ipd : ipds) {
            result.add(ImagePlaneDetailsStack.makeMonochromeStack(ipd.coerceToMonochrome()));
        }
        return result;
    }

    private List<ImagePlaneDetailsStack> getColorStacks(List<ImagePlaneDetails> ipds) {
        ipds = new ArrayList<ImagePlaneDetails>(ipds);
        Collections.sort(ipds, new ColorOrdering());
        ArrayList<ImagePlaneDetailsStack> result = new ArrayList<ImagePlaneDetailsStack>();
        ArrayList<ImagePlaneDetails> groupingPlanes = new ArrayList<ImagePlaneDetails>();
        for (ImagePlaneDetails ipd : ipds) {
            ImagePlane imagePlane = ipd.getImagePlane();
            if (imagePlane.hasCZT()) {
                groupingPlanes.add(ipd);
                continue;
            }
            result.add(ImagePlaneDetailsStack.makeColorStack(ipd.coerceToColor()));
        }
        if (groupingPlanes.size() > 0) {
            ImagePlaneDetailsStack stack = new ImagePlaneDetailsStack(PlaneStack.XYCAxes);
            int lastChannel = -1;
            for (ImagePlaneDetails ipd : groupingPlanes) {
                Integer c = ipd.getImagePlane().theC();
                if (c > lastChannel) {
                    stack.add(ipd, 0, 0, c);
                } else {
                    result.add(stack);
                    stack = ImagePlaneDetailsStack.makeColorStack(ipd);
                }
                lastChannel = c;
            }
            result.add(stack);
        }
        return result;
    }

    private List<ImagePlaneDetailsStack> getObjectStacks(List<ImagePlaneDetails> ipds) {
        ipds = new ArrayList<ImagePlaneDetails>(ipds);
        Collections.sort(ipds, new ObjectsOrdering());
        ArrayList<ImagePlaneDetailsStack> result = new ArrayList<ImagePlaneDetailsStack>();
        ArrayList<ImagePlaneDetails> groupingPlanes = new ArrayList<ImagePlaneDetails>();
        for (ImagePlaneDetails ipd : ipds) {
            ImagePlane imagePlane = ipd.getImagePlane();
            if (imagePlane.getOMEPlane() != null) {
                groupingPlanes.add(ipd);
                continue;
            }
            result.add(ImagePlaneDetailsStack.makeObjectsStack(ipd));
        }
        if (groupingPlanes.size() > 0) {
            ImagePlaneDetailsStack stack = new ImagePlaneDetailsStack(PlaneStack.XYOAxes);
            int lastIndex = -1;
            for (ImagePlaneDetails ipd : groupingPlanes) {
                int index = ipd.getImagePlane().getIndex();
                if (index > lastIndex) {
                    stack.add(ipd, 0, 0, index);
                } else {
                    result.add(stack);
                    stack = ImagePlaneDetailsStack.makeObjectsStack(ipd);
                }
                lastIndex = index;
            }
            result.add(stack);
        }
        return result;
    }

    public static class DefaultOrdering
    implements Comparator<ImagePlaneDetailsStack> {
        private Comparator<ImagePlaneDetails> ipdComparator = new ColorOrdering();

        @Override
        public int compare(ImagePlaneDetailsStack o1, ImagePlaneDetailsStack o2) {
            return this.ipdComparator.compare((ImagePlaneDetails)o1.iterator().next(), (ImagePlaneDetails)o2.iterator().next());
        }
    }

    public static class ObjectsOrdering
    extends OrderingBase {
        @Override
        protected int compare(ImagePlane aImagePlane, ImagePlane bImagePlane) {
            return aImagePlane.getIndex() - bImagePlane.getIndex();
        }
    }

    public static class ColorOrdering
    extends OrderingBase {
        @Override
        public int compare(ImagePlane aImagePlane, ImagePlane bImagePlane) {
            int result = aImagePlane.theT() - bImagePlane.theT();
            if (result != 0) {
                return result;
            }
            result = aImagePlane.theZ() - bImagePlane.theZ();
            if (result != 0) {
                return result;
            }
            return aImagePlane.theC() - bImagePlane.theC();
        }
    }

    public static abstract class OrderingBase
    implements Comparator<ImagePlaneDetails> {
        @Override
        public int compare(ImagePlaneDetails a, ImagePlaneDetails b) {
            ImagePlane planeA = a.getImagePlane();
            ImagePlane planeB = b.getImagePlane();
            int result = planeA.getImageFile().getURI().compareTo(planeB.getImageFile().getURI());
            if (result != 0) {
                return result;
            }
            ImageSeries seriesA = planeA.getSeries();
            ImageSeries seriesB = planeB.getSeries();
            result = seriesA.getSeries() - seriesB.getSeries();
            if (result != 0) {
                return result;
            }
            Image omeImageA = seriesA.getOMEImage();
            Image omeImageB = seriesB.getOMEImage();
            if (omeImageA == null) {
                return omeImageA == null ? 0 : -1;
            }
            if (omeImageB == null) {
                return 1;
            }
            return this.compare(planeA, planeB);
        }

        @Override
        protected abstract int compare(ImagePlane var1, ImagePlane var2);
    }
}

