/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.headlesspreferences;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

public class HeadlessPreferencesFactory
implements PreferencesFactory {
    static final HeadlessPreferences root = new HeadlessPreferences(null, "");

    @Override
    public Preferences systemRoot() {
        return root;
    }

    @Override
    public Preferences userRoot() {
        return root;
    }

    static class HeadlessPreferences
    extends AbstractPreferences {
        private final Map<String, String> d = new HashMap<String, String>();
        private final Map<String, HeadlessPreferences> children = new HashMap<String, HeadlessPreferences>();
        private boolean alive = true;

        protected HeadlessPreferences(AbstractPreferences parent, String name) {
            super(parent, name);
        }

        private void checkAlive() {
            if (!this.alive) {
                throw new IllegalStateException("This preferences node has been removed");
            }
        }

        @Override
        protected void putSpi(String key, String value) {
            this.checkAlive();
            this.d.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            this.checkAlive();
            return this.d.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.checkAlive();
            this.d.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            this.alive = false;
            this.d.clear();
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            this.checkAlive();
            return this.d.keySet().toArray(new String[0]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            this.checkAlive();
            return this.children.keySet().toArray(new String[0]);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            this.checkAlive();
            if (!this.children.containsKey(name)) {
                HeadlessPreferences result = new HeadlessPreferences(this, name);
                this.children.put(name, result);
                result.newNode = true;
                return result;
            }
            return this.children.get(name);
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
        }
    }
}

