/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import omero.ClientError;
import omero.ServerError;
import omero.api.RawPixelsStorePrx;
import omero.api.ServiceFactoryPrx;
import omero.model.Pixels;
import omero.util.RPSTileData;
import omero.util.TileData;
import omero.util.TileLoop;
import omero.util.TileLoopIteration;

public class RPSTileLoop
extends TileLoop {
    protected final ServiceFactoryPrx session;
    protected volatile Pixels pixels;

    public RPSTileLoop(ServiceFactoryPrx session, Pixels pixels) {
        this.session = session;
        this.pixels = pixels;
        if (pixels == null || pixels.getId() == null) {
            throw new ClientError("pixels instance must be managed!");
        }
    }

    protected ServiceFactoryPrx getSession() {
        return this.session;
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels) {
        this.pixels = pixels;
    }

    @Override
    public TileData createData() {
        try {
            RawPixelsStorePrx rps = this.getSession().createRawPixelsStore();
            rps.setPixelsId(this.getPixels().getId().getValue(), false);
            return new RPSTileData(this, rps);
        }
        catch (ServerError se) {
            throw new RuntimeException(se);
        }
    }

    public int forEachTile(int tileWidth, int tileHeight, TileLoopIteration iteration) throws ClientError, ServerError {
        if (!this.pixels.isLoaded()) {
            try {
                this.pixels = this.getSession().getPixelsService().retrievePixDescription(this.pixels.getId().getValue());
            }
            catch (Exception e) {
                throw new ClientError("Failed to load " + this.pixels.getId().getValue() + "\n" + e);
            }
        }
        int sizeX = this.pixels.getSizeX().getValue();
        int sizeY = this.pixels.getSizeY().getValue();
        int sizeZ = this.pixels.getSizeZ().getValue();
        int sizeC = this.pixels.getSizeC().getValue();
        int sizeT = this.pixels.getSizeT().getValue();
        return this.forEachTile(sizeX, sizeY, sizeZ, sizeC, sizeT, tileWidth, tileHeight, iteration);
    }
}

