/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import Ice.Communicator;
import Ice.Object;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectFactoryRegistry {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public abstract Map<String, ObjectFactory> createFactories(Communicator var1);

    public void setIceCommunicator(Communicator ic) {
        Map<String, ObjectFactory> factories = this.createFactories(ic);
        for (ObjectFactory of : factories.values()) {
            of.register(this.log, ic, false);
        }
    }

    public static abstract class ObjectFactory
    implements Ice.ObjectFactory {
        private final String id;

        public ObjectFactory(String id) {
            this.id = id;
        }

        public void register(Logger log, Communicator ic, boolean strict) {
            if (strict) {
                ic.addObjectFactory(this, this.id);
            } else {
                Ice.ObjectFactory of = ic.findObjectFactory(this.id);
                if (null == of) {
                    ic.addObjectFactory(this, this.id);
                } else {
                    log.debug(String.format("ObjectFactory already exists: %s=%s", this.id, of));
                }
            }
        }

        @Override
        public abstract Object create(String var1);

        @Override
        public void destroy() {
        }
    }
}

