/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import Ice.UserException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.conditions.RootException;
import ome.model.IObject;
import ome.model.ModelBased;
import ome.model.internal.Details;
import ome.model.units.Unit;
import ome.model.units.UnitEnum;
import ome.parameters.QueryParameter;
import ome.services.blitz.util.ConvertToBlitzExceptionMessage;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.Roles;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.PermDetails;
import ome.util.ReverseModelMapper;
import ome.util.Utils;
import ome.xml.model.MapPair;
import omeis.providers.re.codomain.ReverseIntensityContext;
import omeis.providers.re.data.PlaneDef;
import omero.ApiUsageException;
import omero.AuthenticationException;
import omero.ConcurrencyException;
import omero.DatabaseBusyException;
import omero.ExpiredCredentialException;
import omero.GroupSecurityViolation;
import omero.Internal;
import omero.InternalException;
import omero.LockTimeout;
import omero.MissingPyramidException;
import omero.OptimisticLockException;
import omero.OverUsageException;
import omero.QueryException;
import omero.RBool;
import omero.RClass;
import omero.RDouble;
import omero.RFloat;
import omero.RInt;
import omero.RLong;
import omero.RObject;
import omero.RString;
import omero.RTime;
import omero.RType;
import omero.ReadOnlyGroupSecurityViolation;
import omero.RemovedSessionException;
import omero.ResourceError;
import omero.SecurityViolation;
import omero.ServerError;
import omero.SessionTimeoutException;
import omero.TryAgain;
import omero.ValidationException;
import omero.model.NamedValue;
import omero.model.Permissions;
import omero.model.PermissionsI;
import omero.model.ReverseIntensityContextI;
import omero.romio.CodomainMapContext;
import omero.romio.PlaneDefWithMasks;
import omero.romio.RGBBuffer;
import omero.romio.RegionDef;
import omero.romio.ReverseIntensityMapContext;
import omero.rtypes;
import omero.sys.Filter;
import omero.sys.Options;
import omero.sys.Parameters;
import omero.sys.Principal;
import omero.util.IceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceMapper
extends ModelMapper
implements ReverseModelMapper {
    private static Logger log = LoggerFactory.getLogger(IceMapper.class);
    private final ReturnMapping mapping;
    public static final ReturnMapping VOID = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value != null) {
                throw new IllegalArgumentException("Method is void");
            }
            return null;
        }
    };
    public static final ReturnMapping FILTERABLE = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            return mapper.map((Filterable)value);
        }
    };
    public static final ReturnMapping FILTERABLE_ARRAY = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            Filterable[] array = (Filterable[])value;
            if (array == null) {
                return null;
            }
            ArrayList<ModelBased> rv = new ArrayList<ModelBased>(array.length);
            for (int i = 0; i < array.length; ++i) {
                rv.add(mapper.map(array[i]));
            }
            return rv;
        }
    };
    public static final ReturnMapping FILTERABLE_COLLECTION = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            Collection coll = (Collection)value;
            if (coll == null) {
                return null;
            }
            ArrayList<ModelBased> rv = new ArrayList<ModelBased>();
            for (Filterable f : coll) {
                rv.add(mapper.map(f));
            }
            return rv;
        }
    };
    public static final ReturnMapping OBJECTARRAY_TO_RTYPESEQ = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value == null) {
                return null;
            }
            Object[] objArr = (Object[])value;
            ArrayList<RType> rv = new ArrayList<RType>();
            for (Object obj : objArr) {
                rv.add((RType)OBJECT_TO_RTYPE.mapReturnValue(mapper, obj));
            }
            return rv;
        }
    };
    public static final ReturnMapping LISTOBJECTARRAY_TO_RTYPESEQSEQ = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value == null) {
                return null;
            }
            List listObjArr = (List)value;
            ArrayList<List> rv = new ArrayList<List>();
            for (Object[] objs : listObjArr) {
                rv.add((List)OBJECTARRAY_TO_RTYPESEQ.mapReturnValue(mapper, objs));
            }
            return rv;
        }
    };
    public static final ReturnMapping OBJECT_TO_RTYPE = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            return mapper.toRType(value);
        }
    };
    public static final ReturnMapping STRING_TO_RSTRING = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            String str = (String)value;
            return rtypes.rstring(str);
        }
    };
    public static final ReturnMapping UNMAPPED = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            return value;
        }
    };
    public static final ReturnMapping PRIMITIVE = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value == null) {
                return null;
            }
            if (!IceMapper.isNullablePrimitive(value.getClass())) {
                throw new RuntimeException("Object not nullable primitive: " + value);
            }
            return value;
        }
    };
    public static final ReturnMapping PRIMITIVE_MAP = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value == null) {
                return null;
            }
            Map map = (Map)value;
            HashMap<Object, Object> rv = new HashMap<Object, Object>();
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                Object kr = PRIMITIVE.mapReturnValue(mapper, k);
                Object vr = PRIMITIVE.mapReturnValue(mapper, v);
                rv.put(kr, vr);
            }
            return rv;
        }
    };
    public static final ReturnMapping FILTERABLE_PRIMITIVE_MAP = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value == null) {
                return null;
            }
            Map map = (Map)value;
            HashMap<Object, Object> rv = new HashMap<Object, Object>();
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                Object kr = FILTERABLE.mapReturnValue(mapper, k);
                Object vr = PRIMITIVE.mapReturnValue(mapper, v);
                rv.put(kr, vr);
            }
            return rv;
        }
    };
    public static final ReturnMapping PRIMITIVE_FILTERABLE_COLLECTION_MAP = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value == null) {
                return null;
            }
            Map map = (Map)value;
            HashMap<Object, Object> rv = new HashMap<Object, Object>();
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                Object kr = PRIMITIVE.mapReturnValue(mapper, k);
                Object vr = FILTERABLE_COLLECTION.mapReturnValue(mapper, v);
                rv.put(kr, vr);
            }
            return rv;
        }
    };
    public static final ReturnMapping RTYPEDICT = new ReturnMapping(){

        @Override
        public Object mapReturnValue(IceMapper mapper, Object value) throws UserException {
            if (value == null) {
                return null;
            }
            Map map = (Map)value;
            HashMap<Object, Object> rv = new HashMap<Object, Object>();
            for (Object k : map.keySet()) {
                Object v = map.get(k);
                Object kr = PRIMITIVE.mapReturnValue(mapper, k);
                Object vr = OBJECT_TO_RTYPE.mapReturnValue(mapper, v);
                rv.put(kr, vr);
            }
            return rv;
        }
    };
    protected Map<Object, Object> target2model = new IdentityHashMap<Object, Object>();

    public IceMapper() {
        this.mapping = null;
    }

    public IceMapper(ReturnMapping mapping) {
        this.mapping = mapping;
    }

    public boolean isVoid() {
        return this.canMapReturnValue() && this.mapping == VOID;
    }

    public boolean canMapReturnValue() {
        return this.mapping != null;
    }

    public Object mapReturnValue(Object value) throws UserException {
        return this.mapping.mapReturnValue(this, value);
    }

    public static ServerError fillServerError(ServerError se, Throwable t) {
        se.message = t.getMessage();
        se.serverExceptionClass = t.getClass().getName();
        se.serverStackTrace = IceMapper.stackAsString(t);
        return se;
    }

    private static Class<? extends IObject> _class(String className) {
        Class<?> k = null;
        try {
            k = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return k;
    }

    public static Class<? extends IObject> omeroClass(String className, boolean strict) throws ApiUsageException {
        Class k = IceMapper._class(className);
        if (k == null) {
            k = IceMapper._class("omero.model." + className);
        }
        if (k != null && !IceMap.OMEtoOMERO.containsKey(k)) {
            k = IceMap.OMEROtoOME.get(k);
        }
        if (k == null && log.isDebugEnabled()) {
            log.debug(className + " does not specify a valid class.");
        }
        if (k == null && strict) {
            ApiUsageException aue = new ApiUsageException();
            aue.message = className + " does not specify a valid class.";
            throw aue;
        }
        return k;
    }

    public RType toRType(Object o) throws ApiUsageException {
        if (o == null) {
            return null;
        }
        if (o instanceof RType) {
            return (RType)o;
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            RBool bool = rtypes.rbool(b);
            return bool;
        }
        if (o instanceof Class) {
            Class c = (Class)o;
            RClass rc = rtypes.rclass(c.getName());
            return rc;
        }
        if (o instanceof Date) {
            Date date = (Date)o;
            RTime time = rtypes.rtime(date.getTime());
            return time;
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            RInt rint = rtypes.rint(i);
            return rint;
        }
        if (o instanceof Long) {
            Long lng = (Long)o;
            RLong rlng = rtypes.rlong(lng);
            return rlng;
        }
        if (o instanceof Float) {
            Float flt = (Float)o;
            RFloat rflt = rtypes.rfloat(flt.floatValue());
            return rflt;
        }
        if (o instanceof Double) {
            Double dbl = (Double)o;
            RDouble rdbl = rtypes.rdouble(dbl);
            return rdbl;
        }
        if (o instanceof String) {
            String str = (String)o;
            RString rstr = rtypes.rstring(str);
            return rstr;
        }
        if (o instanceof PermDetails) {
            PermDetails p = (PermDetails)o;
            return this.toRType(p.getDetails().getPermissions());
        }
        if (o instanceof IObject) {
            IObject obj = (IObject)o;
            omero.model.IObject om = (omero.model.IObject)((Object)this.map(obj));
            RObject robj = rtypes.robject(om);
            return robj;
        }
        if (o instanceof Collection) {
            ArrayList<RType> l = new ArrayList<RType>();
            for (Object i : (Collection)o) {
                l.add(this.toRType(i));
            }
            return rtypes.rlist(l);
        }
        if (o instanceof Map) {
            Map mIn = (Map)o;
            HashMap<String, RType> mOut = new HashMap<String, RType>();
            for (Object k : mIn.keySet()) {
                if (!(k instanceof String)) {
                    throw new ValidationException(null, null, "Map key not a string");
                }
                mOut.put((String)k, this.toRType(mIn.get(k)));
            }
            return rtypes.rmap(mOut);
        }
        if (o instanceof Internal) {
            return rtypes.rinternal((Internal)o);
        }
        if (o instanceof ome.model.internal.Permissions) {
            ome.model.internal.Permissions p = (ome.model.internal.Permissions)o;
            HashMap<String, RType> rv = new HashMap<String, RType>();
            rv.put("perm", rtypes.rstring(p.toString()));
            rv.put("canAnnotate", rtypes.rbool(!p.isDisallowAnnotate()));
            rv.put("canDelete", rtypes.rbool(!p.isDisallowDelete()));
            rv.put("canEdit", rtypes.rbool(!p.isDisallowEdit()));
            rv.put("canLink", rtypes.rbool(!p.isDisallowLink()));
            return rtypes.rmap(rv);
        }
        if (o instanceof Unit) {
            Unit u = (Unit)o;
            HashMap<String, RType> rv = new HashMap<String, RType>();
            rv.put("value", rtypes.rdouble(u.getValue()));
            rv.put("unit", rtypes.rstring(u.getUnit().toString()));
            rv.put("symbol", rtypes.rstring(u.getUnit().getSymbol()));
            return rtypes.rmap(rv);
        }
        if (o instanceof UnitEnum) {
            return rtypes.rstring(((UnitEnum)o).toString());
        }
        throw new ApiUsageException(null, null, "Unsupported conversion to rtype from " + o.getClass().getName() + ":" + o);
    }

    public Object fromRType(RType rt) throws ApiUsageException {
        if (rt == null) {
            return null;
        }
        if (rt instanceof rtypes.Conversion) {
            rtypes.Conversion conv = (rtypes.Conversion)((Object)rt);
            return conv.convert(this);
        }
        ApiUsageException aue = new ApiUsageException();
        aue.message = rt.getClass() + " is not a conversion type";
        throw aue;
    }

    public static omero.sys.EventContext convert(EventContext ctx) {
        if (ctx == null) {
            return null;
        }
        omero.sys.EventContext ec = new omero.sys.EventContext();
        Long event = ctx.getCurrentEventId();
        ec.eventId = event == null ? -1L : event;
        Long shareId = ctx.getCurrentShareId();
        ec.shareId = shareId == null ? -1L : shareId;
        ec.sessionId = ctx.getCurrentSessionId();
        ec.sessionUuid = ctx.getCurrentSessionUuid();
        ec.eventType = ctx.getCurrentEventType();
        ec.groupId = ctx.getCurrentGroupId();
        ec.groupName = ctx.getCurrentGroupName();
        ec.userId = ctx.getCurrentUserId();
        ec.userName = ctx.getCurrentUserName();
        ec.leaderOfGroups = ctx.getLeaderOfGroupsList();
        ec.memberOfGroups = ctx.getMemberOfGroupsList();
        ec.isAdmin = ctx.isCurrentUserAdmin();
        ec.groupPermissions = IceMapper.convert(ctx.getCurrentGroupPermissions());
        return ec;
    }

    public static RGBBuffer convert(omeis.providers.re.RGBBuffer buffer) {
        RGBBuffer b = new RGBBuffer();
        b.bands = new byte[3][];
        b.bands[0] = buffer.getRedBand();
        b.bands[1] = buffer.getGreenBand();
        b.bands[2] = buffer.getBlueBand();
        b.sizeX1 = buffer.getSizeX1();
        b.sizeX2 = buffer.getSizeX2();
        return b;
    }

    public omeis.providers.re.codomain.CodomainMapContext convert(CodomainMapContext ctx) {
        if (!(ctx instanceof ReverseIntensityMapContext)) {
            return null;
        }
        return new ReverseIntensityContext();
    }

    public static PlaneDef convert(omero.romio.PlaneDef def) throws ApiUsageException {
        PlaneDef pd = new PlaneDef(def.slice, def.t);
        pd.setStride(def.stride);
        RegionDef r = def.region;
        if (r != null) {
            pd.setRegion(new omeis.providers.re.data.RegionDef(r.x, r.y, r.width, r.height));
        }
        if (def instanceof PlaneDefWithMasks) {
            pd.setRenderShapes(true);
            if (((PlaneDefWithMasks)def).shapeIds != null) {
                pd.setShapeIds(((PlaneDefWithMasks)def).shapeIds);
            }
        }
        switch (def.slice) {
            case 0: {
                pd.setZ(def.z);
                break;
            }
            case 1: {
                pd.setX(def.x);
                break;
            }
            case 2: {
                pd.setY(def.y);
                break;
            }
            default: {
                ApiUsageException aue = new ApiUsageException();
                aue.message = "Unknown slice for " + def;
                throw aue;
            }
        }
        return pd;
    }

    public static ome.system.Principal convert(Principal old) {
        if (old == null) {
            return null;
        }
        return new ome.system.Principal(old.name, old.group, old.eventType);
    }

    public static omero.sys.Roles convert(Roles roles) {
        omero.sys.Roles r = new omero.sys.Roles();
        r.rootId = roles.getRootId();
        r.rootName = roles.getRootName();
        r.systemGroupId = roles.getSystemGroupId();
        r.systemGroupName = roles.getSystemGroupName();
        r.userGroupId = roles.getUserGroupId();
        r.userGroupName = roles.getUserGroupName();
        r.guestId = roles.getGuestId();
        r.guestName = roles.getGuestName();
        r.guestGroupId = roles.getGuestGroupId();
        r.guestGroupName = roles.getGuestGroupName();
        return r;
    }

    public static RTime convert(Date date) {
        return rtypes.rtime(date);
    }

    public static Timestamp convert(RTime time) {
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getValue());
    }

    public ome.parameters.Parameters convert(Parameters params) throws ApiUsageException {
        if (params == null) {
            return null;
        }
        ome.parameters.Parameters p = new ome.parameters.Parameters();
        if (params.map != null) {
            for (String name : params.map.keySet()) {
                RType obj = params.map.get(name);
                p.add(this.convert(name, obj));
            }
        }
        if (params.theFilter != null) {
            p.setFilter(IceMapper.convert(params.theFilter));
        }
        if (params.theOptions != null) {
            p.setOptions(IceMapper.convert(params.theOptions));
        }
        return p;
    }

    public QueryParameter convert(String key, Object o) throws ApiUsageException {
        if (o == null) {
            return null;
        }
        String name = key;
        Class<?> klass = o.getClass();
        Object value = null;
        if (!RType.class.isAssignableFrom(klass)) {
            ApiUsageException aue = new ApiUsageException();
            aue.message = "Query parameter must be a subclass of RType " + o;
            throw aue;
        }
        value = this.fromRType((RType)o);
        klass = ((rtypes.Conversion)o).type();
        QueryParameter qp = new QueryParameter(name, klass, value);
        return qp;
    }

    public static ome.parameters.Options convert(Options o) {
        if (o == null) {
            return null;
        }
        ome.parameters.Options options = new ome.parameters.Options();
        if (o.orphan != null) {
            options.orphan = o.orphan.getValue();
        }
        if (o.leaves != null) {
            options.leaves = o.leaves.getValue();
        }
        if (o.acquisitionData != null) {
            options.acquisitionData = o.acquisitionData.getValue();
        }
        return options;
    }

    public static ome.parameters.Filter convert(Filter f) {
        if (f == null) {
            return null;
        }
        ome.parameters.Filter filter = new ome.parameters.Filter();
        if (f.offset != null) {
            filter.offset = f.offset.getValue();
        }
        if (f.limit != null) {
            filter.limit = f.limit.getValue();
        }
        if (f.ownerId != null) {
            filter.owner(f.ownerId.getValue());
        }
        if (f.groupId != null) {
            filter.group(f.groupId.getValue());
        }
        if (f.startTime != null) {
            filter.startTime = IceMapper.convert(f.startTime);
        }
        if (f.endTime != null) {
            filter.endTime = IceMapper.convert(f.endTime);
        }
        if (f.unique != null && f.unique.getValue()) {
            filter.unique();
        }
        return filter;
    }

    public static List<NamedValue> convertNamedValueList(List<ome.model.internal.NamedValue> map) {
        if (map == null) {
            return null;
        }
        ArrayList<NamedValue> nvl = new ArrayList<NamedValue>(map.size());
        for (ome.model.internal.NamedValue nv : map) {
            if (nv == null) {
                nvl.add(null);
                continue;
            }
            String name = nv.getName();
            String value = nv.getValue();
            nvl.add(new NamedValue(name, value));
        }
        return nvl;
    }

    public static List<NamedValue> convertMapPairs(List<MapPair> map) {
        if (map == null) {
            return null;
        }
        ArrayList<NamedValue> nvl = new ArrayList<NamedValue>(map.size());
        for (MapPair nv : map) {
            if (nv == null) {
                nvl.add(null);
                continue;
            }
            String name = nv.getName();
            String value = nv.getValue();
            nvl.add(new NamedValue(name, value));
        }
        return nvl;
    }

    public static Map<String, RString> convertStringStringMap(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, RString> rMap = new HashMap<String, RString>(map.size());
        for (Map.Entry<String, String> mapEntry : map.entrySet()) {
            String key = mapEntry.getKey();
            String value = mapEntry.getValue();
            if (value == null) continue;
            rMap.put(key, rtypes.rstring(value));
        }
        return rMap;
    }

    @Override
    public Collection findCollection(Collection source) {
        if (source == null) {
            return null;
        }
        ArrayList target = (ArrayList)this.model2target.get(source);
        if (null == target) {
            target = new ArrayList();
            this.model2target.put(source, target);
        }
        return target;
    }

    public List map(Filterable[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new ArrayList();
        }
        ArrayList<ModelBased> l = new ArrayList<ModelBased>(array.length);
        for (int i = 0; i < array.length; ++i) {
            l.add(this.map(array[i]));
        }
        return l;
    }

    public static Permissions convert(ome.model.internal.Permissions p) {
        if (p == null) {
            return null;
        }
        return new PermissionsI(p.toString());
    }

    public static ome.model.internal.Permissions convert(Permissions p) {
        if (p == null) {
            return null;
        }
        return Utils.toPermissions(p.getPerm1());
    }

    public boolean isImmutable(Object obj) {
        return null == obj || obj instanceof Number || obj instanceof Number[] || obj instanceof String || obj instanceof String[] || obj instanceof Boolean || obj instanceof Boolean[];
    }

    public Object reverse(Object source) throws ApiUsageException {
        if (source == null) {
            return null;
        }
        if (Collection.class.isAssignableFrom(source.getClass())) {
            return this.reverse((Collection)source);
        }
        if (ModelBased.class.isAssignableFrom(source.getClass())) {
            return this.reverse((ModelBased)source);
        }
        if (this.isImmutable(source)) {
            return source;
        }
        if (RType.class.isAssignableFrom(source.getClass())) {
            return this.fromRType((RType)source);
        }
        ApiUsageException aue = new ApiUsageException();
        aue.message = "Don't know how to reverse " + source;
        throw aue;
    }

    @Override
    public Collection reverse(Collection source) {
        return this.reverse(source, source == null ? null : source.getClass());
    }

    public Collection reverse(Collection source, Class targetType) {
        if (source == null) {
            return null;
        }
        AbstractCollection target = (HashSet)this.target2model.get(source);
        if (null == target) {
            if (Set.class.isAssignableFrom(targetType)) {
                target = new HashSet();
            } else if (List.class.isAssignableFrom(targetType)) {
                target = new ArrayList();
            } else {
                throw new ome.conditions.InternalException("Unknown collection type " + targetType);
            }
            this.target2model.put(source, target);
            try {
                for (Object object : source) {
                    target.add(this.reverse(object));
                }
            }
            catch (ApiUsageException aue) {
                this.convertAndThrow(aue);
            }
        }
        return target;
    }

    public Object[] reverseArray(List list, Class type) throws ServerError {
        if (list == null) {
            return null;
        }
        Class<?> component = type.getComponentType();
        Object[] array = null;
        try {
            array = (Object[])Array.newInstance(component, list.size());
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.handleInput(component, list.get(i));
            }
        }
        catch (Exception e) {
            String msg = "Cannot create array from type " + type;
            if (log.isErrorEnabled()) {
                log.error(msg, e);
            }
            ApiUsageException aue = new ApiUsageException();
            aue.message = msg;
            aue.serverExceptionClass = e.getClass().getName();
            throw aue;
        }
        return array;
    }

    public Map reverse(Map map) {
        if (map == null) {
            return null;
        }
        if (this.target2model.containsKey(map)) {
            return (Map)this.target2model.get(map);
        }
        HashMap<Object, Object> target = new HashMap<Object, Object>();
        this.target2model.put(map, target);
        try {
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                Object targetKey = this.reverse(key);
                Object targetValue = this.reverse(value);
                target.put(targetKey, targetValue);
            }
        }
        catch (ApiUsageException aue) {
            this.convertAndThrow(aue);
        }
        return target;
    }

    @Override
    public Filterable reverse(ModelBased source) {
        if (source == null) {
            return null;
        }
        if (this.target2model.containsKey(source)) {
            return (Filterable)this.target2model.get(source);
        }
        Filterable object = source.fillObject(this);
        this.target2model.put(source, object);
        return object;
    }

    public static Map<String, String> reverseStringStringMap(Map<String, RString> rMap) {
        if (rMap == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(rMap.size());
        for (Map.Entry<String, RString> rMapEntry : rMap.entrySet()) {
            String key = rMapEntry.getKey();
            RString rValue = rMapEntry.getValue();
            String value = rValue == null ? null : rValue.getValue();
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static List<ome.model.internal.NamedValue> reverseNamedList(List<NamedValue> map) {
        if (map == null) {
            return null;
        }
        ArrayList<ome.model.internal.NamedValue> nvl = new ArrayList<ome.model.internal.NamedValue>(map.size());
        for (NamedValue nv : map) {
            if (nv == null) {
                nvl.add(null);
                continue;
            }
            String name = nv.name;
            String value = nv.value;
            nvl.add(new ome.model.internal.NamedValue(name, value));
        }
        return nvl;
    }

    public void store(Object source, Object target) {
        this.target2model.put(source, target);
    }

    @Override
    protected Map c2c() {
        return IceMap.OMEtoOMERO;
    }

    private void fillTarget(Filterable source, ModelBased target) {
        if (source != null && target != null) {
            target.copyObject(source, this);
        }
    }

    @Override
    public Filterable filter(String fieldId, Filterable source) {
        if (this.hasntSeen(source)) {
            this.enter(source);
            this.addSeen(source);
            source.acceptFilter(this);
            this.exit(source);
        }
        Object target = this.findTarget(source);
        this.fillTarget(source, (ModelBased)target);
        return source;
    }

    @Override
    protected boolean hasntSeen(Object o) {
        return o == null ? false : super.hasntSeen(o);
    }

    private void convertAndThrow(ApiUsageException aue) {
        ome.conditions.InternalException ie = new ome.conditions.InternalException(aue.getMessage());
        ie.setStackTrace(aue.getStackTrace());
    }

    protected boolean isPrimitive(Class<?> p) {
        return p.equals(Byte.TYPE) || p.equals(byte[].class) || p.equals(Integer.TYPE) || p.equals(int[].class) || p.equals(Long.TYPE) || p.equals(long[].class) || p.equals(Double.TYPE) || p.equals(double[].class) || p.equals(Float.TYPE) || p.equals(float[].class) || p.equals(Boolean.TYPE) || p.equals(boolean[].class) || p.equals(String.class);
    }

    protected static boolean isNullablePrimitive(Class<?> p) {
        return p.equals(String.class) || p.equals(Integer.class) || p.equals(Integer[].class) || p.equals(Long.class) || p.equals(Long[].class) || p.equals(Float.class) || p.equals(Float[].class) || p.equals(Double.class) || p.equals(Double[].class) || p.equals(Boolean.class) || p.equals(Boolean[].class);
    }

    protected static boolean isWrapperArray(Class<?> p) {
        return p.equals(Integer[].class) || p.equals(Long[].class) || p.equals(Double[].class) || p.equals(Float[].class) || p.equals(String[].class);
    }

    public Object handleInput(Class<?> p, Object arg) throws ServerError {
        if (arg instanceof RType) {
            RType rt = (RType)arg;
            return this.fromRType(rt);
        }
        if (this.isPrimitive(p) || IceMapper.isNullablePrimitive(p)) {
            return arg;
        }
        if (IceMapper.isWrapperArray(p)) {
            return this.reverseArray((List)arg, p);
        }
        if (p.equals(Class.class)) {
            return IceMapper.omeroClass((String)arg, true);
        }
        if (Details.class.isAssignableFrom(p)) {
            return this.reverse((ModelBased)arg);
        }
        if (IObject.class.isAssignableFrom(p)) {
            return this.reverse((ModelBased)arg);
        }
        if (p.equals(ome.parameters.Filter.class)) {
            return IceMapper.convert((Filter)arg);
        }
        if (p.equals(ome.system.Principal.class)) {
            return IceMapper.convert((Principal)arg);
        }
        if (p.equals(ome.parameters.Parameters.class)) {
            return this.convert((Parameters)arg);
        }
        if (List.class.isAssignableFrom(p)) {
            return this.reverse((Collection)arg);
        }
        if (Set.class.isAssignableFrom(p)) {
            return this.reverse(new HashSet((Collection)arg));
        }
        if (Collection.class.isAssignableFrom(p)) {
            return this.reverse((Collection)arg);
        }
        if (Timestamp.class.isAssignableFrom(p)) {
            if (arg != null) {
                throw new RuntimeException("This must be null here");
            }
            return null;
        }
        if (Map.class.isAssignableFrom(p)) {
            return this.reverse((Map)arg);
        }
        if (PlaneDef.class.isAssignableFrom(p)) {
            return IceMapper.convert((omero.romio.PlaneDef)arg);
        }
        if (Object[].class.isAssignableFrom(p)) {
            return this.reverseArray((List)arg, p);
        }
        if (omeis.providers.re.codomain.CodomainMapContext.class.isAssignableFrom(p)) {
            return this.convert((CodomainMapContext)arg);
        }
        throw new ApiUsageException(null, null, "Can't handle input " + p);
    }

    public Object handleOutput(Class type, Object o) throws ServerError {
        if (o == null) {
            return null;
        }
        if (RType.class.isAssignableFrom(type)) {
            return o;
        }
        if (Internal.class.isAssignableFrom(type)) {
            return rtypes.rinternal((Internal)o);
        }
        if (Void.TYPE.isAssignableFrom(type)) {
            assert (o == null);
            return null;
        }
        if (this.isPrimitive(type)) {
            return o;
        }
        if (IceMapper.isNullablePrimitive(type)) {
            return this.toRType(o);
        }
        if (omeis.providers.re.RGBBuffer.class.isAssignableFrom(type)) {
            return IceMapper.convert((omeis.providers.re.RGBBuffer)o);
        }
        if (Roles.class.isAssignableFrom(type)) {
            return IceMapper.convert((Roles)o);
        }
        if (Date.class.isAssignableFrom(type)) {
            return IceMapper.convert((Date)o);
        }
        if (EventContext.class.isAssignableFrom(type)) {
            return IceMapper.convert((EventContext)o);
        }
        if (Set.class.isAssignableFrom(type)) {
            return this.map(new ArrayList((Set)o));
        }
        if (Collection.class.isAssignableFrom(type)) {
            Object ho;
            Collection l = (Collection)o;
            if (l.size() > 0 && (ho = l.iterator().next()) instanceof omeis.providers.re.codomain.CodomainMapContext) {
                ArrayList<omero.model.CodomainMapContext> result = new ArrayList<omero.model.CodomainMapContext>();
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    omero.model.CodomainMapContext t = this.reverse((omeis.providers.re.codomain.CodomainMapContext)i.next());
                    if (t == null) continue;
                    result.add(t);
                }
                return result;
            }
            return this.map((Collection)o);
        }
        if (IObject.class.isAssignableFrom(type)) {
            return this.map((Filterable)o);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.map((Map)o);
        }
        if (Filterable[].class.isAssignableFrom(type)) {
            return this.map((Filterable[])o);
        }
        throw new ApiUsageException(null, null, "Can't handle output " + type);
    }

    private omero.model.CodomainMapContext reverse(omeis.providers.re.codomain.CodomainMapContext ctx) {
        if (ctx instanceof ReverseIntensityContext) {
            return new ReverseIntensityContextI();
        }
        return null;
    }

    public ServerError handleServerError(Throwable t, OmeroContext ctx) {
        UserException ue = this.handleException(t, ctx);
        if (ue instanceof ServerError) {
            return (ServerError)ue;
        }
        InternalException ie = new InternalException();
        IceMapper.fillServerError(ie, ue);
        return ie;
    }

    public UserException handleException(Throwable t, OmeroContext ctx) {
        Class<?> c;
        if (InvocationTargetException.class.isAssignableFrom(t.getClass())) {
            t = t.getCause();
        }
        if (log.isDebugEnabled()) {
            log.debug("Handling:", t);
        }
        if (ctx != null) {
            try {
                ConvertToBlitzExceptionMessage ctbem = new ConvertToBlitzExceptionMessage(this, t);
                ctx.publishMessage(ctbem);
                if (ctbem.to != null) {
                    t = ctbem.to;
                }
            }
            catch (Throwable handlerT) {
                log.error("Exception handler failure", handlerT);
            }
        }
        if (UserException.class.isAssignableFrom(c = t.getClass())) {
            return (UserException)t;
        }
        if (ome.conditions.OptimisticLockException.class.isAssignableFrom(c)) {
            OptimisticLockException ole = new OptimisticLockException();
            return IceMapper.fillServerError(ole, t);
        }
        if (ome.conditions.OverUsageException.class.isAssignableFrom(c)) {
            OverUsageException oue = new OverUsageException();
            return IceMapper.fillServerError(oue, t);
        }
        if (ome.services.query.QueryException.class.isAssignableFrom(c)) {
            QueryException qe = new QueryException();
            return IceMapper.fillServerError(qe, t);
        }
        if (ome.conditions.ValidationException.class.isAssignableFrom(c)) {
            ValidationException ve = new ValidationException();
            return IceMapper.fillServerError(ve, t);
        }
        if (ome.conditions.ApiUsageException.class.isAssignableFrom(c)) {
            ApiUsageException aue = new ApiUsageException();
            return IceMapper.fillServerError(aue, t);
        }
        if (ome.conditions.MissingPyramidException.class.isAssignableFrom(c)) {
            MissingPyramidException mpe = new MissingPyramidException();
            mpe.backOff = ((ome.conditions.MissingPyramidException)t).backOff;
            mpe.pixelsID = ((ome.conditions.MissingPyramidException)t).getPixelsId();
            return IceMapper.fillServerError(mpe, t);
        }
        if (ome.conditions.TryAgain.class.isAssignableFrom(c)) {
            TryAgain ta = new TryAgain();
            ta.backOff = ((ome.conditions.TryAgain)t).backOff;
            return IceMapper.fillServerError(ta, t);
        }
        if (ome.conditions.LockTimeout.class.isAssignableFrom(c)) {
            LockTimeout lt = new LockTimeout();
            lt.backOff = ((ome.conditions.LockTimeout)t).backOff;
            lt.seconds = ((ome.conditions.LockTimeout)t).seconds;
            return IceMapper.fillServerError(lt, t);
        }
        if (ome.conditions.DatabaseBusyException.class.isAssignableFrom(c)) {
            DatabaseBusyException dbe = new DatabaseBusyException();
            return IceMapper.fillServerError(dbe, t);
        }
        if (ome.conditions.ConcurrencyException.class.isAssignableFrom(c)) {
            ConcurrencyException re = new ConcurrencyException();
            return IceMapper.fillServerError(re, t);
        }
        if (ome.conditions.ResourceError.class.isAssignableFrom(c)) {
            ResourceError re = new ResourceError();
            return IceMapper.fillServerError(re, t);
        }
        if (ome.conditions.ReadOnlyGroupSecurityViolation.class.isAssignableFrom(c)) {
            ReadOnlyGroupSecurityViolation sv = new ReadOnlyGroupSecurityViolation();
            return IceMapper.fillServerError(sv, t);
        }
        if (ome.conditions.GroupSecurityViolation.class.isAssignableFrom(c)) {
            GroupSecurityViolation sv = new GroupSecurityViolation();
            return IceMapper.fillServerError(sv, t);
        }
        if (ome.conditions.SecurityViolation.class.isAssignableFrom(c)) {
            SecurityViolation sv = new SecurityViolation();
            return IceMapper.fillServerError(sv, t);
        }
        if (ome.conditions.RemovedSessionException.class.isAssignableFrom(c)) {
            RemovedSessionException rse = new RemovedSessionException();
            return IceMapper.fillServerError(rse, t);
        }
        if (ome.conditions.SessionTimeoutException.class.isAssignableFrom(c)) {
            SessionTimeoutException ste = new SessionTimeoutException();
            return IceMapper.fillServerError(ste, t);
        }
        if (ome.conditions.AuthenticationException.class.isAssignableFrom(c)) {
            AuthenticationException ae = new AuthenticationException(t.getMessage());
            return ae;
        }
        if (ome.conditions.ExpiredCredentialException.class.isAssignableFrom(c)) {
            ExpiredCredentialException ece = new ExpiredCredentialException(t.getMessage());
            return ece;
        }
        if (ome.conditions.InternalException.class.isAssignableFrom(c)) {
            InternalException ie = new InternalException();
            return IceMapper.fillServerError(ie, t);
        }
        if (RootException.class.isAssignableFrom(c)) {
            log.error("RootException thrown which is an unknown subclasss.\nThis most likely means that an exception was added to the\nome.conditions hierarchy, without being accountd for in blitz:\n" + c.getName());
        }
        InternalException ie = new InternalException();
        return IceMapper.fillServerError(ie, t);
    }

    public static interface ReturnMapping {
        public Object mapReturnValue(IceMapper var1, Object var2) throws UserException;
    }
}

