/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import omero.RDouble;
import omero.model.Point;
import omero.model.SmartPointI;
import omero.rtypes;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.DefaultPointsHandler;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.PointsHandler;
import org.apache.batik.parser.PointsParser;
import org.apache.xerces.impl.xpath.regex.ParseException;

public interface SmartShape {
    public void areaPoints(PointCallback var1);

    public Shape asAwtShape();

    public List<Point> asPoints();

    public void randomize(Random var1);

    public static interface PointCallback {
        public void handle(int var1, int var2);
    }

    public static class Util {
        public static boolean checkNonNull(List<Point> points) {
            if (points == null) {
                return false;
            }
            for (Point point : points) {
                if (point != null && point.x != null && point.y != null) continue;
                return false;
            }
            return true;
        }

        public static void appendDbPoint(StringBuilder sb, Point p) {
            Util.appendDbPoint(sb, p.x.getValue(), p.y.getValue());
        }

        public static void appendDbPoint(StringBuilder sb, double x, double y) {
            sb.append("(");
            sb.append(x);
            sb.append(",");
            sb.append(y);
            sb.append(")");
        }

        public static void appendSvgPoint(StringBuilder sb, Point p) {
            Util.appendSvgPoint(sb, p.x.getValue(), p.y.getValue());
        }

        public static void appendSvgPoint(StringBuilder sb, double x, double y) {
            sb.append(x);
            sb.append(",");
            sb.append(y);
            sb.append(" ");
        }

        public static boolean appendSegment(StringBuilder sb, boolean first, double x, double y) {
            if (first) {
                sb.append("M ");
                first = false;
            } else {
                sb.append("L ");
            }
            sb.append(x);
            sb.append(" ");
            sb.append(y);
            sb.append(" ");
            return first;
        }

        public static String pointsToPath(List<Point> points, boolean close) {
            StringBuilder sb = new StringBuilder(points.size() * 16);
            boolean first = true;
            for (Point point : points) {
                double x = point.getX().getValue();
                double y = point.getY().getValue();
                first = Util.appendSegment(sb, first, x, y);
            }
            if (close) {
                sb.append("Z");
            }
            String path = sb.toString();
            return path;
        }

        public static String parsePointsToPath(String str, boolean close) {
            final StringBuilder sb = new StringBuilder();
            final boolean[] first = new boolean[]{true};
            PointsParser pp = new PointsParser();
            DefaultPointsHandler ph = new DefaultPointsHandler(){

                public void point(float x, float y) throws ParseException {
                    first[0] = Util.appendSegment(sb, first[0], x, y);
                }
            };
            pp.setPointsHandler((PointsHandler)ph);
            pp.parse(str);
            return sb.toString();
        }

        public static Shape parseAwtPath(String str) {
            PathParser pp = new PathParser();
            AWTPathProducer ph = new AWTPathProducer();
            pp.setPathHandler((PathHandler)ph);
            pp.parse(str);
            return ph.getShape();
        }

        public static List<Point> parsePoints(String str) {
            final ArrayList<Point> points = new ArrayList<Point>();
            PointsParser pp = new PointsParser();
            DefaultPointsHandler ph = new DefaultPointsHandler(){

                public void point(float x, float y) throws ParseException {
                    SmartPointI sp = new SmartPointI();
                    sp.setX(rtypes.rdouble(x));
                    sp.setY(rtypes.rdouble(y));
                    points.add(sp);
                }
            };
            pp.setPointsHandler((PointsHandler)ph);
            pp.parse(str);
            return points;
        }

        public static List<Point> points(double x, double y, double w, double h) {
            RDouble x0 = rtypes.rdouble(x);
            RDouble y0 = rtypes.rdouble(y);
            RDouble x1 = rtypes.rdouble(x + w);
            RDouble y1 = rtypes.rdouble(y + h);
            ArrayList<Point> points = new ArrayList<Point>();
            SmartPointI tl = new SmartPointI();
            tl.setX(x0);
            tl.setY(y0);
            points.add(tl);
            SmartPointI tr = new SmartPointI();
            tr.setX(x1);
            tr.setY(y0);
            points.add(tr);
            SmartPointI br = new SmartPointI();
            br.setX(x1);
            br.setY(y1);
            points.add(br);
            SmartPointI bl = new SmartPointI();
            bl.setX(x0);
            bl.setY(y1);
            points.add(bl);
            return points;
        }

        public static void pointsByBoundingBox(Shape s, Rectangle2D r, PointCallback cb) {
            double startY;
            double xEnd = r.getX() + r.getWidth();
            double yEnd = r.getY() + r.getHeight();
            double startX = r.getX();
            for (double y = startY = r.getY(); y < yEnd; y += 1.0) {
                for (double x = startX; x < xEnd; x += 1.0) {
                    if (!s.intersects(x, y, 0.001, 0.001)) continue;
                    cb.handle((int)x, (int)y);
                }
            }
        }
    }
}

