/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import omero.model.LineI;
import omero.model.Point;
import omero.model.SmartPointI;
import omero.model.SmartShape;
import omero.rtypes;

public class SmartLineI
extends LineI
implements SmartShape {
    @Override
    public void areaPoints(SmartShape.PointCallback cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Shape asAwtShape() {
        try {
            double x1 = this.getX1().getValue();
            double x2 = this.getX2().getValue();
            double y1 = this.getY1().getValue();
            double y2 = this.getY2().getValue();
            Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
            return line;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    @Override
    public List<Point> asPoints() {
        try {
            ArrayList<Point> points = new ArrayList<Point>();
            SmartPointI start = new SmartPointI();
            start.setX(this.getX1());
            start.setY(this.getY1());
            SmartPointI end = new SmartPointI();
            end.setX(this.getX2());
            end.setY(this.getY2());
            points.addAll(start.asPoints());
            points.addAll(end.asPoints());
            assert (SmartShape.Util.checkNonNull(points)) : "Null points in " + this;
            return points;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    @Override
    public void randomize(Random random) {
        if (this.roi != null) {
            throw new UnsupportedOperationException("Roi-based values unsupported");
        }
        this.x1 = rtypes.rdouble(random.nextInt(100));
        this.x2 = rtypes.rdouble(random.nextInt(100));
        this.y1 = rtypes.rdouble(random.nextInt(100));
        this.y2 = rtypes.rdouble(random.nextInt(100));
    }
}

