/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.ObjectFactory;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import ome.model.ModelBased;
import ome.model.units.BigResult;
import ome.model.units.Conversion;
import ome.units.unit.Unit;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsPressureEnumHandler;
import omero.client;
import omero.model.Pressure;
import omero.model.enums.UnitsPressure;

public class PressureI
extends Pressure
implements ModelBased {
    private static final long serialVersionUID = 1L;
    private static final Map<UnitsPressure, Map<UnitsPressure, Conversion>> conversions;
    private static final Map<UnitsPressure, String> SYMBOLS;
    public static final ObjectFactory Factory;

    private static Map<UnitsPressure, Conversion> createMapATMOSPHERE() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 18)), Conversion.Sym("atm")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(4000L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(40L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Int(10132500L), Conversion.Sym("atm")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(20265L), Conversion.Int(2L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(400L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Int(1013250L), Conversion.Sym("atm")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 16))), Conversion.Sym("atm")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 15)), Conversion.Sym("atm")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 7))), Conversion.Sym("atm")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(4L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 6))), Conversion.Sym("atm")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(40L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 9))), Conversion.Sym("atm")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 4))), Conversion.Sym("atm")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 6)), Conversion.Sym("atm")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(4L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Int(101325000L), Conversion.Sym("atm")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Int(25L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(965L), Conversion.Pow(10L, 9)), Conversion.Int(1269737023L)), Conversion.Sym("atm")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 9)), Conversion.Sym("atm")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 13))), Conversion.Sym("atm")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 12)), Conversion.Sym("atm")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(120625L), Conversion.Pow(10L, 9)), Conversion.Int("8208044396629")), Conversion.Sym("atm")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Int(101325L), Conversion.Sym("atm")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 10))), Conversion.Sym("atm")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Int(760L), Conversion.Sym("atm")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 24)), Conversion.Sym("atm")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 22))), Conversion.Sym("atm")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 21)), Conversion.Sym("atm")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 19))), Conversion.Sym("atm")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapATTOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 18))), Conversion.Sym("attopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 19)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 22)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 36)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 26)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 29)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 18))), Conversion.Sym("attopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 9))), Conversion.Sym("attopa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 33)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 7))), Conversion.Sym("attopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 30)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 15))), Conversion.Sym("attopa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("attopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 42)), Conversion.Sym("attopa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("attopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 39)), Conversion.Sym("attopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapBAR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(4000L), Conversion.Int(4053L)), Conversion.Sym("bar")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("bar")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("bar")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("bar")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("bar")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("bar")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("bar")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("bar")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("bar")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("bar")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("bar")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("bar")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("bar")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("bar")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("bar")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("bar")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("bar")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("bar")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(3040L), Conversion.Int(4053L)), Conversion.Sym("bar")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 13)), Conversion.Int("26664477483")), Conversion.Sym("bar")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("bar")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("bar")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("bar")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 14)), Conversion.Int("172368932329209")), Conversion.Sym("bar")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("bar")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("bar")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 4)), Conversion.Int(4053L)), Conversion.Sym("bar")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 29), Conversion.Sym("bar")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 19)), Conversion.Sym("bar")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 26), Conversion.Sym("bar")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("bar")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapCENTIBAR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(40L), Conversion.Int(4053L)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("cbar")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("cbar")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("cbar")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("cbar")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("cbar")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("cbar")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Sym("cbar"));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("cbar")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("cbar")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("cbar")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(152L), Conversion.Int(20265L)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 11)), Conversion.Int("26664477483")), Conversion.Sym("cbar")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("cbar")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("cbar")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 12)), Conversion.Int("172368932329209")), Conversion.Sym("cbar")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("cbar")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(30400L), Conversion.Int(4053L)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("cbar")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("cbar")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("cbar")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("cbar")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapCENTIPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10132500L)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("centipa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("centipa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("centipa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("centipa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Int(253312500L)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 6)), Conversion.Int("26664477483")), Conversion.Sym("centipa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("centipa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("centipa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 7)), Conversion.Int("172368932329209")), Conversion.Sym("centipa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(38L), Conversion.Int(506625L)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 22), Conversion.Sym("centipa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 26)), Conversion.Sym("centipa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 19), Conversion.Sym("centipa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("centipa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapDECAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(2L), Conversion.Int(20265L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 19), Conversion.Sym("decapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("decapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("decapa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("decapa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("decapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("decapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(38L), Conversion.Int(506625L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 9)), Conversion.Int("26664477483")), Conversion.Sym("decapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("decapa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("decapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 10)), Conversion.Int("172368932329209")), Conversion.Sym("decapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("decapa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(304L), Conversion.Int(4053L)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 25), Conversion.Sym("decapa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("decapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 22), Conversion.Sym("decapa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("decapa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapDECIBAR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(400L), Conversion.Int(4053L)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 22), Conversion.Sym("dbar")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("dbar")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("dbar")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("dbar")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("dbar")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 19), Conversion.Sym("dbar")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("dbar")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("dbar")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("dbar")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("dbar")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("dbar")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(304L), Conversion.Int(4053L)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 12)), Conversion.Int("26664477483")), Conversion.Sym("dbar")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("dbar")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("dbar")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 13)), Conversion.Int("172368932329209")), Conversion.Sym("dbar")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("dbar")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(304000L), Conversion.Int(4053L)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 28), Conversion.Sym("dbar")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("dbar")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 25), Conversion.Sym("dbar")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("dbar")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapDECIPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1013250L)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("decipa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("decipa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 19)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("decipa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("decipa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("decipa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Int(25331250L)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 7)), Conversion.Int("26664477483")), Conversion.Sym("decipa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("decipa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("decipa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 8)), Conversion.Int("172368932329209")), Conversion.Sym("decipa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(76L), Conversion.Int(101325L)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("decipa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 25)), Conversion.Sym("decipa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("decipa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 22)), Conversion.Sym("decipa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapEXAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 16)), Conversion.Int(4053L)), Conversion.Sym("exapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 36), Conversion.Sym("exapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("exapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("exapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("exapa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("exapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("exapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 19), Conversion.Sym("exapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 33), Conversion.Sym("exapa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("exapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("exapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("exapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("exapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("exapa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("exapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("exapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("exapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("exapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 14)), Conversion.Int(4053L)), Conversion.Sym("exapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 26)), Conversion.Int("26664477483")), Conversion.Sym("exapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("exapa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("exapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 30), Conversion.Sym("exapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 27)), Conversion.Int("172368932329209")), Conversion.Sym("exapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("exapa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("exapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 17)), Conversion.Int(4053L)), Conversion.Sym("exapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 42), Conversion.Sym("exapa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("exapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 39), Conversion.Sym("exapa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("exapa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapFEMTOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 15))), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 19)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 33)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 26)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 15))), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 6))), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 30)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 4))), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 12))), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 39)), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("femtopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 36)), Conversion.Sym("femtopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapGIGAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 7)), Conversion.Int(4053L)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 5)), Conversion.Int(4053L)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 17)), Conversion.Int("26664477483")), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 18)), Conversion.Int("172368932329209")), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 8)), Conversion.Int(4053L)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 33), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 30), Conversion.Sym("gigapa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("gigapa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapHECTOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(4L), Conversion.Int(4053L)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Sym("hectopa"));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(76L), Conversion.Int(101325L)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 10)), Conversion.Int("26664477483")), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 11)), Conversion.Int("172368932329209")), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(3040L), Conversion.Int(4053L)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 26), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 22)), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("hectopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 19)), Conversion.Sym("hectopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapKILOBAR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 6)), Conversion.Int(4053L)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 26), Conversion.Sym("kbar")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("kbar")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("kbar")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("kbar")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("kbar")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("kbar")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("kbar")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("kbar")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("kbar")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("kbar")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("kbar")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("kbar")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("kbar")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("kbar")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 4)), Conversion.Int(4053L)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 16)), Conversion.Int("26664477483")), Conversion.Sym("kbar")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("kbar")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("kbar")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 17)), Conversion.Int("172368932329209")), Conversion.Sym("kbar")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("kbar")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 7)), Conversion.Int(4053L)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 32), Conversion.Sym("kbar")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("kbar")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 29), Conversion.Sym("kbar")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("kbar")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapKILOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(40L), Conversion.Int(4053L)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Sym("kilopa"));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(152L), Conversion.Int(20265L)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 11)), Conversion.Int("26664477483")), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 12)), Conversion.Int("172368932329209")), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(30400L), Conversion.Int(4053L)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("kilopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("kilopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapMEGABAR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 9)), Conversion.Int(4053L)), Conversion.Sym("megabar")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 29), Conversion.Sym("megabar")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("megabar")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("megabar")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("megabar")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("megabar")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("megabar")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("megabar")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("megabar")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 26), Conversion.Sym("megabar")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("megabar")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("megabar")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("megabar")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("megabar")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("megabar")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("megabar")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("megabar")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("megabar")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 7)), Conversion.Int(4053L)), Conversion.Sym("megabar")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 19)), Conversion.Int("26664477483")), Conversion.Sym("megabar")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("megabar")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("megabar")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("megabar")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 20)), Conversion.Int("172368932329209")), Conversion.Sym("megabar")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("megabar")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("megabar")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 10)), Conversion.Int(4053L)), Conversion.Sym("megabar")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 35), Conversion.Sym("megabar")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("megabar")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 32), Conversion.Sym("megabar")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("megabar")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapMEGAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 4)), Conversion.Int(4053L)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("megapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("megapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("megapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("megapa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("megapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("megapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("megapa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("megapa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("megapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("megapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("megapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("megapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("megapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(30400L), Conversion.Int(4053L)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 14)), Conversion.Int("26664477483")), Conversion.Sym("megapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("megapa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("megapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 15)), Conversion.Int("172368932329209")), Conversion.Sym("megapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("megapa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 5)), Conversion.Int(4053L)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 30), Conversion.Sym("megapa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("megapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("megapa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("megapa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapMICROPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 6))), Conversion.Sym("micropa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("micropa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("micropa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 6))), Conversion.Sym("micropa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int(200L), Conversion.Int("26664477483")), Conversion.Sym("micropa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("micropa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("micropa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int(25000L), Conversion.Int("172368932329209")), Conversion.Sym("micropa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Int("2533125000")), Conversion.Sym("micropa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("micropa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 30)), Conversion.Sym("micropa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("micropa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("micropa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapMILLIBAR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(4L), Conversion.Int(4053L)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("mbar")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("mbar")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("mbar")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("mbar")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("mbar")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Sym("mbar"));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("mbar")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 5), Conversion.Sym("mbar")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(76L), Conversion.Int(101325L)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 10)), Conversion.Int("26664477483")), Conversion.Sym("mbar")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("mbar")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("mbar")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 11)), Conversion.Int("172368932329209")), Conversion.Sym("mbar")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("mbar")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(3040L), Conversion.Int(4053L)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 26), Conversion.Sym("mbar")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 22)), Conversion.Sym("mbar")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("mbar")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 19)), Conversion.Sym("mbar")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapMILLIPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(101325000L)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("millipa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("millipa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("millipa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Int("2533125000")), Conversion.Sym("millipa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 5)), Conversion.Int("26664477483")), Conversion.Sym("millipa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("millipa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("millipa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 6)), Conversion.Int("172368932329209")), Conversion.Sym("millipa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Int(2533125L)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("millipa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("millipa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("millipa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("millipa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapMILLITORR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(25L), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 18)), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(3040L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(20265L), Conversion.Int(152L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(253312500L), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(506625L), Conversion.Int(38L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(304L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(25331250L), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 14))), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 15)), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 5))), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(101325L), Conversion.Int(76L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 4))), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(20265L), Conversion.Int(152L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 7))), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(30400L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 6)), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(101325L), Conversion.Int(76L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("2533125000"), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(24125L), Conversion.Pow(10L, 9)), Conversion.Int("24125003437")), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 9)), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 11))), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 12)), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(3015625L), Conversion.Pow(10L, 9)), Conversion.Int("155952843535951")), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(2533125L), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 8))), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 24)), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 20))), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 21)), Conversion.Int(19L)), Conversion.Sym("mtorr")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 17))), Conversion.Sym("mtorr")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapMMHG() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1269737023L), Conversion.Mul(Conversion.Int(965L), Conversion.Pow(10L, 9))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 9)), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 13))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 11))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 6))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 9))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 12))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 7))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 26))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 6)), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 17))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 10))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 16))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 11))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 19))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 14))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Int(200L)), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 10))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 5))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int("24125003437"), Conversion.Mul(Conversion.Int(24125L), Conversion.Pow(10L, 9))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Int("133322387415"), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 23))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Int("133322387415000"), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int("158717127875"), Conversion.Int("8208044396629")), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 8))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 20))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int("24125003437"), Conversion.Mul(Conversion.Int(24125L), Conversion.Pow(10L, 6))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 15)), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 32))), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 12)), Conversion.Sym("mmhg")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("26664477483"), Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 29))), Conversion.Sym("mmhg")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapNANOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 9))), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 7)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 9))), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int("133322387415")), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int(25L), Conversion.Int("172368932329209")), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 6))), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 33)), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("nanopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 30)), Conversion.Sym("nanopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapPETAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 13)), Conversion.Int(4053L)), Conversion.Sym("petapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 33), Conversion.Sym("petapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("petapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("petapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("petapa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("petapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("petapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("petapa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("petapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 30), Conversion.Sym("petapa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("petapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("petapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("petapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("petapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("petapa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("petapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("petapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("petapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("petapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 11)), Conversion.Int(4053L)), Conversion.Sym("petapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 23)), Conversion.Int("26664477483")), Conversion.Sym("petapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("petapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("petapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 24)), Conversion.Int("172368932329209")), Conversion.Sym("petapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("petapa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("petapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 14)), Conversion.Int(4053L)), Conversion.Sym("petapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 39), Conversion.Sym("petapa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("petapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 36), Conversion.Sym("petapa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("petapa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapPICOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 12))), Conversion.Sym("picopa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("picopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 17)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 10)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 13)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 16)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 30)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("picopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 14)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 12))), Conversion.Sym("picopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int("133322387415000")), Conversion.Sym("picopa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int("6894757293168360")), Conversion.Sym("picopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 9))), Conversion.Sym("picopa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("picopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 36)), Conversion.Sym("picopa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("picopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 33)), Conversion.Sym("picopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapPSI() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int("8208044396629"), Conversion.Mul(Conversion.Int(120625L), Conversion.Pow(10L, 9))), Conversion.Sym("psi")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 7)), Conversion.Sym("psi")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 14))), Conversion.Sym("psi")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 12))), Conversion.Sym("psi")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 7))), Conversion.Sym("psi")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 10))), Conversion.Sym("psi")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 13))), Conversion.Sym("psi")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 8))), Conversion.Sym("psi")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 27))), Conversion.Sym("psi")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 4)), Conversion.Sym("psi")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 18))), Conversion.Sym("psi")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 11))), Conversion.Sym("psi")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 17))), Conversion.Sym("psi")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 12))), Conversion.Sym("psi")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 20))), Conversion.Sym("psi")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 15))), Conversion.Sym("psi")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Int(25000L)), Conversion.Sym("psi")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 11))), Conversion.Sym("psi")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 6))), Conversion.Sym("psi")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int("155952843535951"), Conversion.Mul(Conversion.Int(3015625L), Conversion.Pow(10L, 9))), Conversion.Sym("psi")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int("8208044396629"), Conversion.Int("158717127875")), Conversion.Sym("psi")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Int(25L)), Conversion.Sym("psi")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 24))), Conversion.Sym("psi")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Int("6894757293168360"), Conversion.Sym("psi")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 9))), Conversion.Sym("psi")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 21))), Conversion.Sym("psi")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int("155952843535951"), Conversion.Mul(Conversion.Int(3015625L), Conversion.Pow(10L, 6))), Conversion.Sym("psi")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 13)), Conversion.Sym("psi")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 33))), Conversion.Sym("psi")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 10)), Conversion.Sym("psi")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("172368932329209"), Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 30))), Conversion.Sym("psi")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(101325L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("pa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 5)), Conversion.Sym("pa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Int(100L), Conversion.Sym("pa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(10L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 4)), Conversion.Sym("pa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("pa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("pa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("pa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("pa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 8)), Conversion.Sym("pa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 11)), Conversion.Sym("pa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("pa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("pa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(100L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("pa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Int(2533125L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 8)), Conversion.Int("26664477483")), Conversion.Sym("pa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("pa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("pa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("pa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 9)), Conversion.Int("172368932329209")), Conversion.Sym("pa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("pa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(152L), Conversion.Int(20265L)), Conversion.Sym("pa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("pa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("pa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("pa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("pa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapTERAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 10)), Conversion.Int(4053L)), Conversion.Sym("terapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 30), Conversion.Sym("terapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Pow(10L, 7), Conversion.Sym("terapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("terapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 14), Conversion.Sym("terapa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 11), Conversion.Sym("terapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 8), Conversion.Sym("terapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("terapa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("terapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("terapa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("terapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("terapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Pow(10L, 4), Conversion.Sym("terapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("terapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Int(10L), Conversion.Sym("terapa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("terapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("terapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("terapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("terapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 8)), Conversion.Int(4053L)), Conversion.Sym("terapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 20)), Conversion.Int("26664477483")), Conversion.Sym("terapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("terapa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("terapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("terapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 21)), Conversion.Int("172368932329209")), Conversion.Sym("terapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("terapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 11)), Conversion.Int(4053L)), Conversion.Sym("terapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 36), Conversion.Sym("terapa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("terapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 33), Conversion.Sym("terapa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("terapa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapTORR() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(760L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 15)), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 4))), Conversion.Sym("torr")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(30400L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(506625L), Conversion.Int(38L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(304L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(304000L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(101325L), Conversion.Int(76L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 17))), Conversion.Sym("torr")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 12)), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 8))), Conversion.Sym("torr")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(3040L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 7))), Conversion.Sym("torr")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(30400L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 10))), Conversion.Sym("torr")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 5))), Conversion.Sym("torr")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int("2533125000"), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Int(3040L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(2533125L), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(24125L), Conversion.Pow(10L, 6)), Conversion.Int("24125003437")), Conversion.Sym("torr")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 6)), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 14))), Conversion.Sym("torr")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 9)), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(3015625L), Conversion.Pow(10L, 6)), Conversion.Int("155952843535951")), Conversion.Sym("torr")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(20265L), Conversion.Int(152L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 11))), Conversion.Sym("torr")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 21)), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 23))), Conversion.Sym("torr")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 18)), Conversion.Int(19L)), Conversion.Sym("torr")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(4053L), Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 20))), Conversion.Sym("torr")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapYOCTOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 24))), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 29)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 22)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 25)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 28)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 42)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 33)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 26)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 32)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 35)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 30)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 26)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 24))), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 15))), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 39)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 13))), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 36)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 21))), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 48)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("yoctopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 45)), Conversion.Sym("yoctopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapYOTTAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 22)), Conversion.Int(4053L)), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 42), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Pow(10L, 19), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 26), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 25), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 39), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 22), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 30), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 22), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 20)), Conversion.Int(4053L)), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 32)), Conversion.Int("26664477483")), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 33), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 36), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 33)), Conversion.Int("172368932329209")), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 23)), Conversion.Int(4053L)), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 48), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 45), Conversion.Sym("yottapa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("yottapa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapZEPTOPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int(101325L), Conversion.Pow(10L, 21))), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 26)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 19)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 22)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 25)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 20)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 39)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 6)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 30)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 29)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 24)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 32)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 27)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 15)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 23)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 18)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 21))), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("133322387415"), Conversion.Pow(10L, 12))), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 12)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 36)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 9)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Mul(Conversion.Int("689475729316836"), Conversion.Pow(10L, 10))), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 21)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 33)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Int(19L), Conversion.Mul(Conversion.Int(2533125L), Conversion.Pow(10L, 18))), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 45)), Conversion.Sym("zeptopa")));
        c.put(UnitsPressure.ZETTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Pow(10L, 42)), Conversion.Sym("zeptopa")));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsPressure, Conversion> createMapZETTAPASCAL() {
        EnumMap<UnitsPressure, Conversion> c = new EnumMap<UnitsPressure, Conversion>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(4L), Conversion.Pow(10L, 19)), Conversion.Int(4053L)), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.ATTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 39), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.BAR, Conversion.Mul(Conversion.Pow(10L, 16), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.CENTIBAR, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.CENTIPASCAL, Conversion.Mul(Conversion.Pow(10L, 23), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.DECAPASCAL, Conversion.Mul(Conversion.Pow(10L, 20), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.DECIBAR, Conversion.Mul(Conversion.Pow(10L, 17), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.DECIPASCAL, Conversion.Mul(Conversion.Pow(10L, 22), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.EXAPASCAL, Conversion.Mul(Conversion.Int(1000L), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.FEMTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 36), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.GIGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 12), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.HECTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 19), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.KILOBAR, Conversion.Mul(Conversion.Pow(10L, 13), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.KILOPASCAL, Conversion.Mul(Conversion.Pow(10L, 18), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.MEGABAR, Conversion.Mul(Conversion.Pow(10L, 10), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.MEGAPASCAL, Conversion.Mul(Conversion.Pow(10L, 15), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.MICROPASCAL, Conversion.Mul(Conversion.Pow(10L, 27), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.MILLIBAR, Conversion.Mul(Conversion.Pow(10L, 19), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.MILLIPASCAL, Conversion.Mul(Conversion.Pow(10L, 24), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.MILLITORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 17)), Conversion.Int(4053L)), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.MMHG, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(2L), Conversion.Pow(10L, 29)), Conversion.Int("26664477483")), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.NANOPASCAL, Conversion.Mul(Conversion.Pow(10L, 30), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.PETAPASCAL, Conversion.Mul(Conversion.Pow(10L, 6), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.PICOPASCAL, Conversion.Mul(Conversion.Pow(10L, 33), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.PSI, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(25L), Conversion.Pow(10L, 30)), Conversion.Int("172368932329209")), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.PASCAL, Conversion.Mul(Conversion.Pow(10L, 21), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.TERAPASCAL, Conversion.Mul(Conversion.Pow(10L, 9), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.TORR, Conversion.Mul(Conversion.Rat(Conversion.Mul(Conversion.Int(304L), Conversion.Pow(10L, 20)), Conversion.Int(4053L)), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.YOCTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 45), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.YOTTAPASCAL, Conversion.Mul(Conversion.Rat(Conversion.Int(1L), Conversion.Int(1000L)), Conversion.Sym("zettapa")));
        c.put(UnitsPressure.ZEPTOPASCAL, Conversion.Mul(Conversion.Pow(10L, 42), Conversion.Sym("zettapa")));
        return Collections.unmodifiableMap(c);
    }

    public static String lookupSymbol(UnitsPressure unit) {
        return SYMBOLS.get(unit);
    }

    public static final ObjectFactory makeFactory(client client2) {
        return new ObjectFactory(){

            @Override
            public Ice.Object create(String arg0) {
                return new PressureI();
            }

            @Override
            public void destroy() {
            }
        };
    }

    public static ome.xml.model.enums.UnitsPressure makeXMLUnit(String unit) {
        try {
            return ome.xml.model.enums.UnitsPressure.fromString(unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Pressure unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Pressure makeXMLQuantity(double d, String unit) {
        Unit<ome.units.quantity.Pressure> units = UnitsPressureEnumHandler.getBaseUnit(PressureI.makeXMLUnit(unit));
        return new ome.units.quantity.Pressure(d, units);
    }

    public static ome.units.quantity.Pressure convert(Pressure t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = ome.model.enums.UnitsPressure.valueOf(t.getUnit().toString()).getSymbol();
        ome.xml.model.enums.UnitsPressure units = PressureI.makeXMLUnit(u);
        Unit<ome.units.quantity.Pressure> units2 = UnitsPressureEnumHandler.getBaseUnit(units);
        return new ome.units.quantity.Pressure(v, units2);
    }

    public PressureI() {
    }

    public PressureI(double d, UnitsPressure unit) {
        this.setUnit(unit);
        this.setValue(d);
    }

    public PressureI(double d, Unit<ome.units.quantity.Pressure> unit) {
        this(d, ome.model.enums.UnitsPressure.bySymbol(unit.getSymbol()));
    }

    public PressureI(Pressure value, Unit<ome.units.quantity.Pressure> ul) throws BigResult {
        this(value, ome.model.enums.UnitsPressure.bySymbol(ul.getSymbol()).toString());
    }

    public PressureI(double d, ome.model.enums.UnitsPressure ul) {
        this(d, UnitsPressure.valueOf(ul.toString()));
    }

    public PressureI(Pressure value, String target) throws BigResult {
        String source = value.getUnit().toString();
        if (target.equals(source)) {
            this.setValue(value.getValue());
            this.setUnit(value.getUnit());
        } else {
            UnitsPressure targetUnit = UnitsPressure.valueOf(target);
            Conversion conversion = conversions.get(value.getUnit()).get(targetUnit);
            if (conversion == null) {
                throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit(), target));
            }
            double orig = value.getValue();
            BigDecimal big = conversion.convert(orig);
            double converted = big.doubleValue();
            if (Double.isInfinite(converted)) {
                throw new BigResult(big, "Failed to convert " + source + ":" + target);
            }
            this.setValue(converted);
            this.setUnit(targetUnit);
        }
    }

    public PressureI(Pressure value, UnitsPressure target) throws BigResult {
        this(value, target.toString());
    }

    public PressureI(ome.units.quantity.Pressure value) {
        ome.model.enums.UnitsPressure internal = ome.model.enums.UnitsPressure.bySymbol(value.unit().getSymbol());
        UnitsPressure ul = UnitsPressure.valueOf(internal.toString());
        this.setValue(value.value().doubleValue());
        this.setUnit(ul);
    }

    @Override
    public double getValue(Current current) {
        return this.value;
    }

    @Override
    public void setValue(double value, Current current) {
        this.value = value;
    }

    @Override
    public UnitsPressure getUnit(Current current) {
        return this.unit;
    }

    @Override
    public void setUnit(UnitsPressure unit, Current current) {
        this.unit = unit;
    }

    @Override
    public String getSymbol(Current current) {
        return SYMBOLS.get(this.unit);
    }

    @Override
    public Pressure copy(Current ignore) {
        PressureI copy = new PressureI();
        copy.setValue(this.getValue());
        copy.setUnit(this.getUnit());
        return copy;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper mapper) {
        if (!(model instanceof ome.model.units.Pressure)) {
            throw new IllegalArgumentException("Pressure cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
        ome.model.units.Pressure t = (ome.model.units.Pressure)model;
        this.value = t.getValue();
        this.unit = UnitsPressure.valueOf(t.getUnit().toString());
    }

    @Override
    public Filterable fillObject(ReverseModelMapper mapper) {
        ome.model.enums.UnitsPressure ut = ome.model.enums.UnitsPressure.valueOf(this.getUnit().toString());
        ome.model.units.Pressure t = new ome.model.units.Pressure(this.getValue(), ut);
        return t;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Pressure(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pressure other = (Pressure)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    static {
        EnumMap<UnitsPressure, Map<UnitsPressure, Conversion>> c = new EnumMap<UnitsPressure, Map<UnitsPressure, Conversion>>(UnitsPressure.class);
        c.put(UnitsPressure.ATMOSPHERE, PressureI.createMapATMOSPHERE());
        c.put(UnitsPressure.ATTOPASCAL, PressureI.createMapATTOPASCAL());
        c.put(UnitsPressure.BAR, PressureI.createMapBAR());
        c.put(UnitsPressure.CENTIBAR, PressureI.createMapCENTIBAR());
        c.put(UnitsPressure.CENTIPASCAL, PressureI.createMapCENTIPASCAL());
        c.put(UnitsPressure.DECAPASCAL, PressureI.createMapDECAPASCAL());
        c.put(UnitsPressure.DECIBAR, PressureI.createMapDECIBAR());
        c.put(UnitsPressure.DECIPASCAL, PressureI.createMapDECIPASCAL());
        c.put(UnitsPressure.EXAPASCAL, PressureI.createMapEXAPASCAL());
        c.put(UnitsPressure.FEMTOPASCAL, PressureI.createMapFEMTOPASCAL());
        c.put(UnitsPressure.GIGAPASCAL, PressureI.createMapGIGAPASCAL());
        c.put(UnitsPressure.HECTOPASCAL, PressureI.createMapHECTOPASCAL());
        c.put(UnitsPressure.KILOBAR, PressureI.createMapKILOBAR());
        c.put(UnitsPressure.KILOPASCAL, PressureI.createMapKILOPASCAL());
        c.put(UnitsPressure.MEGABAR, PressureI.createMapMEGABAR());
        c.put(UnitsPressure.MEGAPASCAL, PressureI.createMapMEGAPASCAL());
        c.put(UnitsPressure.MICROPASCAL, PressureI.createMapMICROPASCAL());
        c.put(UnitsPressure.MILLIBAR, PressureI.createMapMILLIBAR());
        c.put(UnitsPressure.MILLIPASCAL, PressureI.createMapMILLIPASCAL());
        c.put(UnitsPressure.MILLITORR, PressureI.createMapMILLITORR());
        c.put(UnitsPressure.MMHG, PressureI.createMapMMHG());
        c.put(UnitsPressure.NANOPASCAL, PressureI.createMapNANOPASCAL());
        c.put(UnitsPressure.PETAPASCAL, PressureI.createMapPETAPASCAL());
        c.put(UnitsPressure.PICOPASCAL, PressureI.createMapPICOPASCAL());
        c.put(UnitsPressure.PSI, PressureI.createMapPSI());
        c.put(UnitsPressure.PASCAL, PressureI.createMapPASCAL());
        c.put(UnitsPressure.TERAPASCAL, PressureI.createMapTERAPASCAL());
        c.put(UnitsPressure.TORR, PressureI.createMapTORR());
        c.put(UnitsPressure.YOCTOPASCAL, PressureI.createMapYOCTOPASCAL());
        c.put(UnitsPressure.YOTTAPASCAL, PressureI.createMapYOTTAPASCAL());
        c.put(UnitsPressure.ZEPTOPASCAL, PressureI.createMapZEPTOPASCAL());
        c.put(UnitsPressure.ZETTAPASCAL, PressureI.createMapZETTAPASCAL());
        conversions = Collections.unmodifiableMap(c);
        HashMap<UnitsPressure, String> s = new HashMap<UnitsPressure, String>();
        s.put(UnitsPressure.ATMOSPHERE, "atm");
        s.put(UnitsPressure.ATTOPASCAL, "aPa");
        s.put(UnitsPressure.BAR, "bar");
        s.put(UnitsPressure.CENTIBAR, "cbar");
        s.put(UnitsPressure.CENTIPASCAL, "cPa");
        s.put(UnitsPressure.DECAPASCAL, "daPa");
        s.put(UnitsPressure.DECIBAR, "dbar");
        s.put(UnitsPressure.DECIPASCAL, "dPa");
        s.put(UnitsPressure.EXAPASCAL, "EPa");
        s.put(UnitsPressure.FEMTOPASCAL, "fPa");
        s.put(UnitsPressure.GIGAPASCAL, "GPa");
        s.put(UnitsPressure.HECTOPASCAL, "hPa");
        s.put(UnitsPressure.KILOBAR, "kbar");
        s.put(UnitsPressure.KILOPASCAL, "kPa");
        s.put(UnitsPressure.MEGABAR, "Mbar");
        s.put(UnitsPressure.MEGAPASCAL, "MPa");
        s.put(UnitsPressure.MICROPASCAL, "\u00b5Pa");
        s.put(UnitsPressure.MILLIBAR, "mbar");
        s.put(UnitsPressure.MILLIPASCAL, "mPa");
        s.put(UnitsPressure.MILLITORR, "mTorr");
        s.put(UnitsPressure.MMHG, "mm Hg");
        s.put(UnitsPressure.NANOPASCAL, "nPa");
        s.put(UnitsPressure.PETAPASCAL, "PPa");
        s.put(UnitsPressure.PICOPASCAL, "pPa");
        s.put(UnitsPressure.PSI, "psi");
        s.put(UnitsPressure.PASCAL, "Pa");
        s.put(UnitsPressure.TERAPASCAL, "TPa");
        s.put(UnitsPressure.TORR, "Torr");
        s.put(UnitsPressure.YOCTOPASCAL, "yPa");
        s.put(UnitsPressure.YOTTAPASCAL, "YPa");
        s.put(UnitsPressure.ZEPTOPASCAL, "zPa");
        s.put(UnitsPressure.ZETTAPASCAL, "ZPa");
        SYMBOLS = s;
        Factory = PressureI.makeFactory(null);
    }
}

