/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Channel;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.DimensionOrder;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Length;
import omero.model.OriginalFile;
import omero.model.Pixels;
import omero.model.PixelsOriginalFileMap;
import omero.model.PixelsOriginalFileMapI;
import omero.model.PixelsType;
import omero.model.PlaneInfo;
import omero.model.RenderingDef;
import omero.model.Thumbnail;
import omero.model.Time;
import omero.rtypes;
import omero.util.IceMapper;

public class PixelsI
extends Pixels
implements ModelBased {
    public static final String IMAGE = "ome.model.core.Pixels_image";
    public static final String RELATEDTO = "ome.model.core.Pixels_relatedTo";
    public static final String PIXELSTYPE = "ome.model.core.Pixels_pixelsType";
    public static final String SIGNIFICANTBITS = "ome.model.core.Pixels_significantBits";
    public static final String SIZEX = "ome.model.core.Pixels_sizeX";
    public static final String SIZEY = "ome.model.core.Pixels_sizeY";
    public static final String SIZEZ = "ome.model.core.Pixels_sizeZ";
    public static final String SIZEC = "ome.model.core.Pixels_sizeC";
    public static final String SIZET = "ome.model.core.Pixels_sizeT";
    public static final String SHA1 = "ome.model.core.Pixels_sha1";
    public static final String DIMENSIONORDER = "ome.model.core.Pixels_dimensionOrder";
    public static final String PHYSICALSIZEX = "ome.model.core.Pixels_physicalSizeX";
    public static final String PHYSICALSIZEY = "ome.model.core.Pixels_physicalSizeY";
    public static final String PHYSICALSIZEZ = "ome.model.core.Pixels_physicalSizeZ";
    public static final String WAVESTART = "ome.model.core.Pixels_waveStart";
    public static final String WAVEINCREMENT = "ome.model.core.Pixels_waveIncrement";
    public static final String TIMEINCREMENT = "ome.model.core.Pixels_timeIncrement";
    public static final String METHODOLOGY = "ome.model.core.Pixels_methodology";
    public static final String PLANEINFO = "ome.model.core.Pixels_planeInfo";
    public static final String PIXELSFILEMAPS = "ome.model.core.Pixels_pixelsFileMaps";
    public static final String CHANNELS = "ome.model.core.Pixels_channels";
    public static final String SETTINGS = "ome.model.core.Pixels_settings";
    public static final String THUMBNAILS = "ome.model.core.Pixels_thumbnails";
    public static final String DETAILS = "ome.model.core.Pixels_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.planeInfoSeq = new ArrayList();
            this.planeInfoLoaded = true;
        } else {
            this.planeInfoSeq = null;
            this.planeInfoLoaded = false;
        }
        if (load) {
            this.pixelsFileMapsSeq = new ArrayList();
            this.pixelsFileMapsLoaded = true;
        } else {
            this.pixelsFileMapsSeq = null;
            this.pixelsFileMapsLoaded = false;
        }
        if (load) {
            this.channelsSeq = new ArrayList();
            this.channelsLoaded = true;
        } else {
            this.channelsSeq = null;
            this.channelsLoaded = false;
        }
        if (load) {
            this.settingsSeq = new ArrayList();
            this.settingsLoaded = true;
        } else {
            this.settingsSeq = null;
            this.settingsLoaded = false;
        }
        if (load) {
            this.thumbnailsSeq = new ArrayList();
            this.thumbnailsLoaded = true;
        } else {
            this.thumbnailsSeq = null;
            this.thumbnailsLoaded = false;
        }
    }

    public PixelsI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public PixelsI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public PixelsI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadImage();
        this.unloadRelatedTo();
        this.unloadPixelsType();
        this.unloadSignificantBits();
        this.unloadSizeX();
        this.unloadSizeY();
        this.unloadSizeZ();
        this.unloadSizeC();
        this.unloadSizeT();
        this.unloadSha1();
        this.unloadDimensionOrder();
        this.unloadPhysicalSizeX();
        this.unloadPhysicalSizeY();
        this.unloadPhysicalSizeZ();
        this.unloadWaveStart();
        this.unloadWaveIncrement();
        this.unloadTimeIncrement();
        this.unloadMethodology();
        this.unloadPlaneInfo();
        this.unloadPixelsFileMaps();
        this.unloadChannels();
        this.unloadSettings();
        this.unloadThumbnails();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        PixelsI copy = new PixelsI();
        copy.id = this.id;
        copy.version = this.version;
        copy.image = this.image == null ? null : (Image)this.image.proxy();
        copy.relatedTo = this.relatedTo == null ? null : (Pixels)this.relatedTo.proxy();
        copy.pixelsType = this.pixelsType == null ? null : (PixelsType)this.pixelsType.proxy();
        copy.significantBits = this.significantBits;
        copy.sizeX = this.sizeX;
        copy.sizeY = this.sizeY;
        copy.sizeZ = this.sizeZ;
        copy.sizeC = this.sizeC;
        copy.sizeT = this.sizeT;
        copy.sha1 = this.sha1;
        copy.dimensionOrder = this.dimensionOrder == null ? null : (DimensionOrder)this.dimensionOrder.proxy();
        copy.physicalSizeX = this.physicalSizeX == null ? null : this.physicalSizeX.copy();
        copy.physicalSizeY = this.physicalSizeY == null ? null : this.physicalSizeY.copy();
        copy.physicalSizeZ = this.physicalSizeZ == null ? null : this.physicalSizeZ.copy();
        copy.waveStart = this.waveStart;
        copy.waveIncrement = this.waveIncrement;
        copy.timeIncrement = this.timeIncrement == null ? null : this.timeIncrement.copy();
        copy.methodology = this.methodology;
        if (!this.planeInfoLoaded) {
            copy.planeInfoLoaded = false;
            copy.planeInfoSeq = null;
        } else {
            copy.planeInfoLoaded = true;
            copy.planeInfoSeq = new ArrayList<PlaneInfo>();
            for (IObject item : this.planeInfoSeq) {
                copy.planeInfoSeq.add(item == null ? null : (PlaneInfo)item.proxy());
            }
        }
        if (!this.pixelsFileMapsLoaded) {
            copy.pixelsFileMapsLoaded = false;
            copy.pixelsFileMapsSeq = null;
        } else {
            copy.pixelsFileMapsLoaded = true;
            copy.pixelsFileMapsSeq = new ArrayList<PixelsOriginalFileMap>();
            for (IObject item : this.pixelsFileMapsSeq) {
                copy.pixelsFileMapsSeq.add(item == null ? null : (PixelsOriginalFileMap)item.proxy());
            }
        }
        if (!this.channelsLoaded) {
            copy.channelsLoaded = false;
            copy.channelsSeq = null;
        } else {
            copy.channelsLoaded = true;
            copy.channelsSeq = new ArrayList<Channel>();
            for (IObject item : this.channelsSeq) {
                copy.channelsSeq.add(item == null ? null : (Channel)item.proxy());
            }
        }
        if (!this.settingsLoaded) {
            copy.settingsLoaded = false;
            copy.settingsSeq = null;
        } else {
            copy.settingsLoaded = true;
            copy.settingsSeq = new ArrayList<RenderingDef>();
            for (IObject item : this.settingsSeq) {
                copy.settingsSeq.add(item == null ? null : (RenderingDef)item.proxy());
            }
        }
        if (!this.thumbnailsLoaded) {
            copy.thumbnailsLoaded = false;
            copy.thumbnailsSeq = null;
        } else {
            copy.thumbnailsLoaded = true;
            copy.thumbnailsSeq = new ArrayList<Thumbnail>();
            for (IObject item : this.thumbnailsSeq) {
                copy.thumbnailsSeq.add(item == null ? null : (Thumbnail)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new PixelsI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadImage() {
        this.image = null;
    }

    @Override
    public Image getImage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.image;
    }

    @Override
    public void setImage(Image image, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.image = image;
    }

    private void copyImage(ome.model.core.Pixels source, IceMapper mapper) {
        this.image = (Image)mapper.findTarget(source.getImage());
    }

    private void fillImage(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(IMAGE, mapper.reverse((ModelBased)((Object)this.getImage())));
    }

    public void unloadRelatedTo() {
        this.relatedTo = null;
    }

    @Override
    public Pixels getRelatedTo(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.relatedTo;
    }

    @Override
    public void setRelatedTo(Pixels relatedTo, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.relatedTo = relatedTo;
    }

    private void copyRelatedTo(ome.model.core.Pixels source, IceMapper mapper) {
        this.relatedTo = (Pixels)mapper.findTarget(source.getRelatedTo());
    }

    private void fillRelatedTo(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(RELATEDTO, mapper.reverse((ModelBased)((Object)this.getRelatedTo())));
    }

    public void unloadPixelsType() {
        this.pixelsType = null;
    }

    @Override
    public PixelsType getPixelsType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pixelsType;
    }

    @Override
    public void setPixelsType(PixelsType pixelsType, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pixelsType = pixelsType;
    }

    private void copyPixelsType(ome.model.core.Pixels source, IceMapper mapper) {
        this.pixelsType = (PixelsType)mapper.findTarget(source.getPixelsType());
    }

    private void fillPixelsType(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(PIXELSTYPE, mapper.reverse((ModelBased)((Object)this.getPixelsType())));
    }

    public void unloadSignificantBits() {
        this.significantBits = null;
    }

    @Override
    public RInt getSignificantBits(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.significantBits;
    }

    @Override
    public void setSignificantBits(RInt significantBits, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.significantBits = significantBits;
    }

    private void copySignificantBits(ome.model.core.Pixels source, IceMapper mapper) {
        this.significantBits = source.getSignificantBits() == null ? null : rtypes.rint(source.getSignificantBits());
    }

    private void fillSignificantBits(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setSignificantBits((Integer)mapper.fromRType(this.getSignificantBits()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeX() {
        this.sizeX = null;
    }

    @Override
    public RInt getSizeX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeX;
    }

    @Override
    public void setSizeX(RInt sizeX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeX = sizeX;
    }

    private void copySizeX(ome.model.core.Pixels source, IceMapper mapper) {
        this.sizeX = source.getSizeX() == null ? null : rtypes.rint(source.getSizeX());
    }

    private void fillSizeX(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setSizeX((Integer)mapper.fromRType(this.getSizeX()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeY() {
        this.sizeY = null;
    }

    @Override
    public RInt getSizeY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeY;
    }

    @Override
    public void setSizeY(RInt sizeY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeY = sizeY;
    }

    private void copySizeY(ome.model.core.Pixels source, IceMapper mapper) {
        this.sizeY = source.getSizeY() == null ? null : rtypes.rint(source.getSizeY());
    }

    private void fillSizeY(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setSizeY((Integer)mapper.fromRType(this.getSizeY()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeZ() {
        this.sizeZ = null;
    }

    @Override
    public RInt getSizeZ(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeZ;
    }

    @Override
    public void setSizeZ(RInt sizeZ, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeZ = sizeZ;
    }

    private void copySizeZ(ome.model.core.Pixels source, IceMapper mapper) {
        this.sizeZ = source.getSizeZ() == null ? null : rtypes.rint(source.getSizeZ());
    }

    private void fillSizeZ(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setSizeZ((Integer)mapper.fromRType(this.getSizeZ()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeC() {
        this.sizeC = null;
    }

    @Override
    public RInt getSizeC(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeC;
    }

    @Override
    public void setSizeC(RInt sizeC, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeC = sizeC;
    }

    private void copySizeC(ome.model.core.Pixels source, IceMapper mapper) {
        this.sizeC = source.getSizeC() == null ? null : rtypes.rint(source.getSizeC());
    }

    private void fillSizeC(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setSizeC((Integer)mapper.fromRType(this.getSizeC()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSizeT() {
        this.sizeT = null;
    }

    @Override
    public RInt getSizeT(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sizeT;
    }

    @Override
    public void setSizeT(RInt sizeT, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sizeT = sizeT;
    }

    private void copySizeT(ome.model.core.Pixels source, IceMapper mapper) {
        this.sizeT = source.getSizeT() == null ? null : rtypes.rint(source.getSizeT());
    }

    private void fillSizeT(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setSizeT((Integer)mapper.fromRType(this.getSizeT()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSha1() {
        this.sha1 = null;
    }

    @Override
    public RString getSha1(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.sha1;
    }

    @Override
    public void setSha1(RString sha1, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.sha1 = sha1;
    }

    private void copySha1(ome.model.core.Pixels source, IceMapper mapper) {
        this.sha1 = source.getSha1() == null ? null : rtypes.rstring(source.getSha1());
    }

    private void fillSha1(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setSha1((String)mapper.fromRType(this.getSha1()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDimensionOrder() {
        this.dimensionOrder = null;
    }

    @Override
    public DimensionOrder getDimensionOrder(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.dimensionOrder;
    }

    @Override
    public void setDimensionOrder(DimensionOrder dimensionOrder, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.dimensionOrder = dimensionOrder;
    }

    private void copyDimensionOrder(ome.model.core.Pixels source, IceMapper mapper) {
        this.dimensionOrder = (DimensionOrder)mapper.findTarget(source.getDimensionOrder());
    }

    private void fillDimensionOrder(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(DIMENSIONORDER, mapper.reverse((ModelBased)((Object)this.getDimensionOrder())));
    }

    public void unloadPhysicalSizeX() {
        this.physicalSizeX = null;
    }

    @Override
    public Length getPhysicalSizeX(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.physicalSizeX;
    }

    @Override
    public void setPhysicalSizeX(Length physicalSizeX, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.physicalSizeX = physicalSizeX;
    }

    private void copyPhysicalSizeX(ome.model.core.Pixels source, IceMapper mapper) {
        this.physicalSizeX = (Length)mapper.findTarget(source.getPhysicalSizeX());
    }

    private void fillPhysicalSizeX(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(PHYSICALSIZEX, mapper.reverse((ModelBased)((Object)this.getPhysicalSizeX())));
    }

    public void unloadPhysicalSizeY() {
        this.physicalSizeY = null;
    }

    @Override
    public Length getPhysicalSizeY(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.physicalSizeY;
    }

    @Override
    public void setPhysicalSizeY(Length physicalSizeY, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.physicalSizeY = physicalSizeY;
    }

    private void copyPhysicalSizeY(ome.model.core.Pixels source, IceMapper mapper) {
        this.physicalSizeY = (Length)mapper.findTarget(source.getPhysicalSizeY());
    }

    private void fillPhysicalSizeY(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(PHYSICALSIZEY, mapper.reverse((ModelBased)((Object)this.getPhysicalSizeY())));
    }

    public void unloadPhysicalSizeZ() {
        this.physicalSizeZ = null;
    }

    @Override
    public Length getPhysicalSizeZ(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.physicalSizeZ;
    }

    @Override
    public void setPhysicalSizeZ(Length physicalSizeZ, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.physicalSizeZ = physicalSizeZ;
    }

    private void copyPhysicalSizeZ(ome.model.core.Pixels source, IceMapper mapper) {
        this.physicalSizeZ = (Length)mapper.findTarget(source.getPhysicalSizeZ());
    }

    private void fillPhysicalSizeZ(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(PHYSICALSIZEZ, mapper.reverse((ModelBased)((Object)this.getPhysicalSizeZ())));
    }

    public void unloadWaveStart() {
        this.waveStart = null;
    }

    @Override
    public RInt getWaveStart(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.waveStart;
    }

    @Override
    public void setWaveStart(RInt waveStart, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.waveStart = waveStart;
    }

    private void copyWaveStart(ome.model.core.Pixels source, IceMapper mapper) {
        this.waveStart = source.getWaveStart() == null ? null : rtypes.rint(source.getWaveStart());
    }

    private void fillWaveStart(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setWaveStart((Integer)mapper.fromRType(this.getWaveStart()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadWaveIncrement() {
        this.waveIncrement = null;
    }

    @Override
    public RInt getWaveIncrement(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.waveIncrement;
    }

    @Override
    public void setWaveIncrement(RInt waveIncrement, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.waveIncrement = waveIncrement;
    }

    private void copyWaveIncrement(ome.model.core.Pixels source, IceMapper mapper) {
        this.waveIncrement = source.getWaveIncrement() == null ? null : rtypes.rint(source.getWaveIncrement());
    }

    private void fillWaveIncrement(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setWaveIncrement((Integer)mapper.fromRType(this.getWaveIncrement()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadTimeIncrement() {
        this.timeIncrement = null;
    }

    @Override
    public Time getTimeIncrement(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.timeIncrement;
    }

    @Override
    public void setTimeIncrement(Time timeIncrement, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.timeIncrement = timeIncrement;
    }

    private void copyTimeIncrement(ome.model.core.Pixels source, IceMapper mapper) {
        this.timeIncrement = (Time)mapper.findTarget(source.getTimeIncrement());
    }

    private void fillTimeIncrement(ome.model.core.Pixels target, IceMapper mapper) {
        target.putAt(TIMEINCREMENT, mapper.reverse((ModelBased)((Object)this.getTimeIncrement())));
    }

    public void unloadMethodology() {
        this.methodology = null;
    }

    @Override
    public RString getMethodology(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.methodology;
    }

    @Override
    public void setMethodology(RString methodology, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.methodology = methodology;
    }

    private void copyMethodology(ome.model.core.Pixels source, IceMapper mapper) {
        this.methodology = source.getMethodology() == null ? null : rtypes.rstring(source.getMethodology());
    }

    private void fillMethodology(ome.model.core.Pixels target, IceMapper mapper) {
        try {
            target.setMethodology((String)mapper.fromRType(this.getMethodology()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadPlaneInfo(Current current) {
        this.planeInfoLoaded = false;
        this.planeInfoSeq = null;
    }

    protected List getPlaneInfo(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.planeInfoSeq;
    }

    protected void setPlaneInfo(List planeInfo, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.planeInfoSeq = planeInfo == null ? new ArrayList() : new ArrayList(planeInfo);
        this.planeInfoLoaded = planeInfo != null;
    }

    private void copyPlaneInfo(ome.model.core.Pixels source, IceMapper mapper) {
        this.setPlaneInfo((List)mapper.findCollection((Collection)source.retrieve(PLANEINFO)), null);
    }

    private void fillPlaneInfo(ome.model.core.Pixels target, IceMapper mapper) {
        if (this.planeInfoLoaded) {
            target.putAt(PLANEINFO, mapper.reverse(this.planeInfoSeq, Set.class));
        } else {
            target.putAt(PLANEINFO, null);
        }
    }

    public boolean isPlaneInfoLoaded() {
        return this.planeInfoLoaded;
    }

    @Override
    public int sizeOfPlaneInfo(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            return -1;
        }
        return this.planeInfoSeq.size();
    }

    public List copyPlaneInfo(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            this.throwNullCollectionException("planeInfoSeq");
        }
        ArrayList result = new ArrayList(this.planeInfoSeq);
        return result;
    }

    public Iterator iteratePlaneInfo() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            this.throwNullCollectionException("planeInfoSeq");
        }
        return this.planeInfoSeq.iterator();
    }

    @Override
    public void addPlaneInfo(PlaneInfo target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            this.throwNullCollectionException("planeInfoSeq");
        }
        this.planeInfoSeq.add(target);
        target.setPixels(this);
    }

    @Override
    public void addAllPlaneInfoSet(List<PlaneInfo> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            this.throwNullCollectionException("planeInfoSeq");
        }
        this.planeInfoSeq.addAll(targets);
        for (PlaneInfo target : targets) {
            target.setPixels(this);
        }
    }

    @Override
    public void removePlaneInfo(PlaneInfo target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            this.throwNullCollectionException("planeInfoSeq");
        }
        this.planeInfoSeq.remove(target);
        target.setPixels(null);
    }

    @Override
    public void removeAllPlaneInfoSet(List<PlaneInfo> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            this.throwNullCollectionException("planeInfoSeq");
        }
        for (PlaneInfo elt : targets) {
            elt.setPixels(null);
            this.planeInfoSeq.remove(elt);
        }
    }

    @Override
    public void clearPlaneInfo(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.planeInfoLoaded) {
            this.throwNullCollectionException("planeInfoSeq");
        }
        for (PlaneInfo elt : this.planeInfoSeq) {
            elt.setPixels(null);
        }
        this.planeInfoSeq.clear();
    }

    @Override
    public void reloadPlaneInfo(Pixels toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.planeInfoLoaded) {
            throw new ClientError("Cannot reload active collection: planeInfoSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<PlaneInfo> copy = toCopy.copyPlaneInfo();
        for (PlaneInfo elt : copy) {
            elt.setPixels(this);
        }
        this.planeInfoSeq = new ArrayList<PlaneInfo>(copy);
        toCopy.unloadPlaneInfo();
        this.planeInfoLoaded = true;
    }

    @Override
    public void unloadPixelsFileMaps(Current current) {
        this.pixelsFileMapsLoaded = false;
        this.pixelsFileMapsSeq = null;
    }

    protected List getPixelsFileMaps(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pixelsFileMapsSeq;
    }

    protected void setPixelsFileMaps(List pixelsFileMaps, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pixelsFileMapsSeq = pixelsFileMaps == null ? new ArrayList() : new ArrayList(pixelsFileMaps);
        this.pixelsFileMapsLoaded = pixelsFileMaps != null;
    }

    private void copyPixelsFileMaps(ome.model.core.Pixels source, IceMapper mapper) {
        this.setPixelsFileMaps((List)mapper.findCollection((Collection)source.retrieve(PIXELSFILEMAPS)), null);
        this.pixelsFileMapsCountPerOwner = source.getPixelsFileMapsCountPerOwner();
    }

    private void fillPixelsFileMaps(ome.model.core.Pixels target, IceMapper mapper) {
        if (this.pixelsFileMapsLoaded) {
            target.putAt(PIXELSFILEMAPS, mapper.reverse(this.pixelsFileMapsSeq, Set.class));
        } else {
            target.putAt(PIXELSFILEMAPS, null);
        }
    }

    public boolean isPixelsFileMapsLoaded() {
        return this.pixelsFileMapsLoaded;
    }

    @Override
    public int sizeOfPixelsFileMaps(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            return -1;
        }
        return this.pixelsFileMapsSeq.size();
    }

    public List copyPixelsFileMaps(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        ArrayList result = new ArrayList(this.pixelsFileMapsSeq);
        return result;
    }

    public Iterator iteratePixelsFileMaps() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        return this.pixelsFileMapsSeq.iterator();
    }

    @Override
    public void addPixelsOriginalFileMap(PixelsOriginalFileMap target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        this.pixelsFileMapsSeq.add(target);
        target.setChild(this);
    }

    @Override
    public void addAllPixelsOriginalFileMapSet(List<PixelsOriginalFileMap> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        this.pixelsFileMapsSeq.addAll(targets);
        for (PixelsOriginalFileMap target : targets) {
            target.setChild(this);
        }
    }

    @Override
    public void removePixelsOriginalFileMap(PixelsOriginalFileMap target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        this.pixelsFileMapsSeq.remove(target);
        target.setChild(null);
    }

    @Override
    public void removeAllPixelsOriginalFileMapSet(List<PixelsOriginalFileMap> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        for (PixelsOriginalFileMap elt : targets) {
            elt.setChild(null);
            this.pixelsFileMapsSeq.remove(elt);
        }
    }

    @Override
    public void clearPixelsFileMaps(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        for (PixelsOriginalFileMap elt : this.pixelsFileMapsSeq) {
            elt.setChild(null);
        }
        this.pixelsFileMapsSeq.clear();
    }

    @Override
    public void reloadPixelsFileMaps(Pixels toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.pixelsFileMapsLoaded) {
            throw new ClientError("Cannot reload active collection: pixelsFileMapsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<PixelsOriginalFileMap> copy = toCopy.copyPixelsFileMaps();
        for (PixelsOriginalFileMap elt : copy) {
            elt.setChild(this);
        }
        this.pixelsFileMapsSeq = new ArrayList<PixelsOriginalFileMap>(copy);
        toCopy.unloadPixelsFileMaps();
        this.pixelsFileMapsLoaded = true;
    }

    @Override
    public Map<Long, Long> getPixelsFileMapsCountPerOwner(Current current) {
        return this.pixelsFileMapsCountPerOwner;
    }

    @Override
    public PixelsOriginalFileMap linkOriginalFile(OriginalFile addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        PixelsOriginalFileMapI link = new PixelsOriginalFileMapI();
        link.link(addition, this);
        this.addPixelsOriginalFileMapToBoth(link, true);
        return link;
    }

    @Override
    public void addPixelsOriginalFileMapToBoth(PixelsOriginalFileMap link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        this.pixelsFileMapsSeq.add(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().addPixelsOriginalFileMapToBoth(link, false);
        }
    }

    @Override
    public List<PixelsOriginalFileMap> findPixelsOriginalFileMap(OriginalFile removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        ArrayList<PixelsOriginalFileMap> result = new ArrayList<PixelsOriginalFileMap>();
        for (PixelsOriginalFileMap link : this.pixelsFileMapsSeq) {
            if (link.getParent() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkOriginalFile(OriginalFile removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        List<PixelsOriginalFileMap> toRemove = this.findPixelsOriginalFileMap(removal);
        Iterator<PixelsOriginalFileMap> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePixelsOriginalFileMapFromBoth(it.next(), true);
        }
    }

    @Override
    public void removePixelsOriginalFileMapFromBoth(PixelsOriginalFileMap link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("pixelsFileMapsSeq");
        }
        this.pixelsFileMapsSeq.remove(link);
        if (bothSides && link.getParent().isLoaded()) {
            link.getParent().removePixelsOriginalFileMapFromBoth(link, false);
        }
    }

    @Override
    public List<OriginalFile> linkedOriginalFileList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.pixelsFileMapsLoaded) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        ArrayList<OriginalFile> linked = new ArrayList<OriginalFile>();
        for (PixelsOriginalFileMap link : this.pixelsFileMapsSeq) {
            linked.add(link.getParent());
        }
        return linked;
    }

    @Override
    public void unloadChannels(Current current) {
        this.channelsLoaded = false;
        this.channelsSeq = null;
    }

    protected List getChannels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.channelsSeq;
    }

    protected void setChannels(List channels, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.channelsSeq = channels == null ? new ArrayList() : new ArrayList(channels);
        this.channelsLoaded = channels != null;
    }

    private void copyChannels(ome.model.core.Pixels source, IceMapper mapper) {
        this.setChannels((List)mapper.findCollection((Collection)source.retrieve(CHANNELS)), null);
    }

    private void fillChannels(ome.model.core.Pixels target, IceMapper mapper) {
        if (this.channelsLoaded) {
            target.putAt(CHANNELS, mapper.reverse(this.channelsSeq, List.class));
        } else {
            target.putAt(CHANNELS, null);
        }
    }

    public boolean isChannelsLoaded() {
        return this.channelsLoaded;
    }

    @Override
    public int sizeOfChannels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            return -1;
        }
        return this.channelsSeq.size();
    }

    public List copyChannels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        ArrayList result = new ArrayList(this.channelsSeq);
        return result;
    }

    public Iterator iterateChannels() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        return this.channelsSeq.iterator();
    }

    @Override
    public void addChannel(Channel target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        this.channelsSeq.add(target);
        target.setPixels(this);
    }

    @Override
    public void addAllChannelSet(List<Channel> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        this.channelsSeq.addAll(targets);
        for (Channel target : targets) {
            target.setPixels(this);
        }
    }

    @Override
    public void removeChannel(Channel target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        this.channelsSeq.remove(target);
        target.setPixels(null);
    }

    @Override
    public void removeAllChannelSet(List<Channel> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        for (Channel elt : targets) {
            elt.setPixels(null);
            this.channelsSeq.remove(elt);
        }
    }

    @Override
    public void clearChannels(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        for (Channel elt : this.channelsSeq) {
            elt.setPixels(null);
        }
        this.channelsSeq.clear();
    }

    @Override
    public void reloadChannels(Pixels toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.channelsLoaded) {
            throw new ClientError("Cannot reload active collection: channelsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Channel> copy = toCopy.copyChannels();
        for (Channel elt : copy) {
            elt.setPixels(this);
        }
        this.channelsSeq = new ArrayList<Channel>(copy);
        toCopy.unloadChannels();
        this.channelsLoaded = true;
    }

    @Override
    public Channel getChannel(int index, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        return (Channel)this.channelsSeq.get(index);
    }

    @Override
    public Channel setChannel(int index, Channel element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        Channel old = this.channelsSeq.set(index, element);
        if (element != null && element.isLoaded()) {
            element.setPixels(this);
        }
        return old;
    }

    @Override
    public Channel getPrimaryChannel(Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        return (Channel)this.channelsSeq.get(0);
    }

    @Override
    public Channel setPrimaryChannel(Channel element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.channelsLoaded) {
            this.throwNullCollectionException("channelsSeq");
        }
        int index = this.channelsSeq.indexOf(element);
        Channel old = (Channel)this.channelsSeq.get(0);
        this.channelsSeq.set(index, old);
        this.channelsSeq.set(0, element);
        return old;
    }

    @Override
    public void unloadSettings(Current current) {
        this.settingsLoaded = false;
        this.settingsSeq = null;
    }

    protected List getSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.settingsSeq;
    }

    protected void setSettings(List settings, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.settingsSeq = settings == null ? new ArrayList() : new ArrayList(settings);
        this.settingsLoaded = settings != null;
    }

    private void copySettings(ome.model.core.Pixels source, IceMapper mapper) {
        this.setSettings((List)mapper.findCollection((Collection)source.retrieve(SETTINGS)), null);
    }

    private void fillSettings(ome.model.core.Pixels target, IceMapper mapper) {
        if (this.settingsLoaded) {
            target.putAt(SETTINGS, mapper.reverse(this.settingsSeq, Set.class));
        } else {
            target.putAt(SETTINGS, null);
        }
    }

    public boolean isSettingsLoaded() {
        return this.settingsLoaded;
    }

    @Override
    public int sizeOfSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            return -1;
        }
        return this.settingsSeq.size();
    }

    public List copySettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            this.throwNullCollectionException("settingsSeq");
        }
        ArrayList result = new ArrayList(this.settingsSeq);
        return result;
    }

    public Iterator iterateSettings() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            this.throwNullCollectionException("settingsSeq");
        }
        return this.settingsSeq.iterator();
    }

    @Override
    public void addRenderingDef(RenderingDef target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            this.throwNullCollectionException("settingsSeq");
        }
        this.settingsSeq.add(target);
        target.setPixels(this);
    }

    @Override
    public void addAllRenderingDefSet(List<RenderingDef> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            this.throwNullCollectionException("settingsSeq");
        }
        this.settingsSeq.addAll(targets);
        for (RenderingDef target : targets) {
            target.setPixels(this);
        }
    }

    @Override
    public void removeRenderingDef(RenderingDef target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            this.throwNullCollectionException("settingsSeq");
        }
        this.settingsSeq.remove(target);
        target.setPixels(null);
    }

    @Override
    public void removeAllRenderingDefSet(List<RenderingDef> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            this.throwNullCollectionException("settingsSeq");
        }
        for (RenderingDef elt : targets) {
            elt.setPixels(null);
            this.settingsSeq.remove(elt);
        }
    }

    @Override
    public void clearSettings(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.settingsLoaded) {
            this.throwNullCollectionException("settingsSeq");
        }
        for (RenderingDef elt : this.settingsSeq) {
            elt.setPixels(null);
        }
        this.settingsSeq.clear();
    }

    @Override
    public void reloadSettings(Pixels toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.settingsLoaded) {
            throw new ClientError("Cannot reload active collection: settingsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<RenderingDef> copy = toCopy.copySettings();
        for (RenderingDef elt : copy) {
            elt.setPixels(this);
        }
        this.settingsSeq = new ArrayList<RenderingDef>(copy);
        toCopy.unloadSettings();
        this.settingsLoaded = true;
    }

    @Override
    public void unloadThumbnails(Current current) {
        this.thumbnailsLoaded = false;
        this.thumbnailsSeq = null;
    }

    protected List getThumbnails(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.thumbnailsSeq;
    }

    protected void setThumbnails(List thumbnails, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.thumbnailsSeq = thumbnails == null ? new ArrayList() : new ArrayList(thumbnails);
        this.thumbnailsLoaded = thumbnails != null;
    }

    private void copyThumbnails(ome.model.core.Pixels source, IceMapper mapper) {
        this.setThumbnails((List)mapper.findCollection((Collection)source.retrieve(THUMBNAILS)), null);
    }

    private void fillThumbnails(ome.model.core.Pixels target, IceMapper mapper) {
        if (this.thumbnailsLoaded) {
            target.putAt(THUMBNAILS, mapper.reverse(this.thumbnailsSeq, Set.class));
        } else {
            target.putAt(THUMBNAILS, null);
        }
    }

    public boolean isThumbnailsLoaded() {
        return this.thumbnailsLoaded;
    }

    @Override
    public int sizeOfThumbnails(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            return -1;
        }
        return this.thumbnailsSeq.size();
    }

    public List copyThumbnails(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            this.throwNullCollectionException("thumbnailsSeq");
        }
        ArrayList result = new ArrayList(this.thumbnailsSeq);
        return result;
    }

    public Iterator iterateThumbnails() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            this.throwNullCollectionException("thumbnailsSeq");
        }
        return this.thumbnailsSeq.iterator();
    }

    @Override
    public void addThumbnail(Thumbnail target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            this.throwNullCollectionException("thumbnailsSeq");
        }
        this.thumbnailsSeq.add(target);
        target.setPixels(this);
    }

    @Override
    public void addAllThumbnailSet(List<Thumbnail> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            this.throwNullCollectionException("thumbnailsSeq");
        }
        this.thumbnailsSeq.addAll(targets);
        for (Thumbnail target : targets) {
            target.setPixels(this);
        }
    }

    @Override
    public void removeThumbnail(Thumbnail target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            this.throwNullCollectionException("thumbnailsSeq");
        }
        this.thumbnailsSeq.remove(target);
        target.setPixels(null);
    }

    @Override
    public void removeAllThumbnailSet(List<Thumbnail> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            this.throwNullCollectionException("thumbnailsSeq");
        }
        for (Thumbnail elt : targets) {
            elt.setPixels(null);
            this.thumbnailsSeq.remove(elt);
        }
    }

    @Override
    public void clearThumbnails(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.thumbnailsLoaded) {
            this.throwNullCollectionException("thumbnailsSeq");
        }
        for (Thumbnail elt : this.thumbnailsSeq) {
            elt.setPixels(null);
        }
        this.thumbnailsSeq.clear();
    }

    @Override
    public void reloadThumbnails(Pixels toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.thumbnailsLoaded) {
            throw new ClientError("Cannot reload active collection: thumbnailsSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Thumbnail> copy = toCopy.copyThumbnails();
        for (Thumbnail elt : copy) {
            elt.setPixels(this);
        }
        this.thumbnailsSeq = new ArrayList<Thumbnail>(copy);
        toCopy.unloadThumbnails();
        this.thumbnailsLoaded = true;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.core.Pixels) {
            ome.model.core.Pixels source = (ome.model.core.Pixels)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyImage(source, mapper);
                this.copyRelatedTo(source, mapper);
                this.copyPixelsType(source, mapper);
                this.copySignificantBits(source, mapper);
                this.copySizeX(source, mapper);
                this.copySizeY(source, mapper);
                this.copySizeZ(source, mapper);
                this.copySizeC(source, mapper);
                this.copySizeT(source, mapper);
                this.copySha1(source, mapper);
                this.copyDimensionOrder(source, mapper);
                this.copyPhysicalSizeX(source, mapper);
                this.copyPhysicalSizeY(source, mapper);
                this.copyPhysicalSizeZ(source, mapper);
                this.copyWaveStart(source, mapper);
                this.copyWaveIncrement(source, mapper);
                this.copyTimeIncrement(source, mapper);
                this.copyMethodology(source, mapper);
                this.copyPlaneInfo(source, mapper);
                this.copyPixelsFileMaps(source, mapper);
                this.copyChannels(source, mapper);
                this.copySettings(source, mapper);
                this.copyThumbnails(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Pixels cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.core.Pixels target = new ome.model.core.Pixels();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillImage(target, mapper);
            this.fillRelatedTo(target, mapper);
            this.fillPixelsType(target, mapper);
            this.fillSignificantBits(target, mapper);
            this.fillSizeX(target, mapper);
            this.fillSizeY(target, mapper);
            this.fillSizeZ(target, mapper);
            this.fillSizeC(target, mapper);
            this.fillSizeT(target, mapper);
            this.fillSha1(target, mapper);
            this.fillDimensionOrder(target, mapper);
            this.fillPhysicalSizeX(target, mapper);
            this.fillPhysicalSizeY(target, mapper);
            this.fillPhysicalSizeZ(target, mapper);
            this.fillWaveStart(target, mapper);
            this.fillWaveIncrement(target, mapper);
            this.fillTimeIncrement(target, mapper);
            this.fillMethodology(target, mapper);
            this.fillPlaneInfo(target, mapper);
            this.fillPixelsFileMaps(target, mapper);
            this.fillChannels(target, mapper);
            this.fillSettings(target, mapper);
            this.fillThumbnails(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<PixelsI> cast(List list) {
        return list;
    }
}

