/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RBool;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Frequency;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.Laser;
import omero.model.LaserMedium;
import omero.model.LaserType;
import omero.model.Length;
import omero.model.LightSource;
import omero.model.LightSourceAnnotationLink;
import omero.model.LightSourceAnnotationLinkI;
import omero.model.Power;
import omero.model.Pulse;
import omero.rtypes;
import omero.util.IceMapper;

public class LaserI
extends Laser
implements ModelBased {
    public static final String TYPE = "ome.model.acquisition.Laser_type";
    public static final String LASERMEDIUM = "ome.model.acquisition.Laser_laserMedium";
    public static final String FREQUENCYMULTIPLICATION = "ome.model.acquisition.Laser_frequencyMultiplication";
    public static final String TUNEABLE = "ome.model.acquisition.Laser_tuneable";
    public static final String PULSE = "ome.model.acquisition.Laser_pulse";
    public static final String WAVELENGTH = "ome.model.acquisition.Laser_wavelength";
    public static final String POCKELCELL = "ome.model.acquisition.Laser_pockelCell";
    public static final String PUMP = "ome.model.acquisition.Laser_pump";
    public static final String REPETITIONRATE = "ome.model.acquisition.Laser_repetitionRate";
    public static final String MANUFACTURER = "ome.model.acquisition.Laser_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Laser_model";
    public static final String POWER = "ome.model.acquisition.Laser_power";
    public static final String LOTNUMBER = "ome.model.acquisition.Laser_lotNumber";
    public static final String SERIALNUMBER = "ome.model.acquisition.Laser_serialNumber";
    public static final String INSTRUMENT = "ome.model.acquisition.Laser_instrument";
    public static final String ANNOTATIONLINKS = "ome.model.acquisition.Laser_annotationLinks";
    public static final String DETAILS = "ome.model.acquisition.Laser_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public LaserI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public LaserI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public LaserI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadType();
        this.unloadLaserMedium();
        this.unloadFrequencyMultiplication();
        this.unloadTuneable();
        this.unloadPulse();
        this.unloadWavelength();
        this.unloadPockelCell();
        this.unloadPump();
        this.unloadRepetitionRate();
        this.unloadManufacturer();
        this.unloadModel();
        this.unloadPower();
        this.unloadLotNumber();
        this.unloadSerialNumber();
        this.unloadInstrument();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        LaserI copy = new LaserI();
        copy.id = this.id;
        copy.version = this.version;
        copy.type = this.type == null ? null : (LaserType)this.type.proxy();
        copy.laserMedium = this.laserMedium == null ? null : (LaserMedium)this.laserMedium.proxy();
        copy.frequencyMultiplication = this.frequencyMultiplication;
        copy.tuneable = this.tuneable;
        copy.pulse = this.pulse == null ? null : (Pulse)this.pulse.proxy();
        copy.wavelength = this.wavelength == null ? null : this.wavelength.copy();
        copy.pockelCell = this.pockelCell;
        copy.pump = this.pump == null ? null : (LightSource)this.pump.proxy();
        copy.repetitionRate = this.repetitionRate == null ? null : this.repetitionRate.copy();
        copy.manufacturer = this.manufacturer;
        copy.model = this.model;
        copy.power = this.power == null ? null : this.power.copy();
        copy.lotNumber = this.lotNumber;
        copy.serialNumber = this.serialNumber;
        Instrument instrument = copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList();
            for (LightSourceAnnotationLink item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (LightSourceAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new LaserI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public LaserType getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(LaserType type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.type = (LaserType)mapper.findTarget(source.getType());
    }

    private void fillType(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt(TYPE, mapper.reverse((ModelBased)((Object)this.getType())));
    }

    public void unloadLaserMedium() {
        this.laserMedium = null;
    }

    @Override
    public LaserMedium getLaserMedium(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.laserMedium;
    }

    @Override
    public void setLaserMedium(LaserMedium laserMedium, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.laserMedium = laserMedium;
    }

    private void copyLaserMedium(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.laserMedium = (LaserMedium)mapper.findTarget(source.getLaserMedium());
    }

    private void fillLaserMedium(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt(LASERMEDIUM, mapper.reverse((ModelBased)((Object)this.getLaserMedium())));
    }

    public void unloadFrequencyMultiplication() {
        this.frequencyMultiplication = null;
    }

    @Override
    public RInt getFrequencyMultiplication(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.frequencyMultiplication;
    }

    @Override
    public void setFrequencyMultiplication(RInt frequencyMultiplication, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.frequencyMultiplication = frequencyMultiplication;
    }

    private void copyFrequencyMultiplication(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.frequencyMultiplication = source.getFrequencyMultiplication() == null ? null : rtypes.rint(source.getFrequencyMultiplication());
    }

    private void fillFrequencyMultiplication(ome.model.acquisition.Laser target, IceMapper mapper) {
        try {
            target.setFrequencyMultiplication((Integer)mapper.fromRType(this.getFrequencyMultiplication()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadTuneable() {
        this.tuneable = null;
    }

    @Override
    public RBool getTuneable(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.tuneable;
    }

    @Override
    public void setTuneable(RBool tuneable, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.tuneable = tuneable;
    }

    private void copyTuneable(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.tuneable = source.getTuneable() == null ? null : rtypes.rbool(source.getTuneable());
    }

    private void fillTuneable(ome.model.acquisition.Laser target, IceMapper mapper) {
        try {
            target.setTuneable((Boolean)mapper.fromRType(this.getTuneable()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPulse() {
        this.pulse = null;
    }

    @Override
    public Pulse getPulse(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pulse;
    }

    @Override
    public void setPulse(Pulse pulse, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pulse = pulse;
    }

    private void copyPulse(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.pulse = (Pulse)mapper.findTarget(source.getPulse());
    }

    private void fillPulse(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt(PULSE, mapper.reverse((ModelBased)((Object)this.getPulse())));
    }

    public void unloadWavelength() {
        this.wavelength = null;
    }

    @Override
    public Length getWavelength(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.wavelength;
    }

    @Override
    public void setWavelength(Length wavelength, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.wavelength = wavelength;
    }

    private void copyWavelength(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.wavelength = (Length)mapper.findTarget(source.getWavelength());
    }

    private void fillWavelength(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt(WAVELENGTH, mapper.reverse((ModelBased)((Object)this.getWavelength())));
    }

    public void unloadPockelCell() {
        this.pockelCell = null;
    }

    @Override
    public RBool getPockelCell(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pockelCell;
    }

    @Override
    public void setPockelCell(RBool pockelCell, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pockelCell = pockelCell;
    }

    private void copyPockelCell(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.pockelCell = source.getPockelCell() == null ? null : rtypes.rbool(source.getPockelCell());
    }

    private void fillPockelCell(ome.model.acquisition.Laser target, IceMapper mapper) {
        try {
            target.setPockelCell((Boolean)mapper.fromRType(this.getPockelCell()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPump() {
        this.pump = null;
    }

    @Override
    public LightSource getPump(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.pump;
    }

    @Override
    public void setPump(LightSource pump, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.pump = pump;
    }

    private void copyPump(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.pump = (LightSource)mapper.findTarget(source.getPump());
    }

    private void fillPump(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt(PUMP, mapper.reverse((ModelBased)((Object)this.getPump())));
    }

    public void unloadRepetitionRate() {
        this.repetitionRate = null;
    }

    @Override
    public Frequency getRepetitionRate(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.repetitionRate;
    }

    @Override
    public void setRepetitionRate(Frequency repetitionRate, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.repetitionRate = repetitionRate;
    }

    private void copyRepetitionRate(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.repetitionRate = (Frequency)mapper.findTarget(source.getRepetitionRate());
    }

    private void fillRepetitionRate(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt(REPETITIONRATE, mapper.reverse((ModelBased)((Object)this.getRepetitionRate())));
    }

    public void unloadManufacturer() {
        this.manufacturer = null;
    }

    @Override
    public RString getManufacturer(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(RString manufacturer, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.manufacturer = manufacturer;
    }

    private void copyManufacturer(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.manufacturer = source.getManufacturer() == null ? null : rtypes.rstring(source.getManufacturer());
    }

    private void fillManufacturer(ome.model.acquisition.Laser target, IceMapper mapper) {
        try {
            target.setManufacturer((String)mapper.fromRType(this.getManufacturer()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadModel() {
        this.model = null;
    }

    @Override
    public RString getModel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.model;
    }

    @Override
    public void setModel(RString model, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.model = model;
    }

    private void copyModel(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.model = source.getModel() == null ? null : rtypes.rstring(source.getModel());
    }

    private void fillModel(ome.model.acquisition.Laser target, IceMapper mapper) {
        try {
            target.setModel((String)mapper.fromRType(this.getModel()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPower() {
        this.power = null;
    }

    @Override
    public Power getPower(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.power;
    }

    @Override
    public void setPower(Power power, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.power = power;
    }

    private void copyPower(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.power = (Power)mapper.findTarget(source.getPower());
    }

    private void fillPower(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt("ome.model.acquisition.LightSource_power", mapper.reverse((ModelBased)((Object)this.getPower())));
    }

    public void unloadLotNumber() {
        this.lotNumber = null;
    }

    @Override
    public RString getLotNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lotNumber;
    }

    @Override
    public void setLotNumber(RString lotNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lotNumber = lotNumber;
    }

    private void copyLotNumber(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.lotNumber = source.getLotNumber() == null ? null : rtypes.rstring(source.getLotNumber());
    }

    private void fillLotNumber(ome.model.acquisition.Laser target, IceMapper mapper) {
        try {
            target.setLotNumber((String)mapper.fromRType(this.getLotNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSerialNumber() {
        this.serialNumber = null;
    }

    @Override
    public RString getSerialNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.serialNumber;
    }

    @Override
    public void setSerialNumber(RString serialNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.serialNumber = serialNumber;
    }

    private void copySerialNumber(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.serialNumber = source.getSerialNumber() == null ? null : rtypes.rstring(source.getSerialNumber());
    }

    private void fillSerialNumber(ome.model.acquisition.Laser target, IceMapper mapper) {
        try {
            target.setSerialNumber((String)mapper.fromRType(this.getSerialNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.acquisition.Laser target, IceMapper mapper) {
        target.putAt("ome.model.acquisition.LightSource_instrument", mapper.reverse((ModelBased)((Object)this.getInstrument())));
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.acquisition.Laser source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve("ome.model.acquisition.LightSource_annotationLinks")), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.acquisition.Laser target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt("ome.model.acquisition.LightSource_annotationLinks", mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt("ome.model.acquisition.LightSource_annotationLinks", null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addLightSourceAnnotationLink(LightSourceAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllLightSourceAnnotationLinkSet(List<LightSourceAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (LightSourceAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeLightSourceAnnotationLink(LightSourceAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllLightSourceAnnotationLinkSet(List<LightSourceAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (LightSourceAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (LightSourceAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(LightSource toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<LightSourceAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (LightSourceAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<LightSourceAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public LightSourceAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        LightSourceAnnotationLinkI link = new LightSourceAnnotationLinkI();
        link.link(this, addition);
        this.addLightSourceAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addLightSourceAnnotationLinkToBoth(LightSourceAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<LightSourceAnnotationLink> findLightSourceAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<LightSourceAnnotationLink> result = new ArrayList<LightSourceAnnotationLink>();
        for (LightSourceAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<LightSourceAnnotationLink> toRemove = this.findLightSourceAnnotationLink(removal);
        Iterator<LightSourceAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeLightSourceAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeLightSourceAnnotationLinkFromBoth(LightSourceAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (LightSourceAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.Laser) {
            ome.model.acquisition.Laser source = (ome.model.acquisition.Laser)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyType(source, mapper);
                this.copyLaserMedium(source, mapper);
                this.copyFrequencyMultiplication(source, mapper);
                this.copyTuneable(source, mapper);
                this.copyPulse(source, mapper);
                this.copyWavelength(source, mapper);
                this.copyPockelCell(source, mapper);
                this.copyPump(source, mapper);
                this.copyRepetitionRate(source, mapper);
                this.copyManufacturer(source, mapper);
                this.copyModel(source, mapper);
                this.copyPower(source, mapper);
                this.copyLotNumber(source, mapper);
                this.copySerialNumber(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Laser cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.Laser target = new ome.model.acquisition.Laser();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillType(target, mapper);
            this.fillLaserMedium(target, mapper);
            this.fillFrequencyMultiplication(target, mapper);
            this.fillTuneable(target, mapper);
            this.fillPulse(target, mapper);
            this.fillWavelength(target, mapper);
            this.fillPockelCell(target, mapper);
            this.fillPump(target, mapper);
            this.fillRepetitionRate(target, mapper);
            this.fillManufacturer(target, mapper);
            this.fillModel(target, mapper);
            this.fillPower(target, mapper);
            this.fillLotNumber(target, mapper);
            this.fillSerialNumber(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<LaserI> cast(List list) {
        return list;
    }
}

