/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FormatType;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.model.Annotation;
import omero.model.AnnotationHolder;
import omero.model.Details;
import omero.model.Detector;
import omero.model.DetectorHolder;
import omero.model.Dichroic;
import omero.model.DichroicHolder;
import omero.model.Filter;
import omero.model.FilterHolder;
import omero.model.FilterSet;
import omero.model.FilterSetHolder;
import omero.model.IObject;
import omero.model.InstrumentAnnotationLink;
import omero.model.InstrumentAnnotationLinkHolder;
import omero.model.InstrumentAnnotationLinksSeqHelper;
import omero.model.InstrumentDetectorSeqHelper;
import omero.model.InstrumentDichroicSeqHelper;
import omero.model.InstrumentFilterSeqHelper;
import omero.model.InstrumentFilterSetSeqHelper;
import omero.model.InstrumentHolder;
import omero.model.InstrumentLightSourceSeqHelper;
import omero.model.InstrumentLinkedAnnotationSeqHelper;
import omero.model.InstrumentObjectiveSeqHelper;
import omero.model.InstrumentOtfSeqHelper;
import omero.model.LightSource;
import omero.model.LightSourceHolder;
import omero.model.Microscope;
import omero.model.MicroscopeHolder;
import omero.model.OTF;
import omero.model.OTFHolder;
import omero.model.Objective;
import omero.model.ObjectiveHolder;
import omero.model._InstrumentOperations;
import omero.model._InstrumentOperationsNC;
import omero.sys.CountMapHelper;

public abstract class Instrument
extends IObject
implements _InstrumentOperations,
_InstrumentOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::IObject", "::omero::model::Instrument"};
    private static final String[] __all = new String[]{"addAllDetectorSet", "addAllDichroicSet", "addAllFilterSet", "addAllFilterSetSet", "addAllInstrumentAnnotationLinkSet", "addAllLightSourceSet", "addAllOTFSet", "addAllObjectiveSet", "addDetector", "addDichroic", "addFilter", "addFilterSet", "addInstrumentAnnotationLink", "addInstrumentAnnotationLinkToBoth", "addLightSource", "addOTF", "addObjective", "clearAnnotationLinks", "clearDetector", "clearDichroic", "clearFilter", "clearFilterSet", "clearLightSource", "clearObjective", "clearOtf", "copyAnnotationLinks", "copyDetector", "copyDichroic", "copyFilter", "copyFilterSet", "copyLightSource", "copyObjective", "copyOtf", "findInstrumentAnnotationLink", "getAnnotationLinksCountPerOwner", "getDetails", "getId", "getMicroscope", "getVersion", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "linkAnnotation", "linkedAnnotationList", "proxy", "reloadAnnotationLinks", "reloadDetector", "reloadDichroic", "reloadFilter", "reloadFilterSet", "reloadLightSource", "reloadObjective", "reloadOtf", "removeAllDetectorSet", "removeAllDichroicSet", "removeAllFilterSet", "removeAllFilterSetSet", "removeAllInstrumentAnnotationLinkSet", "removeAllLightSourceSet", "removeAllOTFSet", "removeAllObjectiveSet", "removeDetector", "removeDichroic", "removeFilter", "removeFilterSet", "removeInstrumentAnnotationLink", "removeInstrumentAnnotationLinkFromBoth", "removeLightSource", "removeOTF", "removeObjective", "setId", "setMicroscope", "setVersion", "shallowCopy", "sizeOfAnnotationLinks", "sizeOfDetector", "sizeOfDichroic", "sizeOfFilter", "sizeOfFilterSet", "sizeOfLightSource", "sizeOfObjective", "sizeOfOtf", "unlinkAnnotation", "unload", "unloadAnnotationLinks", "unloadCollections", "unloadDetails", "unloadDetector", "unloadDichroic", "unloadFilter", "unloadFilterSet", "unloadLightSource", "unloadObjective", "unloadOtf"};
    protected RInt version;
    protected Microscope microscope;
    protected List<Detector> detectorSeq;
    protected boolean detectorLoaded;
    protected List<Objective> objectiveSeq;
    protected boolean objectiveLoaded;
    protected List<LightSource> lightSourceSeq;
    protected boolean lightSourceLoaded;
    protected List<Filter> filterSeq;
    protected boolean filterLoaded;
    protected List<Dichroic> dichroicSeq;
    protected boolean dichroicLoaded;
    protected List<FilterSet> filterSetSeq;
    protected boolean filterSetLoaded;
    protected List<OTF> otfSeq;
    protected boolean otfLoaded;
    protected List<InstrumentAnnotationLink> annotationLinksSeq;
    protected boolean annotationLinksLoaded;
    protected Map<Long, Long> annotationLinksCountPerOwner;
    public static final long serialVersionUID = 2659499742273964516L;

    public Instrument() {
    }

    public Instrument(RLong id, Details details, boolean loaded, RInt version, Microscope microscope, List<Detector> detectorSeq, boolean detectorLoaded, List<Objective> objectiveSeq, boolean objectiveLoaded, List<LightSource> lightSourceSeq, boolean lightSourceLoaded, List<Filter> filterSeq, boolean filterLoaded, List<Dichroic> dichroicSeq, boolean dichroicLoaded, List<FilterSet> filterSetSeq, boolean filterSetLoaded, List<OTF> otfSeq, boolean otfLoaded, List<InstrumentAnnotationLink> annotationLinksSeq, boolean annotationLinksLoaded, Map<Long, Long> annotationLinksCountPerOwner) {
        super(id, details, loaded);
        this.version = version;
        this.microscope = microscope;
        this.detectorSeq = detectorSeq;
        this.detectorLoaded = detectorLoaded;
        this.objectiveSeq = objectiveSeq;
        this.objectiveLoaded = objectiveLoaded;
        this.lightSourceSeq = lightSourceSeq;
        this.lightSourceLoaded = lightSourceLoaded;
        this.filterSeq = filterSeq;
        this.filterLoaded = filterLoaded;
        this.dichroicSeq = dichroicSeq;
        this.dichroicLoaded = dichroicLoaded;
        this.filterSetSeq = filterSetSeq;
        this.filterSetLoaded = filterSetLoaded;
        this.otfSeq = otfSeq;
        this.otfLoaded = otfLoaded;
        this.annotationLinksSeq = annotationLinksSeq;
        this.annotationLinksLoaded = annotationLinksLoaded;
        this.annotationLinksCountPerOwner = annotationLinksCountPerOwner;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[2];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[2];
    }

    public static String ice_staticId() {
        return __ids[2];
    }

    @Override
    public final void addAllDetectorSet(List<Detector> targets) {
        this.addAllDetectorSet(targets, null);
    }

    @Override
    public final void addAllDichroicSet(List<Dichroic> targets) {
        this.addAllDichroicSet(targets, null);
    }

    @Override
    public final void addAllFilterSet(List<Filter> targets) {
        this.addAllFilterSet(targets, null);
    }

    @Override
    public final void addAllFilterSetSet(List<FilterSet> targets) {
        this.addAllFilterSetSet(targets, null);
    }

    @Override
    public final void addAllInstrumentAnnotationLinkSet(List<InstrumentAnnotationLink> targets) {
        this.addAllInstrumentAnnotationLinkSet(targets, null);
    }

    @Override
    public final void addAllLightSourceSet(List<LightSource> targets) {
        this.addAllLightSourceSet(targets, null);
    }

    @Override
    public final void addAllOTFSet(List<OTF> targets) {
        this.addAllOTFSet(targets, null);
    }

    @Override
    public final void addAllObjectiveSet(List<Objective> targets) {
        this.addAllObjectiveSet(targets, null);
    }

    @Override
    public final void addDetector(Detector target) {
        this.addDetector(target, null);
    }

    @Override
    public final void addDichroic(Dichroic target) {
        this.addDichroic(target, null);
    }

    @Override
    public final void addFilter(Filter target) {
        this.addFilter(target, null);
    }

    @Override
    public final void addFilterSet(FilterSet target) {
        this.addFilterSet(target, null);
    }

    @Override
    public final void addInstrumentAnnotationLink(InstrumentAnnotationLink target) {
        this.addInstrumentAnnotationLink(target, null);
    }

    @Override
    public final void addInstrumentAnnotationLinkToBoth(InstrumentAnnotationLink link, boolean bothSides) {
        this.addInstrumentAnnotationLinkToBoth(link, bothSides, null);
    }

    @Override
    public final void addLightSource(LightSource target) {
        this.addLightSource(target, null);
    }

    @Override
    public final void addOTF(OTF target) {
        this.addOTF(target, null);
    }

    @Override
    public final void addObjective(Objective target) {
        this.addObjective(target, null);
    }

    @Override
    public final void clearAnnotationLinks() {
        this.clearAnnotationLinks(null);
    }

    @Override
    public final void clearDetector() {
        this.clearDetector(null);
    }

    @Override
    public final void clearDichroic() {
        this.clearDichroic(null);
    }

    @Override
    public final void clearFilter() {
        this.clearFilter(null);
    }

    @Override
    public final void clearFilterSet() {
        this.clearFilterSet(null);
    }

    @Override
    public final void clearLightSource() {
        this.clearLightSource(null);
    }

    @Override
    public final void clearObjective() {
        this.clearObjective(null);
    }

    @Override
    public final void clearOtf() {
        this.clearOtf(null);
    }

    @Override
    public final List<InstrumentAnnotationLink> copyAnnotationLinks() {
        return this.copyAnnotationLinks(null);
    }

    @Override
    public final List<Detector> copyDetector() {
        return this.copyDetector(null);
    }

    @Override
    public final List<Dichroic> copyDichroic() {
        return this.copyDichroic(null);
    }

    @Override
    public final List<Filter> copyFilter() {
        return this.copyFilter(null);
    }

    @Override
    public final List<FilterSet> copyFilterSet() {
        return this.copyFilterSet(null);
    }

    @Override
    public final List<LightSource> copyLightSource() {
        return this.copyLightSource(null);
    }

    @Override
    public final List<Objective> copyObjective() {
        return this.copyObjective(null);
    }

    @Override
    public final List<OTF> copyOtf() {
        return this.copyOtf(null);
    }

    @Override
    public final List<InstrumentAnnotationLink> findInstrumentAnnotationLink(Annotation removal) {
        return this.findInstrumentAnnotationLink(removal, null);
    }

    @Override
    public final Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.getAnnotationLinksCountPerOwner(null);
    }

    @Override
    public final Microscope getMicroscope() {
        return this.getMicroscope(null);
    }

    @Override
    public final RInt getVersion() {
        return this.getVersion(null);
    }

    @Override
    public final InstrumentAnnotationLink linkAnnotation(Annotation addition) {
        return this.linkAnnotation(addition, null);
    }

    @Override
    public final List<Annotation> linkedAnnotationList() {
        return this.linkedAnnotationList(null);
    }

    @Override
    public final void reloadAnnotationLinks(Instrument toCopy) {
        this.reloadAnnotationLinks(toCopy, null);
    }

    @Override
    public final void reloadDetector(Instrument toCopy) {
        this.reloadDetector(toCopy, null);
    }

    @Override
    public final void reloadDichroic(Instrument toCopy) {
        this.reloadDichroic(toCopy, null);
    }

    @Override
    public final void reloadFilter(Instrument toCopy) {
        this.reloadFilter(toCopy, null);
    }

    @Override
    public final void reloadFilterSet(Instrument toCopy) {
        this.reloadFilterSet(toCopy, null);
    }

    @Override
    public final void reloadLightSource(Instrument toCopy) {
        this.reloadLightSource(toCopy, null);
    }

    @Override
    public final void reloadObjective(Instrument toCopy) {
        this.reloadObjective(toCopy, null);
    }

    @Override
    public final void reloadOtf(Instrument toCopy) {
        this.reloadOtf(toCopy, null);
    }

    @Override
    public final void removeAllDetectorSet(List<Detector> targets) {
        this.removeAllDetectorSet(targets, null);
    }

    @Override
    public final void removeAllDichroicSet(List<Dichroic> targets) {
        this.removeAllDichroicSet(targets, null);
    }

    @Override
    public final void removeAllFilterSet(List<Filter> targets) {
        this.removeAllFilterSet(targets, null);
    }

    @Override
    public final void removeAllFilterSetSet(List<FilterSet> targets) {
        this.removeAllFilterSetSet(targets, null);
    }

    @Override
    public final void removeAllInstrumentAnnotationLinkSet(List<InstrumentAnnotationLink> targets) {
        this.removeAllInstrumentAnnotationLinkSet(targets, null);
    }

    @Override
    public final void removeAllLightSourceSet(List<LightSource> targets) {
        this.removeAllLightSourceSet(targets, null);
    }

    @Override
    public final void removeAllOTFSet(List<OTF> targets) {
        this.removeAllOTFSet(targets, null);
    }

    @Override
    public final void removeAllObjectiveSet(List<Objective> targets) {
        this.removeAllObjectiveSet(targets, null);
    }

    @Override
    public final void removeDetector(Detector theTarget) {
        this.removeDetector(theTarget, null);
    }

    @Override
    public final void removeDichroic(Dichroic theTarget) {
        this.removeDichroic(theTarget, null);
    }

    @Override
    public final void removeFilter(Filter theTarget) {
        this.removeFilter(theTarget, null);
    }

    @Override
    public final void removeFilterSet(FilterSet theTarget) {
        this.removeFilterSet(theTarget, null);
    }

    @Override
    public final void removeInstrumentAnnotationLink(InstrumentAnnotationLink theTarget) {
        this.removeInstrumentAnnotationLink(theTarget, null);
    }

    @Override
    public final void removeInstrumentAnnotationLinkFromBoth(InstrumentAnnotationLink link, boolean bothSides) {
        this.removeInstrumentAnnotationLinkFromBoth(link, bothSides, null);
    }

    @Override
    public final void removeLightSource(LightSource theTarget) {
        this.removeLightSource(theTarget, null);
    }

    @Override
    public final void removeOTF(OTF theTarget) {
        this.removeOTF(theTarget, null);
    }

    @Override
    public final void removeObjective(Objective theTarget) {
        this.removeObjective(theTarget, null);
    }

    @Override
    public final void setMicroscope(Microscope theMicroscope) {
        this.setMicroscope(theMicroscope, null);
    }

    @Override
    public final void setVersion(RInt theVersion) {
        this.setVersion(theVersion, null);
    }

    @Override
    public final int sizeOfAnnotationLinks() {
        return this.sizeOfAnnotationLinks(null);
    }

    @Override
    public final int sizeOfDetector() {
        return this.sizeOfDetector(null);
    }

    @Override
    public final int sizeOfDichroic() {
        return this.sizeOfDichroic(null);
    }

    @Override
    public final int sizeOfFilter() {
        return this.sizeOfFilter(null);
    }

    @Override
    public final int sizeOfFilterSet() {
        return this.sizeOfFilterSet(null);
    }

    @Override
    public final int sizeOfLightSource() {
        return this.sizeOfLightSource(null);
    }

    @Override
    public final int sizeOfObjective() {
        return this.sizeOfObjective(null);
    }

    @Override
    public final int sizeOfOtf() {
        return this.sizeOfOtf(null);
    }

    @Override
    public final void unlinkAnnotation(Annotation removal) {
        this.unlinkAnnotation(removal, null);
    }

    @Override
    public final void unloadAnnotationLinks() {
        this.unloadAnnotationLinks(null);
    }

    @Override
    public final void unloadDetector() {
        this.unloadDetector(null);
    }

    @Override
    public final void unloadDichroic() {
        this.unloadDichroic(null);
    }

    @Override
    public final void unloadFilter() {
        this.unloadFilter(null);
    }

    @Override
    public final void unloadFilterSet() {
        this.unloadFilterSet(null);
    }

    @Override
    public final void unloadLightSource() {
        this.unloadLightSource(null);
    }

    @Override
    public final void unloadObjective() {
        this.unloadObjective(null);
    }

    @Override
    public final void unloadOtf() {
        this.unloadOtf(null);
    }

    public static DispatchStatus ___getVersion(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getVersion(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setVersion(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder theVersion = new RIntHolder();
        __is.readObject(theVersion);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setVersion((RInt)theVersion.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getMicroscope(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        Microscope __ret = __obj.getMicroscope(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setMicroscope(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        MicroscopeHolder theMicroscope = new MicroscopeHolder();
        __is.readObject(theMicroscope);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setMicroscope((Microscope)theMicroscope.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadDetector(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadDetector(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfDetector(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfDetector(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyDetector(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<Detector> __ret = __obj.copyDetector(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentDetectorSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDetector(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorHolder target = new DetectorHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addDetector((Detector)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllDetectorSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Detector> targets = InstrumentDetectorSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllDetectorSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDetector(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        DetectorHolder theTarget = new DetectorHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeDetector((Detector)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllDetectorSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Detector> targets = InstrumentDetectorSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllDetectorSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearDetector(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearDetector(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadDetector(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadDetector((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadObjective(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadObjective(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfObjective(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfObjective(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyObjective(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<Objective> __ret = __obj.copyObjective(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentObjectiveSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addObjective(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        ObjectiveHolder target = new ObjectiveHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addObjective((Objective)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllObjectiveSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Objective> targets = InstrumentObjectiveSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllObjectiveSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeObjective(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        ObjectiveHolder theTarget = new ObjectiveHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeObjective((Objective)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllObjectiveSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Objective> targets = InstrumentObjectiveSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllObjectiveSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearObjective(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearObjective(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadObjective(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadObjective((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadLightSource(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadLightSource(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfLightSource(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfLightSource(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyLightSource(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<LightSource> __ret = __obj.copyLightSource(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentLightSourceSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addLightSource(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        LightSourceHolder target = new LightSourceHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addLightSource((LightSource)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllLightSourceSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<LightSource> targets = InstrumentLightSourceSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllLightSourceSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeLightSource(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        LightSourceHolder theTarget = new LightSourceHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeLightSource((LightSource)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllLightSourceSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<LightSource> targets = InstrumentLightSourceSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllLightSourceSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearLightSource(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearLightSource(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadLightSource(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadLightSource((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadFilter(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadFilter(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfFilter(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfFilter(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyFilter(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<Filter> __ret = __obj.copyFilter(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentFilterSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addFilter(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder target = new FilterHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addFilter((Filter)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Filter> targets = InstrumentFilterSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllFilterSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeFilter(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterHolder theTarget = new FilterHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeFilter((Filter)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Filter> targets = InstrumentFilterSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllFilterSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearFilter(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearFilter(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadFilter(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadFilter((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadDichroic(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadDichroic(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfDichroic(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfDichroic(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyDichroic(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<Dichroic> __ret = __obj.copyDichroic(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentDichroicSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addDichroic(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        DichroicHolder target = new DichroicHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addDichroic((Dichroic)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllDichroicSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Dichroic> targets = InstrumentDichroicSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllDichroicSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeDichroic(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        DichroicHolder theTarget = new DichroicHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeDichroic((Dichroic)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllDichroicSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<Dichroic> targets = InstrumentDichroicSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllDichroicSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearDichroic(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearDichroic(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadDichroic(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadDichroic((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadFilterSet(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfFilterSet(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<FilterSet> __ret = __obj.copyFilterSet(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentFilterSetSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetHolder target = new FilterSetHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addFilterSet((FilterSet)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllFilterSetSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<FilterSet> targets = InstrumentFilterSetSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllFilterSetSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        FilterSetHolder theTarget = new FilterSetHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeFilterSet((FilterSet)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllFilterSetSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<FilterSet> targets = InstrumentFilterSetSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllFilterSetSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearFilterSet(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadFilterSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadFilterSet((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadOtf(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadOtf(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfOtf(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfOtf(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyOtf(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<OTF> __ret = __obj.copyOtf(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentOtfSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addOTF(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        OTFHolder target = new OTFHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addOTF((OTF)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllOTFSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<OTF> targets = InstrumentOtfSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllOTFSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeOTF(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        OTFHolder theTarget = new OTFHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeOTF((OTF)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllOTFSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<OTF> targets = InstrumentOtfSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllOTFSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearOtf(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearOtf(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadOtf(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadOtf((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unloadAnnotationLinks(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.unloadAnnotationLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___sizeOfAnnotationLinks(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        int __ret = __obj.sizeOfAnnotationLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeInt(__ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___copyAnnotationLinks(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<InstrumentAnnotationLink> __ret = __obj.copyAnnotationLinks(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addInstrumentAnnotationLink(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentAnnotationLinkHolder target = new InstrumentAnnotationLinkHolder();
        __is.readObject(target);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addInstrumentAnnotationLink((InstrumentAnnotationLink)target.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addAllInstrumentAnnotationLinkSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<InstrumentAnnotationLink> targets = InstrumentAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addAllInstrumentAnnotationLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeInstrumentAnnotationLink(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentAnnotationLinkHolder theTarget = new InstrumentAnnotationLinkHolder();
        __is.readObject(theTarget);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeInstrumentAnnotationLink((InstrumentAnnotationLink)theTarget.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeAllInstrumentAnnotationLinkSet(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        List<InstrumentAnnotationLink> targets = InstrumentAnnotationLinksSeqHelper.read(__is);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeAllInstrumentAnnotationLinkSet(targets, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___clearAnnotationLinks(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        __obj.clearAnnotationLinks(__current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___reloadAnnotationLinks(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentHolder toCopy = new InstrumentHolder();
        __is.readObject(toCopy);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.reloadAnnotationLinks((Instrument)toCopy.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getAnnotationLinksCountPerOwner(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        Map<Long, Long> __ret = __obj.getAnnotationLinksCountPerOwner(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        CountMapHelper.write(__os, __ret);
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkAnnotation(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder addition = new AnnotationHolder();
        __is.readObject(addition);
        __is.readPendingObjects();
        __inS.endReadParams();
        InstrumentAnnotationLink __ret = __obj.linkAnnotation((Annotation)addition.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject(__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___addInstrumentAnnotationLinkToBoth(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentAnnotationLinkHolder link = new InstrumentAnnotationLinkHolder();
        __is.readObject(link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.addInstrumentAnnotationLinkToBoth((InstrumentAnnotationLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___findInstrumentAnnotationLink(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject(removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        List<InstrumentAnnotationLink> __ret = __obj.findInstrumentAnnotationLink((Annotation)removal.value, __current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentAnnotationLinksSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___unlinkAnnotation(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        AnnotationHolder removal = new AnnotationHolder();
        __is.readObject(removal);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.unlinkAnnotation((Annotation)removal.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___removeInstrumentAnnotationLinkFromBoth(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        BasicStream __is = __inS.startReadParams();
        InstrumentAnnotationLinkHolder link = new InstrumentAnnotationLinkHolder();
        __is.readObject(link);
        boolean bothSides = __is.readBool();
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.removeInstrumentAnnotationLinkFromBoth((InstrumentAnnotationLink)link.value, bothSides, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___linkedAnnotationList(Instrument __obj, Incoming __inS, Current __current) {
        Instrument.__checkMode(OperationMode.Normal, __current.mode);
        __inS.readEmptyParams();
        List<Annotation> __ret = __obj.linkedAnnotationList(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        InstrumentLinkedAnnotationSeqHelper.write(__os, __ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return Instrument.___addAllDetectorSet(this, in, __current);
            }
            case 1: {
                return Instrument.___addAllDichroicSet(this, in, __current);
            }
            case 2: {
                return Instrument.___addAllFilterSet(this, in, __current);
            }
            case 3: {
                return Instrument.___addAllFilterSetSet(this, in, __current);
            }
            case 4: {
                return Instrument.___addAllInstrumentAnnotationLinkSet(this, in, __current);
            }
            case 5: {
                return Instrument.___addAllLightSourceSet(this, in, __current);
            }
            case 6: {
                return Instrument.___addAllOTFSet(this, in, __current);
            }
            case 7: {
                return Instrument.___addAllObjectiveSet(this, in, __current);
            }
            case 8: {
                return Instrument.___addDetector(this, in, __current);
            }
            case 9: {
                return Instrument.___addDichroic(this, in, __current);
            }
            case 10: {
                return Instrument.___addFilter(this, in, __current);
            }
            case 11: {
                return Instrument.___addFilterSet(this, in, __current);
            }
            case 12: {
                return Instrument.___addInstrumentAnnotationLink(this, in, __current);
            }
            case 13: {
                return Instrument.___addInstrumentAnnotationLinkToBoth(this, in, __current);
            }
            case 14: {
                return Instrument.___addLightSource(this, in, __current);
            }
            case 15: {
                return Instrument.___addOTF(this, in, __current);
            }
            case 16: {
                return Instrument.___addObjective(this, in, __current);
            }
            case 17: {
                return Instrument.___clearAnnotationLinks(this, in, __current);
            }
            case 18: {
                return Instrument.___clearDetector(this, in, __current);
            }
            case 19: {
                return Instrument.___clearDichroic(this, in, __current);
            }
            case 20: {
                return Instrument.___clearFilter(this, in, __current);
            }
            case 21: {
                return Instrument.___clearFilterSet(this, in, __current);
            }
            case 22: {
                return Instrument.___clearLightSource(this, in, __current);
            }
            case 23: {
                return Instrument.___clearObjective(this, in, __current);
            }
            case 24: {
                return Instrument.___clearOtf(this, in, __current);
            }
            case 25: {
                return Instrument.___copyAnnotationLinks(this, in, __current);
            }
            case 26: {
                return Instrument.___copyDetector(this, in, __current);
            }
            case 27: {
                return Instrument.___copyDichroic(this, in, __current);
            }
            case 28: {
                return Instrument.___copyFilter(this, in, __current);
            }
            case 29: {
                return Instrument.___copyFilterSet(this, in, __current);
            }
            case 30: {
                return Instrument.___copyLightSource(this, in, __current);
            }
            case 31: {
                return Instrument.___copyObjective(this, in, __current);
            }
            case 32: {
                return Instrument.___copyOtf(this, in, __current);
            }
            case 33: {
                return Instrument.___findInstrumentAnnotationLink(this, in, __current);
            }
            case 34: {
                return Instrument.___getAnnotationLinksCountPerOwner(this, in, __current);
            }
            case 35: {
                return IObject.___getDetails(this, in, __current);
            }
            case 36: {
                return IObject.___getId(this, in, __current);
            }
            case 37: {
                return Instrument.___getMicroscope(this, in, __current);
            }
            case 38: {
                return Instrument.___getVersion(this, in, __current);
            }
            case 39: {
                return Instrument.___ice_id(this, in, __current);
            }
            case 40: {
                return Instrument.___ice_ids(this, in, __current);
            }
            case 41: {
                return Instrument.___ice_isA(this, in, __current);
            }
            case 42: {
                return Instrument.___ice_ping(this, in, __current);
            }
            case 43: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 44: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 45: {
                return IObject.___isLink(this, in, __current);
            }
            case 46: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 47: {
                return IObject.___isMutable(this, in, __current);
            }
            case 48: {
                return Instrument.___linkAnnotation(this, in, __current);
            }
            case 49: {
                return Instrument.___linkedAnnotationList(this, in, __current);
            }
            case 50: {
                return IObject.___proxy(this, in, __current);
            }
            case 51: {
                return Instrument.___reloadAnnotationLinks(this, in, __current);
            }
            case 52: {
                return Instrument.___reloadDetector(this, in, __current);
            }
            case 53: {
                return Instrument.___reloadDichroic(this, in, __current);
            }
            case 54: {
                return Instrument.___reloadFilter(this, in, __current);
            }
            case 55: {
                return Instrument.___reloadFilterSet(this, in, __current);
            }
            case 56: {
                return Instrument.___reloadLightSource(this, in, __current);
            }
            case 57: {
                return Instrument.___reloadObjective(this, in, __current);
            }
            case 58: {
                return Instrument.___reloadOtf(this, in, __current);
            }
            case 59: {
                return Instrument.___removeAllDetectorSet(this, in, __current);
            }
            case 60: {
                return Instrument.___removeAllDichroicSet(this, in, __current);
            }
            case 61: {
                return Instrument.___removeAllFilterSet(this, in, __current);
            }
            case 62: {
                return Instrument.___removeAllFilterSetSet(this, in, __current);
            }
            case 63: {
                return Instrument.___removeAllInstrumentAnnotationLinkSet(this, in, __current);
            }
            case 64: {
                return Instrument.___removeAllLightSourceSet(this, in, __current);
            }
            case 65: {
                return Instrument.___removeAllOTFSet(this, in, __current);
            }
            case 66: {
                return Instrument.___removeAllObjectiveSet(this, in, __current);
            }
            case 67: {
                return Instrument.___removeDetector(this, in, __current);
            }
            case 68: {
                return Instrument.___removeDichroic(this, in, __current);
            }
            case 69: {
                return Instrument.___removeFilter(this, in, __current);
            }
            case 70: {
                return Instrument.___removeFilterSet(this, in, __current);
            }
            case 71: {
                return Instrument.___removeInstrumentAnnotationLink(this, in, __current);
            }
            case 72: {
                return Instrument.___removeInstrumentAnnotationLinkFromBoth(this, in, __current);
            }
            case 73: {
                return Instrument.___removeLightSource(this, in, __current);
            }
            case 74: {
                return Instrument.___removeOTF(this, in, __current);
            }
            case 75: {
                return Instrument.___removeObjective(this, in, __current);
            }
            case 76: {
                return IObject.___setId(this, in, __current);
            }
            case 77: {
                return Instrument.___setMicroscope(this, in, __current);
            }
            case 78: {
                return Instrument.___setVersion(this, in, __current);
            }
            case 79: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 80: {
                return Instrument.___sizeOfAnnotationLinks(this, in, __current);
            }
            case 81: {
                return Instrument.___sizeOfDetector(this, in, __current);
            }
            case 82: {
                return Instrument.___sizeOfDichroic(this, in, __current);
            }
            case 83: {
                return Instrument.___sizeOfFilter(this, in, __current);
            }
            case 84: {
                return Instrument.___sizeOfFilterSet(this, in, __current);
            }
            case 85: {
                return Instrument.___sizeOfLightSource(this, in, __current);
            }
            case 86: {
                return Instrument.___sizeOfObjective(this, in, __current);
            }
            case 87: {
                return Instrument.___sizeOfOtf(this, in, __current);
            }
            case 88: {
                return Instrument.___unlinkAnnotation(this, in, __current);
            }
            case 89: {
                return IObject.___unload(this, in, __current);
            }
            case 90: {
                return Instrument.___unloadAnnotationLinks(this, in, __current);
            }
            case 91: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 92: {
                return IObject.___unloadDetails(this, in, __current);
            }
            case 93: {
                return Instrument.___unloadDetector(this, in, __current);
            }
            case 94: {
                return Instrument.___unloadDichroic(this, in, __current);
            }
            case 95: {
                return Instrument.___unloadFilter(this, in, __current);
            }
            case 96: {
                return Instrument.___unloadFilterSet(this, in, __current);
            }
            case 97: {
                return Instrument.___unloadLightSource(this, in, __current);
            }
            case 98: {
                return Instrument.___unloadObjective(this, in, __current);
            }
            case 99: {
                return Instrument.___unloadOtf(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    protected void __writeImpl(BasicStream __os) {
        __os.startWriteSlice(Instrument.ice_staticId(), -1, false);
        __os.writeObject(this.version);
        __os.writeObject(this.microscope);
        InstrumentDetectorSeqHelper.write(__os, this.detectorSeq);
        __os.writeBool(this.detectorLoaded);
        InstrumentObjectiveSeqHelper.write(__os, this.objectiveSeq);
        __os.writeBool(this.objectiveLoaded);
        InstrumentLightSourceSeqHelper.write(__os, this.lightSourceSeq);
        __os.writeBool(this.lightSourceLoaded);
        InstrumentFilterSeqHelper.write(__os, this.filterSeq);
        __os.writeBool(this.filterLoaded);
        InstrumentDichroicSeqHelper.write(__os, this.dichroicSeq);
        __os.writeBool(this.dichroicLoaded);
        InstrumentFilterSetSeqHelper.write(__os, this.filterSetSeq);
        __os.writeBool(this.filterSetLoaded);
        InstrumentOtfSeqHelper.write(__os, this.otfSeq);
        __os.writeBool(this.otfLoaded);
        InstrumentAnnotationLinksSeqHelper.write(__os, this.annotationLinksSeq);
        __os.writeBool(this.annotationLinksLoaded);
        CountMapHelper.write(__os, this.annotationLinksCountPerOwner);
        __os.endWriteSlice();
        super.__writeImpl(__os);
    }

    @Override
    protected void __readImpl(BasicStream __is) {
        __is.startReadSlice();
        __is.readObject(new Patcher(0));
        __is.readObject(new Patcher(1));
        this.detectorSeq = InstrumentDetectorSeqHelper.read(__is);
        this.detectorLoaded = __is.readBool();
        this.objectiveSeq = InstrumentObjectiveSeqHelper.read(__is);
        this.objectiveLoaded = __is.readBool();
        this.lightSourceSeq = InstrumentLightSourceSeqHelper.read(__is);
        this.lightSourceLoaded = __is.readBool();
        this.filterSeq = InstrumentFilterSeqHelper.read(__is);
        this.filterLoaded = __is.readBool();
        this.dichroicSeq = InstrumentDichroicSeqHelper.read(__is);
        this.dichroicLoaded = __is.readBool();
        this.filterSetSeq = InstrumentFilterSetSeqHelper.read(__is);
        this.filterSetLoaded = __is.readBool();
        this.otfSeq = InstrumentOtfSeqHelper.read(__is);
        this.otfLoaded = __is.readBool();
        this.annotationLinksSeq = InstrumentAnnotationLinksSeqHelper.read(__is);
        this.annotationLinksLoaded = __is.readBool();
        this.annotationLinksCountPerOwner = CountMapHelper.read(__is);
        __is.endReadSlice();
        super.__readImpl(__is);
    }

    @Override
    public Instrument clone() {
        return (Instrument)super.clone();
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        @Override
        public void patch(Ice.Object v) {
            switch (this.__member) {
                case 0: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        Instrument.this.version = (RInt)v;
                        break;
                    }
                    Ex.throwUOE(this.type(), v);
                    break;
                }
                case 1: {
                    this.__typeId = "::omero::model::Microscope";
                    if (v == null || v instanceof Microscope) {
                        Instrument.this.microscope = (Microscope)v;
                        break;
                    }
                    Ex.throwUOE(this.type(), v);
                }
            }
        }

        @Override
        public String type() {
            return this.__typeId;
        }
    }
}

