/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.ImagingEnvironment;
import omero.model.NamedValue;
import omero.model.Pressure;
import omero.model.Temperature;
import omero.rtypes;
import omero.util.IceMapper;

public class ImagingEnvironmentI
extends ImagingEnvironment
implements ModelBased {
    public static final String TEMPERATURE = "ome.model.acquisition.ImagingEnvironment_temperature";
    public static final String AIRPRESSURE = "ome.model.acquisition.ImagingEnvironment_airPressure";
    public static final String HUMIDITY = "ome.model.acquisition.ImagingEnvironment_humidity";
    public static final String CO2PERCENT = "ome.model.acquisition.ImagingEnvironment_co2percent";
    public static final String MAP = "ome.model.acquisition.ImagingEnvironment_map";
    public static final String DETAILS = "ome.model.acquisition.ImagingEnvironment_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public ImagingEnvironmentI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ImagingEnvironmentI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ImagingEnvironmentI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadTemperature();
        this.unloadAirPressure();
        this.unloadHumidity();
        this.unloadCo2percent();
        this.unloadMap();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ImagingEnvironmentI copy = new ImagingEnvironmentI();
        copy.id = this.id;
        copy.version = this.version;
        copy.temperature = this.temperature == null ? null : this.temperature.copy();
        copy.airPressure = this.airPressure == null ? null : this.airPressure.copy();
        copy.humidity = this.humidity;
        copy.co2percent = this.co2percent;
        copy.map = this.map;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ImagingEnvironmentI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadTemperature() {
        this.temperature = null;
    }

    @Override
    public Temperature getTemperature(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.temperature;
    }

    @Override
    public void setTemperature(Temperature temperature, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.temperature = temperature;
    }

    private void copyTemperature(ome.model.acquisition.ImagingEnvironment source, IceMapper mapper) {
        this.temperature = (Temperature)mapper.findTarget(source.getTemperature());
    }

    private void fillTemperature(ome.model.acquisition.ImagingEnvironment target, IceMapper mapper) {
        target.putAt(TEMPERATURE, mapper.reverse((ModelBased)((Object)this.getTemperature())));
    }

    public void unloadAirPressure() {
        this.airPressure = null;
    }

    @Override
    public Pressure getAirPressure(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.airPressure;
    }

    @Override
    public void setAirPressure(Pressure airPressure, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.airPressure = airPressure;
    }

    private void copyAirPressure(ome.model.acquisition.ImagingEnvironment source, IceMapper mapper) {
        this.airPressure = (Pressure)mapper.findTarget(source.getAirPressure());
    }

    private void fillAirPressure(ome.model.acquisition.ImagingEnvironment target, IceMapper mapper) {
        target.putAt(AIRPRESSURE, mapper.reverse((ModelBased)((Object)this.getAirPressure())));
    }

    public void unloadHumidity() {
        this.humidity = null;
    }

    @Override
    public RDouble getHumidity(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.humidity;
    }

    @Override
    public void setHumidity(RDouble humidity, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.humidity = humidity;
    }

    private void copyHumidity(ome.model.acquisition.ImagingEnvironment source, IceMapper mapper) {
        this.humidity = source.getHumidity() == null ? null : rtypes.rdouble(source.getHumidity());
    }

    private void fillHumidity(ome.model.acquisition.ImagingEnvironment target, IceMapper mapper) {
        try {
            target.setHumidity((Double)mapper.fromRType(this.getHumidity()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadCo2percent() {
        this.co2percent = null;
    }

    @Override
    public RDouble getCo2percent(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.co2percent;
    }

    @Override
    public void setCo2percent(RDouble co2percent, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.co2percent = co2percent;
    }

    private void copyCo2percent(ome.model.acquisition.ImagingEnvironment source, IceMapper mapper) {
        this.co2percent = source.getCo2percent() == null ? null : rtypes.rdouble(source.getCo2percent());
    }

    private void fillCo2percent(ome.model.acquisition.ImagingEnvironment target, IceMapper mapper) {
        try {
            target.setCo2percent((Double)mapper.fromRType(this.getCo2percent()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadMap() {
        this.map = null;
    }

    @Override
    public List<NamedValue> getMap(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.map;
    }

    @Override
    public Map<String, String> getMapAsMap(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        HashMap<String, String> rv = new HashMap<String, String>();
        for (NamedValue nv : this.map) {
            if (nv == null) continue;
            rv.put(nv.name, nv.value);
        }
        return rv;
    }

    @Override
    public void setMap(List<NamedValue> map, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.map = map;
    }

    private void copyMap(ome.model.acquisition.ImagingEnvironment source, IceMapper mapper) {
        this.map = IceMapper.convertNamedValueList(source.getMap());
    }

    private void fillMap(ome.model.acquisition.ImagingEnvironment target, IceMapper mapper) {
        target.setMap(IceMapper.reverseNamedList(this.getMap()));
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.ImagingEnvironment) {
            ome.model.acquisition.ImagingEnvironment source = (ome.model.acquisition.ImagingEnvironment)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyTemperature(source, mapper);
                this.copyAirPressure(source, mapper);
                this.copyHumidity(source, mapper);
                this.copyCo2percent(source, mapper);
                this.copyMap(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("ImagingEnvironment cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.ImagingEnvironment target = new ome.model.acquisition.ImagingEnvironment();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillTemperature(target, mapper);
            this.fillAirPressure(target, mapper);
            this.fillHumidity(target, mapper);
            this.fillCo2percent(target, mapper);
            this.fillMap(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<ImagingEnvironmentI> cast(List list) {
        return list;
    }
}

