/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Fileset;
import omero.model.FilesetAnnotationLink;
import omero.model.FilesetAnnotationLinkI;
import omero.model.FilesetEntry;
import omero.model.FilesetJobLink;
import omero.model.FilesetJobLinkI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Job;
import omero.rtypes;
import omero.util.IceMapper;

public class FilesetI
extends Fileset
implements ModelBased {
    public static final String USEDFILES = "ome.model.fs.Fileset_usedFiles";
    public static final String IMAGES = "ome.model.fs.Fileset_images";
    public static final String JOBLINKS = "ome.model.fs.Fileset_jobLinks";
    public static final String TEMPLATEPREFIX = "ome.model.fs.Fileset_templatePrefix";
    public static final String ANNOTATIONLINKS = "ome.model.fs.Fileset_annotationLinks";
    public static final String DETAILS = "ome.model.fs.Fileset_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.usedFilesSeq = new ArrayList();
            this.usedFilesLoaded = true;
        } else {
            this.usedFilesSeq = null;
            this.usedFilesLoaded = false;
        }
        if (load) {
            this.imagesSeq = new ArrayList();
            this.imagesLoaded = true;
        } else {
            this.imagesSeq = null;
            this.imagesLoaded = false;
        }
        if (load) {
            this.jobLinksSeq = new ArrayList();
            this.jobLinksLoaded = true;
        } else {
            this.jobLinksSeq = null;
            this.jobLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public FilesetI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public FilesetI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public FilesetI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadUsedFiles();
        this.unloadImages();
        this.unloadJobLinks();
        this.unloadTemplatePrefix();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        FilesetI copy = new FilesetI();
        copy.id = this.id;
        copy.version = this.version;
        if (!this.usedFilesLoaded) {
            copy.usedFilesLoaded = false;
            copy.usedFilesSeq = null;
        } else {
            copy.usedFilesLoaded = true;
            copy.usedFilesSeq = new ArrayList<FilesetEntry>();
            for (IObject item : this.usedFilesSeq) {
                copy.usedFilesSeq.add(item == null ? null : (FilesetEntry)item.proxy());
            }
        }
        if (!this.imagesLoaded) {
            copy.imagesLoaded = false;
            copy.imagesSeq = null;
        } else {
            copy.imagesLoaded = true;
            copy.imagesSeq = new ArrayList<Image>();
            for (IObject item : this.imagesSeq) {
                copy.imagesSeq.add(item == null ? null : (Image)item.proxy());
            }
        }
        if (!this.jobLinksLoaded) {
            copy.jobLinksLoaded = false;
            copy.jobLinksSeq = null;
        } else {
            copy.jobLinksLoaded = true;
            copy.jobLinksSeq = new ArrayList<FilesetJobLink>();
            for (IObject item : this.jobLinksSeq) {
                copy.jobLinksSeq.add(item == null ? null : (FilesetJobLink)item.proxy());
            }
        }
        copy.templatePrefix = this.templatePrefix;
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<FilesetAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (FilesetAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new FilesetI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    @Override
    public void unloadUsedFiles(Current current) {
        this.usedFilesLoaded = false;
        this.usedFilesSeq = null;
    }

    protected List getUsedFiles(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.usedFilesSeq;
    }

    protected void setUsedFiles(List usedFiles, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.usedFilesSeq = usedFiles == null ? new ArrayList() : new ArrayList(usedFiles);
        this.usedFilesLoaded = usedFiles != null;
    }

    private void copyUsedFiles(ome.model.fs.Fileset source, IceMapper mapper) {
        this.setUsedFiles((List)mapper.findCollection((Collection)source.retrieve(USEDFILES)), null);
    }

    private void fillUsedFiles(ome.model.fs.Fileset target, IceMapper mapper) {
        if (this.usedFilesLoaded) {
            target.putAt(USEDFILES, mapper.reverse(this.usedFilesSeq, List.class));
        } else {
            target.putAt(USEDFILES, null);
        }
    }

    public boolean isUsedFilesLoaded() {
        return this.usedFilesLoaded;
    }

    @Override
    public int sizeOfUsedFiles(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            return -1;
        }
        return this.usedFilesSeq.size();
    }

    public List copyUsedFiles(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        ArrayList result = new ArrayList(this.usedFilesSeq);
        return result;
    }

    public Iterator iterateUsedFiles() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        return this.usedFilesSeq.iterator();
    }

    @Override
    public void addFilesetEntry(FilesetEntry target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        this.usedFilesSeq.add(target);
        target.setFileset(this);
    }

    @Override
    public void addAllFilesetEntrySet(List<FilesetEntry> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        this.usedFilesSeq.addAll(targets);
        for (FilesetEntry target : targets) {
            target.setFileset(this);
        }
    }

    @Override
    public void removeFilesetEntry(FilesetEntry target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        this.usedFilesSeq.remove(target);
        target.setFileset(null);
    }

    @Override
    public void removeAllFilesetEntrySet(List<FilesetEntry> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        for (FilesetEntry elt : targets) {
            elt.setFileset(null);
            this.usedFilesSeq.remove(elt);
        }
    }

    @Override
    public void clearUsedFiles(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        for (FilesetEntry elt : this.usedFilesSeq) {
            elt.setFileset(null);
        }
        this.usedFilesSeq.clear();
    }

    @Override
    public void reloadUsedFiles(Fileset toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.usedFilesLoaded) {
            throw new ClientError("Cannot reload active collection: usedFilesSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FilesetEntry> copy = toCopy.copyUsedFiles();
        for (FilesetEntry elt : copy) {
            elt.setFileset(this);
        }
        this.usedFilesSeq = new ArrayList<FilesetEntry>(copy);
        toCopy.unloadUsedFiles();
        this.usedFilesLoaded = true;
    }

    @Override
    public FilesetEntry getFilesetEntry(int index, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        return (FilesetEntry)this.usedFilesSeq.get(index);
    }

    @Override
    public FilesetEntry setFilesetEntry(int index, FilesetEntry element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        FilesetEntry old = this.usedFilesSeq.set(index, element);
        if (element != null && element.isLoaded()) {
            element.setFileset(this);
        }
        return old;
    }

    @Override
    public FilesetEntry getPrimaryFilesetEntry(Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        return (FilesetEntry)this.usedFilesSeq.get(0);
    }

    @Override
    public FilesetEntry setPrimaryFilesetEntry(FilesetEntry element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.usedFilesLoaded) {
            this.throwNullCollectionException("usedFilesSeq");
        }
        int index = this.usedFilesSeq.indexOf(element);
        FilesetEntry old = (FilesetEntry)this.usedFilesSeq.get(0);
        this.usedFilesSeq.set(index, old);
        this.usedFilesSeq.set(0, element);
        return old;
    }

    @Override
    public void unloadImages(Current current) {
        this.imagesLoaded = false;
        this.imagesSeq = null;
    }

    protected List getImages(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.imagesSeq;
    }

    protected void setImages(List images, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.imagesSeq = images == null ? new ArrayList() : new ArrayList(images);
        this.imagesLoaded = images != null;
    }

    private void copyImages(ome.model.fs.Fileset source, IceMapper mapper) {
        this.setImages((List)mapper.findCollection((Collection)source.retrieve(IMAGES)), null);
    }

    private void fillImages(ome.model.fs.Fileset target, IceMapper mapper) {
        if (this.imagesLoaded) {
            target.putAt(IMAGES, mapper.reverse(this.imagesSeq, Set.class));
        } else {
            target.putAt(IMAGES, null);
        }
    }

    public boolean isImagesLoaded() {
        return this.imagesLoaded;
    }

    @Override
    public int sizeOfImages(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            return -1;
        }
        return this.imagesSeq.size();
    }

    public List copyImages(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            this.throwNullCollectionException("imagesSeq");
        }
        ArrayList result = new ArrayList(this.imagesSeq);
        return result;
    }

    public Iterator iterateImages() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            this.throwNullCollectionException("imagesSeq");
        }
        return this.imagesSeq.iterator();
    }

    @Override
    public void addImage(Image target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            this.throwNullCollectionException("imagesSeq");
        }
        this.imagesSeq.add(target);
        target.setFileset(this);
    }

    @Override
    public void addAllImageSet(List<Image> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            this.throwNullCollectionException("imagesSeq");
        }
        this.imagesSeq.addAll(targets);
        for (Image target : targets) {
            target.setFileset(this);
        }
    }

    @Override
    public void removeImage(Image target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            this.throwNullCollectionException("imagesSeq");
        }
        this.imagesSeq.remove(target);
        target.setFileset(null);
    }

    @Override
    public void removeAllImageSet(List<Image> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            this.throwNullCollectionException("imagesSeq");
        }
        for (Image elt : targets) {
            elt.setFileset(null);
            this.imagesSeq.remove(elt);
        }
    }

    @Override
    public void clearImages(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imagesLoaded) {
            this.throwNullCollectionException("imagesSeq");
        }
        for (Image elt : this.imagesSeq) {
            elt.setFileset(null);
        }
        this.imagesSeq.clear();
    }

    @Override
    public void reloadImages(Fileset toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.imagesLoaded) {
            throw new ClientError("Cannot reload active collection: imagesSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Image> copy = toCopy.copyImages();
        for (Image elt : copy) {
            elt.setFileset(this);
        }
        this.imagesSeq = new ArrayList<Image>(copy);
        toCopy.unloadImages();
        this.imagesLoaded = true;
    }

    @Override
    public void unloadJobLinks(Current current) {
        this.jobLinksLoaded = false;
        this.jobLinksSeq = null;
    }

    protected List getJobLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.jobLinksSeq;
    }

    protected void setJobLinks(List jobLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.jobLinksSeq = jobLinks == null ? new ArrayList() : new ArrayList(jobLinks);
        this.jobLinksLoaded = jobLinks != null;
    }

    private void copyJobLinks(ome.model.fs.Fileset source, IceMapper mapper) {
        this.setJobLinks((List)mapper.findCollection((Collection)source.retrieve(JOBLINKS)), null);
        this.jobLinksCountPerOwner = source.getJobLinksCountPerOwner();
    }

    private void fillJobLinks(ome.model.fs.Fileset target, IceMapper mapper) {
        if (this.jobLinksLoaded) {
            target.putAt(JOBLINKS, mapper.reverse(this.jobLinksSeq, List.class));
        } else {
            target.putAt(JOBLINKS, null);
        }
    }

    public boolean isJobLinksLoaded() {
        return this.jobLinksLoaded;
    }

    @Override
    public int sizeOfJobLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            return -1;
        }
        return this.jobLinksSeq.size();
    }

    public List copyJobLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        ArrayList result = new ArrayList(this.jobLinksSeq);
        return result;
    }

    public Iterator iterateJobLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        return this.jobLinksSeq.iterator();
    }

    @Override
    public void addFilesetJobLink(FilesetJobLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        this.jobLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllFilesetJobLinkSet(List<FilesetJobLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        this.jobLinksSeq.addAll(targets);
        for (FilesetJobLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeFilesetJobLink(FilesetJobLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        this.jobLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllFilesetJobLinkSet(List<FilesetJobLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        for (FilesetJobLink elt : targets) {
            elt.setParent(null);
            this.jobLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearJobLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        for (FilesetJobLink elt : this.jobLinksSeq) {
            elt.setParent(null);
        }
        this.jobLinksSeq.clear();
    }

    @Override
    public void reloadJobLinks(Fileset toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.jobLinksLoaded) {
            throw new ClientError("Cannot reload active collection: jobLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FilesetJobLink> copy = toCopy.copyJobLinks();
        for (FilesetJobLink elt : copy) {
            elt.setParent(this);
        }
        this.jobLinksSeq = new ArrayList<FilesetJobLink>(copy);
        toCopy.unloadJobLinks();
        this.jobLinksLoaded = true;
    }

    @Override
    public FilesetJobLink getFilesetJobLink(int index, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        return (FilesetJobLink)this.jobLinksSeq.get(index);
    }

    @Override
    public FilesetJobLink setFilesetJobLink(int index, FilesetJobLink element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        FilesetJobLink old = this.jobLinksSeq.set(index, element);
        if (element != null && element.isLoaded()) {
            element.setParent(this);
        }
        return old;
    }

    @Override
    public FilesetJobLink getPrimaryFilesetJobLink(Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        return (FilesetJobLink)this.jobLinksSeq.get(0);
    }

    @Override
    public FilesetJobLink setPrimaryFilesetJobLink(FilesetJobLink element, Current current) throws IndexOutOfBoundsException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        int index = this.jobLinksSeq.indexOf(element);
        FilesetJobLink old = (FilesetJobLink)this.jobLinksSeq.get(0);
        this.jobLinksSeq.set(index, old);
        this.jobLinksSeq.set(0, element);
        return old;
    }

    @Override
    public Map<Long, Long> getJobLinksCountPerOwner(Current current) {
        return this.jobLinksCountPerOwner;
    }

    @Override
    public FilesetJobLink linkJob(Job addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        FilesetJobLinkI link = new FilesetJobLinkI();
        link.link(this, addition);
        this.addFilesetJobLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addFilesetJobLinkToBoth(FilesetJobLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        this.jobLinksSeq.add(link);
    }

    @Override
    public List<FilesetJobLink> findFilesetJobLink(Job removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        ArrayList<FilesetJobLink> result = new ArrayList<FilesetJobLink>();
        for (FilesetJobLink link : this.jobLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkJob(Job removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        List<FilesetJobLink> toRemove = this.findFilesetJobLink(removal);
        Iterator<FilesetJobLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilesetJobLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeFilesetJobLinkFromBoth(FilesetJobLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("jobLinksSeq");
        }
        this.jobLinksSeq.remove(link);
    }

    @Override
    public List<Job> linkedJobList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.jobLinksLoaded) {
            this.throwNullCollectionException("JobLinks");
        }
        ArrayList<Job> linked = new ArrayList<Job>();
        for (FilesetJobLink link : this.jobLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadTemplatePrefix() {
        this.templatePrefix = null;
    }

    @Override
    public RString getTemplatePrefix(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.templatePrefix;
    }

    @Override
    public void setTemplatePrefix(RString templatePrefix, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.templatePrefix = templatePrefix;
    }

    private void copyTemplatePrefix(ome.model.fs.Fileset source, IceMapper mapper) {
        this.templatePrefix = source.getTemplatePrefix() == null ? null : rtypes.rstring(source.getTemplatePrefix());
    }

    private void fillTemplatePrefix(ome.model.fs.Fileset target, IceMapper mapper) {
        try {
            target.setTemplatePrefix((String)mapper.fromRType(this.getTemplatePrefix()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.fs.Fileset source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.fs.Fileset target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addFilesetAnnotationLink(FilesetAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllFilesetAnnotationLinkSet(List<FilesetAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (FilesetAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeFilesetAnnotationLink(FilesetAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllFilesetAnnotationLinkSet(List<FilesetAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (FilesetAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (FilesetAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Fileset toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FilesetAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (FilesetAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<FilesetAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public FilesetAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        FilesetAnnotationLinkI link = new FilesetAnnotationLinkI();
        link.link(this, addition);
        this.addFilesetAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addFilesetAnnotationLinkToBoth(FilesetAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<FilesetAnnotationLink> findFilesetAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<FilesetAnnotationLink> result = new ArrayList<FilesetAnnotationLink>();
        for (FilesetAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<FilesetAnnotationLink> toRemove = this.findFilesetAnnotationLink(removal);
        Iterator<FilesetAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFilesetAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeFilesetAnnotationLinkFromBoth(FilesetAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (FilesetAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.fs.Fileset) {
            ome.model.fs.Fileset source = (ome.model.fs.Fileset)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyUsedFiles(source, mapper);
                this.copyImages(source, mapper);
                this.copyJobLinks(source, mapper);
                this.copyTemplatePrefix(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Fileset cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.fs.Fileset target = new ome.model.fs.Fileset();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillUsedFiles(target, mapper);
            this.fillImages(target, mapper);
            this.fillJobLinks(target, mapper);
            this.fillTemplatePrefix(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<FilesetI> cast(List list) {
        return list;
    }
}

