/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Experiment;
import omero.model.ExperimentType;
import omero.model.IObject;
import omero.model.MicrobeamManipulation;
import omero.rtypes;
import omero.util.IceMapper;

public class ExperimentI
extends Experiment
implements ModelBased {
    public static final String TYPE = "ome.model.experiment.Experiment_type";
    public static final String MICROBEAMMANIPULATION = "ome.model.experiment.Experiment_microbeamManipulation";
    public static final String DESCRIPTION = "ome.model.experiment.Experiment_description";
    public static final String DETAILS = "ome.model.experiment.Experiment_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.microbeamManipulationSeq = new ArrayList();
            this.microbeamManipulationLoaded = true;
        } else {
            this.microbeamManipulationSeq = null;
            this.microbeamManipulationLoaded = false;
        }
    }

    public ExperimentI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ExperimentI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ExperimentI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadType();
        this.unloadMicrobeamManipulation();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ExperimentI copy = new ExperimentI();
        copy.id = this.id;
        copy.version = this.version;
        ExperimentType experimentType = copy.type = this.type == null ? null : (ExperimentType)this.type.proxy();
        if (!this.microbeamManipulationLoaded) {
            copy.microbeamManipulationLoaded = false;
            copy.microbeamManipulationSeq = null;
        } else {
            copy.microbeamManipulationLoaded = true;
            copy.microbeamManipulationSeq = new ArrayList<MicrobeamManipulation>();
            for (MicrobeamManipulation item : this.microbeamManipulationSeq) {
                copy.microbeamManipulationSeq.add(item == null ? null : (MicrobeamManipulation)item.proxy());
            }
        }
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ExperimentI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public ExperimentType getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(ExperimentType type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.experiment.Experiment source, IceMapper mapper) {
        this.type = (ExperimentType)mapper.findTarget(source.getType());
    }

    private void fillType(ome.model.experiment.Experiment target, IceMapper mapper) {
        target.putAt(TYPE, mapper.reverse((ModelBased)((Object)this.getType())));
    }

    @Override
    public void unloadMicrobeamManipulation(Current current) {
        this.microbeamManipulationLoaded = false;
        this.microbeamManipulationSeq = null;
    }

    protected List getMicrobeamManipulation(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.microbeamManipulationSeq;
    }

    protected void setMicrobeamManipulation(List microbeamManipulation, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.microbeamManipulationSeq = microbeamManipulation == null ? new ArrayList() : new ArrayList(microbeamManipulation);
        this.microbeamManipulationLoaded = microbeamManipulation != null;
    }

    private void copyMicrobeamManipulation(ome.model.experiment.Experiment source, IceMapper mapper) {
        this.setMicrobeamManipulation((List)mapper.findCollection((Collection)source.retrieve(MICROBEAMMANIPULATION)), null);
    }

    private void fillMicrobeamManipulation(ome.model.experiment.Experiment target, IceMapper mapper) {
        if (this.microbeamManipulationLoaded) {
            target.putAt(MICROBEAMMANIPULATION, mapper.reverse(this.microbeamManipulationSeq, Set.class));
        } else {
            target.putAt(MICROBEAMMANIPULATION, null);
        }
    }

    public boolean isMicrobeamManipulationLoaded() {
        return this.microbeamManipulationLoaded;
    }

    @Override
    public int sizeOfMicrobeamManipulation(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            return -1;
        }
        return this.microbeamManipulationSeq.size();
    }

    public List copyMicrobeamManipulation(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            this.throwNullCollectionException("microbeamManipulationSeq");
        }
        ArrayList result = new ArrayList(this.microbeamManipulationSeq);
        return result;
    }

    public Iterator iterateMicrobeamManipulation() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            this.throwNullCollectionException("microbeamManipulationSeq");
        }
        return this.microbeamManipulationSeq.iterator();
    }

    @Override
    public void addMicrobeamManipulation(MicrobeamManipulation target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            this.throwNullCollectionException("microbeamManipulationSeq");
        }
        this.microbeamManipulationSeq.add(target);
        target.setExperiment(this);
    }

    @Override
    public void addAllMicrobeamManipulationSet(List<MicrobeamManipulation> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            this.throwNullCollectionException("microbeamManipulationSeq");
        }
        this.microbeamManipulationSeq.addAll(targets);
        for (MicrobeamManipulation target : targets) {
            target.setExperiment(this);
        }
    }

    @Override
    public void removeMicrobeamManipulation(MicrobeamManipulation target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            this.throwNullCollectionException("microbeamManipulationSeq");
        }
        this.microbeamManipulationSeq.remove(target);
        target.setExperiment(null);
    }

    @Override
    public void removeAllMicrobeamManipulationSet(List<MicrobeamManipulation> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            this.throwNullCollectionException("microbeamManipulationSeq");
        }
        for (MicrobeamManipulation elt : targets) {
            elt.setExperiment(null);
            this.microbeamManipulationSeq.remove(elt);
        }
    }

    @Override
    public void clearMicrobeamManipulation(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.microbeamManipulationLoaded) {
            this.throwNullCollectionException("microbeamManipulationSeq");
        }
        for (MicrobeamManipulation elt : this.microbeamManipulationSeq) {
            elt.setExperiment(null);
        }
        this.microbeamManipulationSeq.clear();
    }

    @Override
    public void reloadMicrobeamManipulation(Experiment toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.microbeamManipulationLoaded) {
            throw new ClientError("Cannot reload active collection: microbeamManipulationSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<MicrobeamManipulation> copy = toCopy.copyMicrobeamManipulation();
        for (MicrobeamManipulation elt : copy) {
            elt.setExperiment(this);
        }
        this.microbeamManipulationSeq = new ArrayList<MicrobeamManipulation>(copy);
        toCopy.unloadMicrobeamManipulation();
        this.microbeamManipulationLoaded = true;
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.experiment.Experiment source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.experiment.Experiment target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.experiment.Experiment) {
            ome.model.experiment.Experiment source = (ome.model.experiment.Experiment)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyType(source, mapper);
                this.copyMicrobeamManipulation(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Experiment cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.experiment.Experiment target = new ome.model.experiment.Experiment();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillType(target, mapper);
            this.fillMicrobeamManipulation(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<ExperimentI> cast(List list) {
        return list;
    }
}

