/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RDouble;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Detector;
import omero.model.DetectorAnnotationLink;
import omero.model.DetectorAnnotationLinkI;
import omero.model.DetectorType;
import omero.model.ElectricPotential;
import omero.model.IObject;
import omero.model.Instrument;
import omero.rtypes;
import omero.util.IceMapper;

public class DetectorI
extends Detector
implements ModelBased {
    public static final String MANUFACTURER = "ome.model.acquisition.Detector_manufacturer";
    public static final String MODEL = "ome.model.acquisition.Detector_model";
    public static final String LOTNUMBER = "ome.model.acquisition.Detector_lotNumber";
    public static final String SERIALNUMBER = "ome.model.acquisition.Detector_serialNumber";
    public static final String VOLTAGE = "ome.model.acquisition.Detector_voltage";
    public static final String GAIN = "ome.model.acquisition.Detector_gain";
    public static final String OFFSETVALUE = "ome.model.acquisition.Detector_offsetValue";
    public static final String ZOOM = "ome.model.acquisition.Detector_zoom";
    public static final String AMPLIFICATIONGAIN = "ome.model.acquisition.Detector_amplificationGain";
    public static final String TYPE = "ome.model.acquisition.Detector_type";
    public static final String INSTRUMENT = "ome.model.acquisition.Detector_instrument";
    public static final String ANNOTATIONLINKS = "ome.model.acquisition.Detector_annotationLinks";
    public static final String DETAILS = "ome.model.acquisition.Detector_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public DetectorI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public DetectorI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public DetectorI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadManufacturer();
        this.unloadModel();
        this.unloadLotNumber();
        this.unloadSerialNumber();
        this.unloadVoltage();
        this.unloadGain();
        this.unloadOffsetValue();
        this.unloadZoom();
        this.unloadAmplificationGain();
        this.unloadType();
        this.unloadInstrument();
        this.unloadAnnotationLinks();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        DetectorI copy = new DetectorI();
        copy.id = this.id;
        copy.version = this.version;
        copy.manufacturer = this.manufacturer;
        copy.model = this.model;
        copy.lotNumber = this.lotNumber;
        copy.serialNumber = this.serialNumber;
        copy.voltage = this.voltage == null ? null : this.voltage.copy();
        copy.gain = this.gain;
        copy.offsetValue = this.offsetValue;
        copy.zoom = this.zoom;
        copy.amplificationGain = this.amplificationGain;
        copy.type = this.type == null ? null : (DetectorType)this.type.proxy();
        Instrument instrument = copy.instrument = this.instrument == null ? null : (Instrument)this.instrument.proxy();
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<DetectorAnnotationLink>();
            for (DetectorAnnotationLink item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (DetectorAnnotationLink)item.proxy());
            }
        }
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new DetectorI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadManufacturer() {
        this.manufacturer = null;
    }

    @Override
    public RString getManufacturer(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(RString manufacturer, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.manufacturer = manufacturer;
    }

    private void copyManufacturer(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.manufacturer = source.getManufacturer() == null ? null : rtypes.rstring(source.getManufacturer());
    }

    private void fillManufacturer(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setManufacturer((String)mapper.fromRType(this.getManufacturer()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadModel() {
        this.model = null;
    }

    @Override
    public RString getModel(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.model;
    }

    @Override
    public void setModel(RString model, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.model = model;
    }

    private void copyModel(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.model = source.getModel() == null ? null : rtypes.rstring(source.getModel());
    }

    private void fillModel(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setModel((String)mapper.fromRType(this.getModel()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadLotNumber() {
        this.lotNumber = null;
    }

    @Override
    public RString getLotNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.lotNumber;
    }

    @Override
    public void setLotNumber(RString lotNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.lotNumber = lotNumber;
    }

    private void copyLotNumber(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.lotNumber = source.getLotNumber() == null ? null : rtypes.rstring(source.getLotNumber());
    }

    private void fillLotNumber(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setLotNumber((String)mapper.fromRType(this.getLotNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadSerialNumber() {
        this.serialNumber = null;
    }

    @Override
    public RString getSerialNumber(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.serialNumber;
    }

    @Override
    public void setSerialNumber(RString serialNumber, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.serialNumber = serialNumber;
    }

    private void copySerialNumber(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.serialNumber = source.getSerialNumber() == null ? null : rtypes.rstring(source.getSerialNumber());
    }

    private void fillSerialNumber(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setSerialNumber((String)mapper.fromRType(this.getSerialNumber()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadVoltage() {
        this.voltage = null;
    }

    @Override
    public ElectricPotential getVoltage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.voltage;
    }

    @Override
    public void setVoltage(ElectricPotential voltage, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.voltage = voltage;
    }

    private void copyVoltage(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.voltage = (ElectricPotential)mapper.findTarget(source.getVoltage());
    }

    private void fillVoltage(ome.model.acquisition.Detector target, IceMapper mapper) {
        target.putAt(VOLTAGE, mapper.reverse((ModelBased)((Object)this.getVoltage())));
    }

    public void unloadGain() {
        this.gain = null;
    }

    @Override
    public RDouble getGain(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.gain;
    }

    @Override
    public void setGain(RDouble gain, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.gain = gain;
    }

    private void copyGain(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.gain = source.getGain() == null ? null : rtypes.rdouble(source.getGain());
    }

    private void fillGain(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setGain((Double)mapper.fromRType(this.getGain()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadOffsetValue() {
        this.offsetValue = null;
    }

    @Override
    public RDouble getOffsetValue(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.offsetValue;
    }

    @Override
    public void setOffsetValue(RDouble offsetValue, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.offsetValue = offsetValue;
    }

    private void copyOffsetValue(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.offsetValue = source.getOffsetValue() == null ? null : rtypes.rdouble(source.getOffsetValue());
    }

    private void fillOffsetValue(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setOffsetValue((Double)mapper.fromRType(this.getOffsetValue()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadZoom() {
        this.zoom = null;
    }

    @Override
    public RDouble getZoom(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.zoom;
    }

    @Override
    public void setZoom(RDouble zoom, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.zoom = zoom;
    }

    private void copyZoom(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.zoom = source.getZoom() == null ? null : rtypes.rdouble(source.getZoom());
    }

    private void fillZoom(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setZoom((Double)mapper.fromRType(this.getZoom()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadAmplificationGain() {
        this.amplificationGain = null;
    }

    @Override
    public RDouble getAmplificationGain(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.amplificationGain;
    }

    @Override
    public void setAmplificationGain(RDouble amplificationGain, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.amplificationGain = amplificationGain;
    }

    private void copyAmplificationGain(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.amplificationGain = source.getAmplificationGain() == null ? null : rtypes.rdouble(source.getAmplificationGain());
    }

    private void fillAmplificationGain(ome.model.acquisition.Detector target, IceMapper mapper) {
        try {
            target.setAmplificationGain((Double)mapper.fromRType(this.getAmplificationGain()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadType() {
        this.type = null;
    }

    @Override
    public DetectorType getType(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.type;
    }

    @Override
    public void setType(DetectorType type, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.type = type;
    }

    private void copyType(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.type = (DetectorType)mapper.findTarget(source.getType());
    }

    private void fillType(ome.model.acquisition.Detector target, IceMapper mapper) {
        target.putAt(TYPE, mapper.reverse((ModelBased)((Object)this.getType())));
    }

    public void unloadInstrument() {
        this.instrument = null;
    }

    @Override
    public Instrument getInstrument(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.instrument;
    }

    @Override
    public void setInstrument(Instrument instrument, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.instrument = instrument;
    }

    private void copyInstrument(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.instrument = (Instrument)mapper.findTarget(source.getInstrument());
    }

    private void fillInstrument(ome.model.acquisition.Detector target, IceMapper mapper) {
        target.putAt(INSTRUMENT, mapper.reverse((ModelBased)((Object)this.getInstrument())));
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.acquisition.Detector source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.acquisition.Detector target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addDetectorAnnotationLink(DetectorAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllDetectorAnnotationLinkSet(List<DetectorAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (DetectorAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeDetectorAnnotationLink(DetectorAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllDetectorAnnotationLinkSet(List<DetectorAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (DetectorAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (DetectorAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Detector toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<DetectorAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (DetectorAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<DetectorAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public DetectorAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        DetectorAnnotationLinkI link = new DetectorAnnotationLinkI();
        link.link(this, addition);
        this.addDetectorAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addDetectorAnnotationLinkToBoth(DetectorAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<DetectorAnnotationLink> findDetectorAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<DetectorAnnotationLink> result = new ArrayList<DetectorAnnotationLink>();
        for (DetectorAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<DetectorAnnotationLink> toRemove = this.findDetectorAnnotationLink(removal);
        Iterator<DetectorAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeDetectorAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeDetectorAnnotationLinkFromBoth(DetectorAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (DetectorAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.acquisition.Detector) {
            ome.model.acquisition.Detector source = (ome.model.acquisition.Detector)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyManufacturer(source, mapper);
                this.copyModel(source, mapper);
                this.copyLotNumber(source, mapper);
                this.copySerialNumber(source, mapper);
                this.copyVoltage(source, mapper);
                this.copyGain(source, mapper);
                this.copyOffsetValue(source, mapper);
                this.copyZoom(source, mapper);
                this.copyAmplificationGain(source, mapper);
                this.copyType(source, mapper);
                this.copyInstrument(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Detector cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.acquisition.Detector target = new ome.model.acquisition.Detector();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillManufacturer(target, mapper);
            this.fillModel(target, mapper);
            this.fillLotNumber(target, mapper);
            this.fillSerialNumber(target, mapper);
            this.fillVoltage(target, mapper);
            this.fillGain(target, mapper);
            this.fillOffsetValue(target, mapper);
            this.fillZoom(target, mapper);
            this.fillAmplificationGain(target, mapper);
            this.fillType(target, mapper);
            this.fillInstrument(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<DetectorI> cast(List list) {
        return list;
    }
}

