/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.sql.Timestamp;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RTime;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.DBPatch;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.rtypes;
import omero.util.IceMapper;

public class DBPatchI
extends DBPatch
implements ModelBased {
    public static final String CURRENTVERSION = "ome.model.meta.DBPatch_currentVersion";
    public static final String CURRENTPATCH = "ome.model.meta.DBPatch_currentPatch";
    public static final String PREVIOUSVERSION = "ome.model.meta.DBPatch_previousVersion";
    public static final String PREVIOUSPATCH = "ome.model.meta.DBPatch_previousPatch";
    public static final String FINISHED = "ome.model.meta.DBPatch_finished";
    public static final String MESSAGE = "ome.model.meta.DBPatch_message";
    public static final String DETAILS = "ome.model.meta.DBPatch_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public DBPatchI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public DBPatchI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public DBPatchI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadCurrentVersion();
        this.unloadCurrentPatch();
        this.unloadPreviousVersion();
        this.unloadPreviousPatch();
        this.unloadFinished();
        this.unloadMessage();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return true;
    }

    @Override
    public boolean isMutable(Current current) {
        return false;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        DBPatchI copy = new DBPatchI();
        copy.id = this.id;
        copy.currentVersion = this.currentVersion;
        copy.currentPatch = this.currentPatch;
        copy.previousVersion = this.previousVersion;
        copy.previousPatch = this.previousPatch;
        copy.finished = this.finished;
        copy.message = this.message;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new DBPatchI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)((Object)this.getDetails()));
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    public void unloadCurrentVersion() {
        this.currentVersion = null;
    }

    @Override
    public RString getCurrentVersion(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.currentVersion;
    }

    @Override
    public void setCurrentVersion(RString currentVersion, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.currentVersion = currentVersion;
    }

    private void copyCurrentVersion(ome.model.meta.DBPatch source, IceMapper mapper) {
        this.currentVersion = source.getCurrentVersion() == null ? null : rtypes.rstring(source.getCurrentVersion());
    }

    private void fillCurrentVersion(ome.model.meta.DBPatch target, IceMapper mapper) {
        try {
            target.setCurrentVersion((String)mapper.fromRType(this.getCurrentVersion()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadCurrentPatch() {
        this.currentPatch = null;
    }

    @Override
    public RInt getCurrentPatch(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.currentPatch;
    }

    @Override
    public void setCurrentPatch(RInt currentPatch, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.currentPatch = currentPatch;
    }

    private void copyCurrentPatch(ome.model.meta.DBPatch source, IceMapper mapper) {
        this.currentPatch = source.getCurrentPatch() == null ? null : rtypes.rint(source.getCurrentPatch());
    }

    private void fillCurrentPatch(ome.model.meta.DBPatch target, IceMapper mapper) {
        try {
            target.setCurrentPatch((Integer)mapper.fromRType(this.getCurrentPatch()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPreviousVersion() {
        this.previousVersion = null;
    }

    @Override
    public RString getPreviousVersion(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.previousVersion;
    }

    @Override
    public void setPreviousVersion(RString previousVersion, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.previousVersion = previousVersion;
    }

    private void copyPreviousVersion(ome.model.meta.DBPatch source, IceMapper mapper) {
        this.previousVersion = source.getPreviousVersion() == null ? null : rtypes.rstring(source.getPreviousVersion());
    }

    private void fillPreviousVersion(ome.model.meta.DBPatch target, IceMapper mapper) {
        try {
            target.setPreviousVersion((String)mapper.fromRType(this.getPreviousVersion()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadPreviousPatch() {
        this.previousPatch = null;
    }

    @Override
    public RInt getPreviousPatch(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.previousPatch;
    }

    @Override
    public void setPreviousPatch(RInt previousPatch, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.previousPatch = previousPatch;
    }

    private void copyPreviousPatch(ome.model.meta.DBPatch source, IceMapper mapper) {
        this.previousPatch = source.getPreviousPatch() == null ? null : rtypes.rint(source.getPreviousPatch());
    }

    private void fillPreviousPatch(ome.model.meta.DBPatch target, IceMapper mapper) {
        try {
            target.setPreviousPatch((Integer)mapper.fromRType(this.getPreviousPatch()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadFinished() {
        this.finished = null;
    }

    @Override
    public RTime getFinished(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.finished;
    }

    @Override
    public void setFinished(RTime finished, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.finished = finished;
    }

    private void copyFinished(ome.model.meta.DBPatch source, IceMapper mapper) {
        this.finished = source.getFinished() == null ? null : rtypes.rtime(source.getFinished().getTime());
    }

    private void fillFinished(ome.model.meta.DBPatch target, IceMapper mapper) {
        try {
            target.setFinished((Timestamp)mapper.fromRType(this.getFinished()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadMessage() {
        this.message = null;
    }

    @Override
    public RString getMessage(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.message;
    }

    @Override
    public void setMessage(RString message, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.message = message;
    }

    private void copyMessage(ome.model.meta.DBPatch source, IceMapper mapper) {
        this.message = source.getMessage() == null ? null : rtypes.rstring(source.getMessage());
    }

    private void fillMessage(ome.model.meta.DBPatch target, IceMapper mapper) {
        try {
            target.setMessage((String)mapper.fromRType(this.getMessage()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    @Override
    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.meta.DBPatch) {
            ome.model.meta.DBPatch source = (ome.model.meta.DBPatch)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.copyCurrentVersion(source, mapper);
                this.copyCurrentPatch(source, mapper);
                this.copyPreviousVersion(source, mapper);
                this.copyPreviousPatch(source, mapper);
                this.copyFinished(source, mapper);
                this.copyMessage(source, mapper);
                this.copyDetails(source, mapper);
            }
        } else {
            throw new IllegalArgumentException("DBPatch cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    @Override
    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.meta.DBPatch target = new ome.model.meta.DBPatch();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            this.fillCurrentVersion(target, mapper);
            this.fillCurrentPatch(target, mapper);
            this.fillPreviousVersion(target, mapper);
            this.fillPreviousPatch(target, mapper);
            this.fillFinished(target, mapper);
            this.fillMessage(target, mapper);
            this.fillDetails(target, mapper);
        }
        return target;
    }

    public static List<DBPatchI> cast(List list) {
        return list;
    }
}

