/*
 * Decompiled with CFR 0.152.
 */
package omero.grid;

import Glacier2.IdentitySetPrx;
import Glacier2.SessionControlPrx;
import Ice.Current;
import Ice.Identity;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ome.api.JobHandle;
import ome.api.RawFileStore;
import ome.api.local.LocalAdmin;
import ome.model.core.OriginalFile;
import ome.model.meta.Session;
import ome.parameters.Parameters;
import ome.services.blitz.util.ParamsCache;
import ome.services.scripts.ScriptRepoHelper;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import omero.ApiUsageException;
import omero.InternalException;
import omero.RMap;
import omero.RType;
import omero.ServerError;
import omero.ValidationException;
import omero.grid.JobParams;
import omero.grid.ParamsHelper;
import omero.grid.ProcessPrx;
import omero.grid.ProcessPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid._InteractiveProcessorOperations;
import omero.model.Job;
import omero.model.OriginalFileI;
import omero.model.ParseJob;
import omero.rtypes;
import omero.util.CloseableServant;
import omero.util.IceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class InteractiveProcessorI
implements _InteractiveProcessorOperations,
CloseableServant {
    private static Session UNINITIALIZED = new Session();
    private static Logger log = LoggerFactory.getLogger(InteractiveProcessorI.class);
    private final SessionManager mgr;
    private final ProcessorPrx prx;
    private final ParamsCache paramsCache;
    private final ParamsHelper paramsHelper;
    private final ScriptRepoHelper scriptRepoHelper;
    private final Executor ex;
    private final Job job;
    private final long scriptId;
    private final String scriptSha1;
    private final String mimetype;
    private final String launcher;
    private final String process;
    private final long timeout;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Principal principal;
    private final SessionControlPrx control;
    private boolean detach = false;
    private boolean obtainResults = false;
    private boolean stop = false;
    private ProcessPrx currentProcess = null;
    private Session session;
    private JobParams params;
    private long started;
    private static final String stdfile_query = "select file from Job job join job.originalFileLinks links join links.child file where file.name = :name and job.id = :id";

    public InteractiveProcessorI(Principal p, SessionManager mgr, Executor ex, ProcessorPrx prx, Job job, long timeout, SessionControlPrx control, ParamsCache paramsCache, ParamsHelper paramsHelper, ScriptRepoHelper scriptRepoHelper, Current current) throws ServerError {
        this.paramsCache = paramsCache;
        this.paramsHelper = paramsHelper;
        this.scriptRepoHelper = scriptRepoHelper;
        this.principal = p;
        this.ex = ex;
        this.mgr = mgr;
        this.prx = prx;
        this.job = job;
        this.timeout = timeout;
        this.control = control;
        this.session = UNINITIALIZED;
        OriginalFile f = this.getScriptId(job, current);
        this.scriptId = f.getId();
        this.scriptSha1 = f.getHash();
        this.mimetype = f.getMimetype();
        this.launcher = scriptRepoHelper.getLauncher(this.mimetype);
        this.process = scriptRepoHelper.getProcess(this.mimetype);
    }

    private void setLauncher(Current __current) {
        __current.ctx.put("omero.launcher", this.launcher);
        __current.ctx.put("omero.process", this.process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobParams params(Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            if (this.stop) {
                throw new ApiUsageException(null, null, "This processor is stopped.");
            }
            if (this.session == UNINITIALIZED) {
                this.session = this.newSession(__current);
            }
            if (this.params == null) {
                try {
                    if (this.job instanceof ParseJob) {
                        this.setLauncher(__current);
                        this.params = this.prx.parseJob(this.session.getUuid(), this.job, __current.ctx);
                        if (this.params == null) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Can't find params for ");
                            sb.append(this.scriptId);
                            sb.append("!\n");
                            for (String which : new String[]{"stdout", "stderr"}) {
                                OriginalFile file2 = this.loadFileOrNull(which, __current);
                                if (file2 == null) {
                                    sb.append("No ");
                                    sb.append(which);
                                    sb.append(".\n");
                                    continue;
                                }
                                sb.append(which);
                                sb.append(" is in file " + file2.getId());
                                sb.append(":");
                                sb.append("\n---------------------------------\n");
                                this.appendIfText(file2, sb, __current);
                                sb.append("\n---------------------------------\n");
                            }
                            throw new ValidationException(null, null, sb.toString());
                        }
                        this.paramsHelper.saveScriptParams(this.params, (ParseJob)this.job, __current);
                    } else {
                        this.params = this.paramsCache.getParams(this.scriptId, this.scriptSha1, __current);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ServerError) {
                        log.debug("Error while parsing job", t);
                        throw (ServerError)t;
                    }
                    InternalException ie = new InternalException();
                    IceMapper.fillServerError(ie, t);
                    throw ie;
                }
            }
            JobParams jobParams = this.params;
            return jobParams;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessPrx execute(RMap inputs, Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            ProcessPrx processPrx;
            if (this.currentProcess != null) {
                throw new ApiUsageException(null, null, "Process currently running.");
            }
            if (this.obtainResults) {
                throw new ApiUsageException(null, null, "Please retrieve results.");
            }
            if (this.stop) {
                throw new ApiUsageException(null, null, "This processor is stopped.");
            }
            if (this.session == UNINITIALIZED) {
                this.session = this.newSession(__current);
            }
            if (inputs != null && inputs.getValue() != null) {
                IceMapper mapper = new IceMapper();
                for (String key : inputs.getValue().keySet()) {
                    Object v = mapper.fromRType(inputs.get(key));
                    this.mgr.setInput(this.session.getUuid(), key, v);
                }
            }
            try {
                String uuid = this.session.getUuid();
                if (this.params == null) {
                    this.params = this.params(__current);
                }
                this.setLauncher(__current);
                this.currentProcess = this.prx.processJob(uuid, this.params, this.job, __current.ctx);
                if (this.control == null) {
                    log.error("Control null on execute");
                } else {
                    IdentitySetPrx identities = this.control.identities();
                    if (identities == null) {
                        log.error("Identities null on execute");
                    } else {
                        identities.add(new Identity[]{this.currentProcess.ice_getIdentity()});
                    }
                }
            }
            catch (ValidationException ve) {
                this.failJob(ve, __current);
                throw ve;
            }
            catch (ServerError se) {
                log.debug("Error while processing job", se);
                throw se;
            }
            if (this.currentProcess == null) {
                processPrx = null;
                return processPrx;
            }
            this.obtainResults = true;
            processPrx = this.currentProcess;
            return processPrx;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMap getResults(ProcessPrx proc, Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        try {
            this.finishedOrThrow();
            RMap output = rtypes.rmap(new HashMap<String, RType>());
            Map<String, Object> env = this.mgr.outputEnvironment(this.session.getUuid());
            IceMapper mapper = new IceMapper();
            for (String key : env.keySet()) {
                RType rt = mapper.toRType(env.get(key));
                output.put(key, rt);
            }
            this.optionallyLoadFile(output.getValue(), "stdout", __current);
            this.optionallyLoadFile(output.getValue(), "stderr", __current);
            this.currentProcess = null;
            this.obtainResults = false;
            RMap rMap = output;
            return rMap;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public long expires(Current __current) {
        return this.started + this.timeout;
    }

    @Override
    public Job getJob(Current __current) {
        return this.job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDetach(boolean detach, Current __current) {
        this.rwl.writeLock().lock();
        try {
            boolean old = this.detach;
            this.detach = detach;
            boolean bl = old;
            return bl;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void stop(Current __current) throws ServerError {
        this.rwl.writeLock().lock();
        if (this.stop) {
            return;
        }
        try {
            if (this.detach) {
                if (this.currentProcess != null) {
                    log.info("Detaching from " + this.currentProcess);
                }
            } else {
                this.doStop();
            }
            this.stop = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    protected void doStop() throws ServerError {
        Exception pException = null;
        Exception sException = null;
        if (this.currentProcess != null) {
            try {
                ProcessPrx p = ProcessPrxHelper.uncheckedCast(this.currentProcess.ice_oneway());
                p.shutdown();
                this.currentProcess = null;
            }
            catch (Exception ex) {
                log.warn("Failed to stop process", ex);
                pException = ex;
            }
        }
        if (this.session != null && this.session != UNINITIALIZED) {
            try {
                while (this.mgr.close(this.session.getUuid()) > 0) {
                }
                this.session = null;
            }
            catch (Exception ex) {
                log.warn("Failed to close session " + this.session.getUuid(), ex);
                sException = ex;
            }
        }
        if (pException != null || sException != null) {
            InternalException ie = new InternalException();
            StringBuilder sb = new StringBuilder();
            if (pException != null) {
                sb.append("Failed to shutdown process: " + pException.getMessage());
            }
            if (sException != null) {
                sb.append("Failed to close session: " + sException.getMessage());
            }
            ie.message = sb.toString();
            throw ie;
        }
    }

    private void finishedOrThrow() throws ServerError {
        if (this.currentProcess == null) {
            throw new ApiUsageException(null, null, "No current process.");
        }
        if (this.currentProcess.poll() == null) {
            throw new ApiUsageException(null, null, "Process still running.");
        }
    }

    private OriginalFile loadFileOrNull(final String name, Current current) {
        return (OriginalFile)this.ex.execute(current.ctx, this.principal, new Executor.SimpleWork(this, "optionallyLoadFile", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return sf.getQueryService().findByQuery(InteractiveProcessorI.stdfile_query, new Parameters().addId(InteractiveProcessorI.this.job.getId().getValue()).addString("name", name));
            }
        });
    }

    private void optionallyLoadFile(Map<String, RType> val, String name, Current current) {
        OriginalFile file2 = this.loadFileOrNull(name, current);
        if (file2 != null) {
            val.put(name, rtypes.robject(new OriginalFileI(file2.getId(), false)));
        }
    }

    private void appendIfText(final OriginalFile file2, final StringBuilder sb, Current current) {
        if (file2.getMimetype() != null && file2.getMimetype().contains("text")) {
            this.ex.execute(current.ctx, this.principal, new Executor.SimpleWork(this, "appendIfText", new Object[]{file2}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Transactional(readOnly=true)
                public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                    try (RawFileStore rfs = sf.createRawFileStore();){
                        rfs.setFileId(file2.getId());
                        sb.append(new String(rfs.read(0L, file2.getSize().intValue())));
                    }
                    return null;
                }
            });
        }
    }

    private void failJob(final ValidationException ve, Current current) {
        this.ex.execute(current.ctx, this.principal, new Executor.SimpleWork(this, "failJob", new Object[]{this.job.getId().getValue()}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Transactional(readOnly=false)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                try (JobHandle jh = sf.createJobHandle();){
                    jh.attach(InteractiveProcessorI.this.job.getId().getValue());
                    jh.setStatusAndMessage("Error", ve.message == null ? null : ve.message.substring(0, Math.min(255, ve.message.length())));
                }
                return null;
            }
        });
    }

    private EventContext getEventContext(Current current) {
        return (EventContext)this.ex.execute(current.ctx, this.principal, new Executor.SimpleWork(this, "getEventContext", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return ((LocalAdmin)sf.getAdminService()).getEventContextQuiet();
            }
        });
    }

    private Session newSession(Current __current) {
        EventContext ec = this.getEventContext(__current);
        Session newSession = this.mgr.createWithAgent(new Principal(ec.getCurrentUserName(), ec.getCurrentGroupName(), "Processing"), "OMERO.scripts", null);
        newSession.setTimeToIdle(0L);
        newSession.setTimeToLive(this.timeout);
        newSession = this.mgr.update(newSession, true);
        this.started = System.currentTimeMillis();
        return newSession;
    }

    private OriginalFile getScriptId(Job job, Current current) throws ValidationException {
        final QueryBuilder qb = new QueryBuilder();
        qb.select("o").from("Job", "j");
        qb.join("j.originalFileLinks", "links", false, false);
        qb.join("links.child", "o", false, false);
        qb.where();
        qb.and("j.id = :id").param("id", (Object)job.getId().getValue());
        this.scriptRepoHelper.buildQuery(qb);
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.putAll(current.ctx);
        ctx.put("omero.group", "-1");
        OriginalFile f = (OriginalFile)this.ex.execute(ctx, this.principal, new Executor.SimpleWork(this, "getScriptId", new Object[0]){

            @Transactional(readOnly=true)
            public Object doWork(org.hibernate.Session session, ServiceFactory sf) {
                return qb.query(session).uniqueResult();
            }
        });
        if (f == null) {
            throw new ValidationException(null, null, "No script for job :" + job.getId().getValue());
        }
        return f;
    }

    @Override
    public void close(Current current) throws Exception {
        this.stop(current);
    }
}

