/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.io.File;
import java.util.regex.Pattern;

public class Utils {
    public static String getFolderAsContainerName(File file2) {
        if (file2.isFile()) {
            File parentFile = file2.getParentFile();
            if (parentFile == null) {
                return null;
            }
            return parentFile.getName();
        }
        return file2.getName();
    }

    public static String getDisplayedFileName(String fullPath, Integer number) {
        if (fullPath == null) {
            return fullPath;
        }
        if (number == null || number < 0) {
            return fullPath;
        }
        String[] l = Utils.splitString(fullPath);
        String extension = null;
        if (fullPath.endsWith("\\")) {
            extension = "\\";
        } else if (fullPath.endsWith("/")) {
            extension = "/";
        }
        String start = null;
        if (fullPath.startsWith("\\")) {
            start = "\\";
        } else if (fullPath.startsWith("/")) {
            start = "/";
        }
        String sep = Utils.getStringSeparator(fullPath);
        if (sep == null) {
            sep = "";
        }
        String text = "";
        int folder = -1;
        if (number != null && number >= 0) {
            folder = number;
        }
        if (folder == -1) {
            return null;
        }
        if (l != null && l.length > 1) {
            int n = 0;
            if (folder < l.length) {
                n = l.length - folder - 2;
            }
            if (n < 0) {
                n = 0;
            }
            int m = l.length - 1;
            for (int i = l.length - 1; i > n; --i) {
                text = i == m ? l[i] : l[i] + sep + text;
            }
            if (n == 0 && start != null) {
                text = start + text;
            }
            if (extension != null) {
                text = text + extension;
            }
            return text;
        }
        return null;
    }

    public static String[] splitString(String originalName) {
        String[] l = null;
        if (originalName == null) {
            return l;
        }
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
        } else if (Pattern.compile("\\\\").matcher(originalName).find()) {
            l = originalName.split("\\\\", 0);
        }
        return l;
    }

    public static String getStringSeparator(String originalName) {
        if (originalName == null) {
            return null;
        }
        String[] l = null;
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
            if (l.length > 0) {
                return "/";
            }
        } else if (Pattern.compile("\\\\").matcher(originalName).find() && (l = originalName.split("\\\\", 0)).length > 0) {
            return "\\";
        }
        return null;
    }
}

