/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.rnd;

import omero.gateway.rnd.BytesConverter;
import omero.util.ReadOnlyByteArray;

public class Plane2D {
    private int bytesPerPixel;
    private int sizeX;
    private ReadOnlyByteArray data;
    private BytesConverter strategy;
    private double[][] mappedData;

    private int calculateOffset(int x, int y) {
        return this.bytesPerPixel * (this.sizeX * y + x);
    }

    private void mappedData(int sizeY) {
        this.mappedData = new double[this.sizeX][sizeY];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                int offset = this.calculateOffset(x, y);
                this.mappedData[x][y] = this.strategy.pack(this.data, offset, this.bytesPerPixel);
            }
        }
    }

    public Plane2D(ReadOnlyByteArray data, int sizeX, int sizeY, int bytesPerPixel, BytesConverter strategy) {
        this.bytesPerPixel = bytesPerPixel;
        this.data = data;
        this.strategy = strategy;
        this.sizeX = sizeX;
        this.mappedData(sizeY);
    }

    public double getPixelValue(int x, int y) {
        return this.mappedData[x][y];
    }

    public byte getRawValue(int offset) {
        return this.data.get(offset);
    }
}

