/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.RDouble;
import omero.RString;
import omero.gateway.model.ShapeData;
import omero.model.Label;
import omero.model.LabelI;
import omero.model.Shape;
import omero.rtypes;

public class TextData
extends ShapeData {
    public TextData(Shape shape) {
        super(shape);
    }

    public TextData() {
        this("String", 0.0, 0.0);
    }

    public TextData(String text, double x, double y) {
        super(new LabelI(), true);
        this.setX(x);
        this.setY(y);
        this.setText(text);
    }

    public String getText() {
        Label shape = (Label)this.asIObject();
        RString value = shape.getTextValue();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setText(String text) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Label shape = (Label)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTextValue(rtypes.rstring(text));
    }

    public double getX() {
        Label shape = (Label)this.asIObject();
        RDouble value = shape.getX();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setX(double x) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Label shape = (Label)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setX(rtypes.rdouble(x));
    }

    public double getY() {
        Label shape = (Label)this.asIObject();
        RDouble value = shape.getY();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setY(double y) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Label shape = (Label)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setY(rtypes.rdouble(y));
    }
}

